/*     */ package org.jboss.metatype.api.values;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.SortedMap;
/*     */ import java.util.TreeMap;
/*     */ import org.jboss.metatype.api.types.CompositeMetaType;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ 
/*     */ public class CompositeValueSupport extends AbstractMetaValue
/*     */   implements CompositeValue
/*     */ {
/*     */   private static final long serialVersionUID = 6262188760975631870L;
/*  53 */   private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("contents", SortedMap.class), new ObjectStreamField("metaType", CompositeMetaType.class) };
/*     */   private SortedMap<String, MetaValue> contents;
/*     */   private CompositeMetaType metaType;
/*  67 */   private transient int cachedHashCode = -2147483648;
/*     */ 
/*     */   public CompositeValueSupport(CompositeMetaType metaType, String[] itemNames, MetaValue[] itemValues)
/*     */   {
/*  79 */     if (metaType == null)
/*  80 */       throw new IllegalArgumentException("null meta type");
/*  81 */     if (itemNames == null)
/*  82 */       itemNames = new String[0];
/*  83 */     if (itemValues == null)
/*  84 */       itemValues = new MetaValue[0];
/*  85 */     if (itemNames.length != itemValues.length) {
/*  86 */       throw new IllegalArgumentException("itemNames has size " + itemNames.length + " but itemValues has size " + itemValues.length);
/*     */     }
/*  88 */     Set compositeNames = metaType.keySet();
/*  89 */     int compositeNameSize = compositeNames.size();
/*  90 */     if (itemNames.length > compositeNameSize) {
/*  91 */       throw new IllegalArgumentException("itemNames has size " + itemNames.length + " but composite type has size " + compositeNameSize);
/*     */     }
/*  93 */     this.metaType = metaType;
/*  94 */     this.contents = new TreeMap();
/*     */ 
/*  96 */     for (int i = 0; i < itemNames.length; i++)
/*     */     {
/*  98 */       if ((itemNames[i] == null) || (itemNames[i].length() == 0))
/*  99 */         throw new IllegalArgumentException("Item name " + i + " is null or empty");
/* 100 */       if (this.contents.get(itemNames[i]) != null)
/* 101 */         throw new IllegalArgumentException("duplicate item name " + itemNames[i]);
/* 102 */       MetaType itemType = metaType.getType(itemNames[i]);
/* 103 */       if (itemType == null)
/* 104 */         throw new IllegalArgumentException("item name not in composite type: " + itemNames[i]);
/* 105 */       if ((itemValues[i] != null) && (!itemType.isValue(itemValues[i])))
/* 106 */         throw new IllegalArgumentException("item value " + itemValues[i] + " for item name " + itemNames[i] + " is not a " + itemType);
/* 107 */       this.contents.put(itemNames[i], itemValues[i]);
/*     */     }
/*     */     List itemList;
/* 110 */     if (itemNames.length < compositeNameSize)
/*     */     {
/* 112 */       itemList = Arrays.asList(itemNames);
/* 113 */       for (String name : compositeNames)
/*     */       {
/* 115 */         if (!itemList.contains(name))
/* 116 */           this.contents.put(name, null);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public CompositeValueSupport(CompositeMetaType metaType)
/*     */   {
/* 129 */     this(metaType, null, null);
/*     */   }
/*     */ 
/*     */   public CompositeValueSupport(CompositeMetaType compositeMetaType, Map<String, MetaValue> items)
/*     */   {
/* 141 */     init(compositeMetaType, items);
/*     */   }
/*     */ 
/*     */   public CompositeMetaType getMetaType()
/*     */   {
/* 146 */     return this.metaType;
/*     */   }
/*     */ 
/*     */   public MetaValue get(String key)
/*     */   {
/* 151 */     validateKey(key);
/* 152 */     return (MetaValue)this.contents.get(key);
/*     */   }
/*     */ 
/*     */   public void set(String key, MetaValue value)
/*     */   {
/* 163 */     MetaType itemType = validateKey(key);
/* 164 */     if ((value != null) && (!itemType.isValue(value)))
/* 165 */       throw new IllegalArgumentException("item value " + value + " for item name " + key + " is not a " + itemType);
/* 166 */     this.contents.put(key, value);
/*     */   }
/*     */ 
/*     */   public MetaValue[] getAll(String[] keys)
/*     */   {
/* 171 */     if (keys == null) {
/* 172 */       throw new IllegalArgumentException("Null keys");
/*     */     }
/* 174 */     MetaValue[] result = new MetaValue[keys.length];
/* 175 */     for (int i = 0; i < keys.length; i++)
/*     */     {
/* 177 */       validateKey(keys[i]);
/* 178 */       result[i] = ((MetaValue)this.contents.get(keys[i]));
/*     */     }
/* 180 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean containsKey(String key)
/*     */   {
/* 185 */     if ((key == null) || (key.length() == 0))
/* 186 */       return false;
/* 187 */     return this.contents.containsKey(key);
/*     */   }
/*     */ 
/*     */   public boolean containsValue(MetaValue value)
/*     */   {
/* 192 */     return this.contents.containsValue(value);
/*     */   }
/*     */ 
/*     */   public Collection<MetaValue> values()
/*     */   {
/* 197 */     return Collections.unmodifiableCollection(this.contents.values());
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 203 */     if (obj == this)
/* 204 */       return true;
/* 205 */     if ((obj == null) || (!(obj instanceof CompositeValue))) {
/* 206 */       return false;
/*     */     }
/* 208 */     CompositeValue other = (CompositeValue)obj;
/* 209 */     if (!getMetaType().equals(other.getMetaType())) {
/* 210 */       return false;
/*     */     }
/* 212 */     for (String key : getMetaType().keySet())
/*     */     {
/* 214 */       Object thisValue = get(key);
/* 215 */       Object otherValue = other.get(key);
/*     */ 
/* 217 */       if ((((thisValue == null) && (otherValue == null)) || ((thisValue != null) && (thisValue.equals(otherValue))) ? 1 : 0) == 0)
/* 218 */         return false;
/*     */     }
/* 220 */     return true;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 226 */     if (this.cachedHashCode != -2147483648) {
/* 227 */       return this.cachedHashCode;
/*     */     }
/* 229 */     this.cachedHashCode = getMetaType().hashCode();
/* 230 */     for (String key : getMetaType().keySet())
/*     */     {
/* 232 */       Object value = this.contents.get(key);
/* 233 */       if (value != null) {
/* 234 */         this.cachedHashCode += value.hashCode();
/*     */       }
/*     */     }
/* 237 */     return this.cachedHashCode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 243 */     CompositeMetaType metaType = getMetaType();
/* 244 */     StringBuilder buffer = new StringBuilder(getClass().getSimpleName());
/* 245 */     buffer.append(": metaType=[");
/* 246 */     buffer.append(metaType);
/* 247 */     buffer.append("] items=[");
/* 248 */     Iterator keys = metaType.keySet().iterator();
/* 249 */     while (keys.hasNext())
/*     */     {
/* 251 */       Object key = keys.next();
/* 252 */       buffer.append(key).append("=");
/* 253 */       Object value = this.contents.get(key);
/* 254 */       buffer.append(value);
/* 255 */       if (keys.hasNext())
/* 256 */         buffer.append(",");
/*     */     }
/* 258 */     buffer.append("]");
/* 259 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   private MetaType validateKey(String key)
/*     */   {
/* 272 */     if ((key == null) || (key.length() == 0))
/* 273 */       throw new IllegalArgumentException("null or empty key");
/* 274 */     CompositeMetaType metaType = getMetaType();
/* 275 */     MetaType result = metaType.getType(key);
/* 276 */     if (result == null)
/* 277 */       throw new IllegalArgumentException("no such item name " + key + " for composite type " + metaType);
/* 278 */     return result;
/*     */   }
/*     */ 
/*     */   private void init(CompositeMetaType metaType, Map<String, MetaValue> items)
/*     */   {
/* 290 */     if (metaType == null)
/* 291 */       throw new IllegalArgumentException("null meta type");
/* 292 */     if (items == null) {
/* 293 */       items = Collections.emptyMap();
/*     */     }
/* 295 */     Set compositeNames = metaType.keySet();
/* 296 */     int compositeNameSize = compositeNames.size();
/* 297 */     if (items.size() > compositeNameSize) {
/* 298 */       throw new IllegalArgumentException("items has size " + items.size() + " but composite type has size " + compositeNameSize);
/*     */     }
/* 300 */     this.metaType = metaType;
/* 301 */     this.contents = new TreeMap();
/*     */ 
/* 303 */     for (Map.Entry entry : items.entrySet())
/*     */     {
/* 305 */       String key = (String)entry.getKey();
/* 306 */       if ((key == null) || (key.length() == 0))
/* 307 */         throw new IllegalArgumentException("Key is null or empty");
/* 308 */       MetaType itemType = metaType.getType(key);
/* 309 */       if (itemType == null)
/* 310 */         throw new IllegalArgumentException("item name not in composite type " + key);
/* 311 */       MetaValue value = (MetaValue)items.get(key);
/* 312 */       if ((value != null) && (!itemType.isValue(value)))
/* 313 */         throw new IllegalArgumentException("item value " + value + " for item name " + key + " is not a " + itemType);
/* 314 */       this.contents.put(key, value);
/*     */     }
/*     */ 
/* 317 */     if (items.size() < compositeNameSize)
/*     */     {
/* 319 */       for (String name : compositeNames)
/*     */       {
/* 321 */         if (!items.containsKey(name))
/* 322 */           this.contents.put(name, null);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 330 */     ObjectInputStream.GetField getField = in.readFields();
/* 331 */     SortedMap contents = (SortedMap)getField.get("contents", null);
/* 332 */     CompositeMetaType compositeType = (CompositeMetaType)getField.get("metaType", null);
/*     */     try
/*     */     {
/* 335 */       init(compositeType, contents);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 339 */       throw new RuntimeException("Error deserializing composite value", e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.values.CompositeValueSupport
 * JD-Core Version:    0.6.0
 */