/*     */ package org.jboss.metatype.api.values;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.metatype.api.types.CompositeMetaType;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.types.TableMetaType;
/*     */ 
/*     */ public class TableValueSupport extends AbstractMetaValue
/*     */   implements TableValue
/*     */ {
/*     */   private static final long serialVersionUID = -6862672408820383430L;
/*  51 */   private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("dataMap", HashMap.class), new ObjectStreamField("tableType", TableMetaType.class) };
/*     */   private HashMap<List<MetaValue>, CompositeValue> dataMap;
/*     */   private TableMetaType tableType;
/*     */   private transient String[] indexNames;
/*     */ 
/*     */   public TableValueSupport(TableMetaType tableType)
/*     */   {
/*  76 */     this(tableType, 101, 0.75F);
/*     */   }
/*     */ 
/*     */   public TableValueSupport(TableMetaType tableType, int initialCapacity, float loadFactor)
/*     */   {
/*  89 */     init(new HashMap(initialCapacity, loadFactor), tableType);
/*     */   }
/*     */ 
/*     */   public TableMetaType getMetaType()
/*     */   {
/*  94 */     return this.tableType;
/*     */   }
/*     */ 
/*     */   public MetaValue[] calculateIndex(CompositeValue value)
/*     */   {
/*  99 */     validateCompositeValue(value);
/* 100 */     return value.getAll(this.indexNames);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 105 */     this.dataMap.clear();
/*     */   }
/*     */ 
/*     */   public boolean containsKey(MetaValue[] key)
/*     */   {
/* 110 */     if (key == null)
/* 111 */       return false;
/* 112 */     return this.dataMap.containsKey(Arrays.asList(key));
/*     */   }
/*     */ 
/*     */   public boolean containsValue(CompositeValue value)
/*     */   {
/* 117 */     return this.dataMap.containsValue(value);
/*     */   }
/*     */ 
/*     */   public CompositeValue get(MetaValue[] key)
/*     */   {
/* 122 */     validateKey(key);
/* 123 */     return (CompositeValue)this.dataMap.get(Arrays.asList(key));
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 128 */     return this.dataMap.isEmpty();
/*     */   }
/*     */ 
/*     */   public Set<List<MetaValue>> keySet()
/*     */   {
/* 133 */     return this.dataMap.keySet();
/*     */   }
/*     */ 
/*     */   public void put(CompositeValue value)
/*     */   {
/* 138 */     List index = Arrays.asList(calculateIndex(value));
/* 139 */     if (this.dataMap.containsKey(index))
/* 140 */       throw new IllegalArgumentException("The index is already used " + index);
/* 141 */     this.dataMap.put(index, value);
/*     */   }
/*     */ 
/*     */   public void putAll(CompositeValue[] values)
/*     */   {
/* 146 */     if (values == null) {
/* 147 */       return;
/*     */     }
/* 149 */     HashSet keys = new HashSet();
/* 150 */     for (int i = 0; i < values.length; i++)
/*     */     {
/* 152 */       List index = Arrays.asList(calculateIndex(values[i]));
/* 153 */       if (keys.contains(index))
/* 154 */         throw new IllegalArgumentException("Duplicate index in values " + index + " for value " + values[i]);
/* 155 */       keys.add(index);
/* 156 */       if (this.dataMap.containsKey(index))
/* 157 */         throw new IllegalArgumentException("Index already used " + index + " for value " + values[i]);
/*     */     }
/* 159 */     for (int i = 0; i < values.length; i++)
/* 160 */       put(values[i]);
/*     */   }
/*     */ 
/*     */   public CompositeValue remove(MetaValue[] key)
/*     */   {
/* 165 */     validateKey(key);
/* 166 */     return (CompositeValue)this.dataMap.remove(Arrays.asList(key));
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 171 */     return this.dataMap.size();
/*     */   }
/*     */ 
/*     */   public Collection<CompositeValue> values()
/*     */   {
/* 176 */     return this.dataMap.values();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 182 */     if (this == obj)
/* 183 */       return true;
/* 184 */     if ((obj == null) || (!(obj instanceof TableValue))) {
/* 185 */       return false;
/*     */     }
/* 187 */     TableValue other = (TableValue)obj;
/* 188 */     if (!this.tableType.equals(other.getMetaType()))
/* 189 */       return false;
/* 190 */     if (size() != other.size())
/* 191 */       return false;
/* 192 */     for (Map.Entry entry : this.dataMap.entrySet())
/*     */     {
/* 194 */       List list = (List)entry.getKey();
/* 195 */       MetaValue[] indexes = (MetaValue[])list.toArray(new MetaValue[list.size()]);
/* 196 */       CompositeValue thisValue = (CompositeValue)entry.getValue();
/* 197 */       CompositeValue otherValue = other.get(indexes);
/* 198 */       if ((thisValue == null) && (otherValue == null))
/* 199 */         return true;
/* 200 */       if ((thisValue == null) && (otherValue != null))
/* 201 */         return false;
/* 202 */       if (!thisValue.equals(otherValue))
/* 203 */         return false;
/*     */     }
/* 205 */     return true;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 211 */     int hash = this.tableType.hashCode();
/* 212 */     for (CompositeValue value : this.dataMap.values())
/* 213 */       hash += value.hashCode();
/* 214 */     return hash;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 220 */     StringBuilder buffer = new StringBuilder(getClass().getSimpleName());
/* 221 */     buffer.append(": tableType=[");
/* 222 */     buffer.append(getMetaType());
/* 223 */     buffer.append("] mappings=[");
/* 224 */     Iterator entries = this.dataMap.entrySet().iterator();
/* 225 */     while (entries.hasNext())
/*     */     {
/* 227 */       Map.Entry entry = (Map.Entry)entries.next();
/* 228 */       buffer.append(entry.getKey());
/* 229 */       buffer.append("=");
/* 230 */       buffer.append(entry.getValue());
/* 231 */       if (entries.hasNext())
/* 232 */         buffer.append(",");
/*     */     }
/* 234 */     buffer.append("]");
/* 235 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public TableValueSupport clone()
/*     */   {
/* 242 */     TableValueSupport result = (TableValueSupport)super.clone();
/* 243 */     result.dataMap = ((HashMap)this.dataMap.clone());
/* 244 */     return result;
/*     */   }
/*     */ 
/*     */   private void init(HashMap<List<MetaValue>, CompositeValue> dataMap, TableMetaType tableType)
/*     */   {
/* 256 */     if (dataMap == null)
/* 257 */       throw new IllegalArgumentException("null dataMap");
/* 258 */     if (tableType == null) {
/* 259 */       throw new IllegalArgumentException("null table type");
/*     */     }
/* 261 */     this.dataMap = dataMap;
/* 262 */     this.tableType = tableType;
/* 263 */     List indexNameList = tableType.getIndexNames();
/* 264 */     this.indexNames = ((String[])indexNameList.toArray(new String[indexNameList.size()]));
/*     */   }
/*     */ 
/*     */   private void validateCompositeValue(CompositeValue value)
/*     */   {
/* 275 */     if (value == null)
/* 276 */       throw new IllegalArgumentException("null value");
/* 277 */     if (!value.getMetaType().equals(this.tableType.getRowType()))
/* 278 */       throw new IllegalArgumentException("value has composite type " + value.getMetaType() + " expected row type " + this.tableType.getRowType());
/*     */   }
/*     */ 
/*     */   private void validateKey(MetaValue[] key)
/*     */   {
/* 289 */     if ((key == null) || (key.length == 0)) {
/* 290 */       throw new IllegalArgumentException("null or empty key");
/*     */     }
/* 292 */     if (key.length != this.indexNames.length)
/* 293 */       throw new IllegalArgumentException("key has " + key.length + " elements, " + "should be " + this.indexNames.length);
/* 294 */     for (int i = 0; i < key.length; i++)
/*     */     {
/* 296 */       MetaType metaType = this.tableType.getRowType().getType(this.indexNames[i]);
/* 297 */       if ((key[i] != null) && (!metaType.isValue(key[i])))
/* 298 */         throw new IllegalArgumentException("key element " + i + " " + key + " is not a value for " + metaType);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 305 */     ObjectInputStream.GetField getField = in.readFields();
/* 306 */     HashMap dataMap = (HashMap)getField.get("dataMap", null);
/* 307 */     TableMetaType tableType = (TableMetaType)getField.get("tableType", null);
/*     */     try
/*     */     {
/* 310 */       init(dataMap, tableType);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 314 */       throw new RuntimeException("Unexpected error during deserialization", e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.api.values.TableValueSupport
 * JD-Core Version:    0.6.0
 */