/*     */ package org.jboss.metatype.plugins.types;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.util.Set;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ 
/*     */ public class MutableCompositeMetaType extends AbstractCompositeMetaType
/*     */ {
/*     */   private static final long serialVersionUID = -8580367706705513814L;
/*  42 */   private transient boolean frozen = false;
/*     */ 
/*  45 */   private transient int cachedHashCode = -2147483648;
/*     */ 
/*  48 */   private transient String cachedToString = null;
/*     */ 
/*     */   public MutableCompositeMetaType(String typeName, String description)
/*     */   {
/*  59 */     super(typeName, description);
/*     */   }
/*     */ 
/*     */   public void addItem(String itemName, String itemDescription, MetaType itemType)
/*     */   {
/*  65 */     if (this.frozen)
/*  66 */       throw new IllegalStateException("The type is frozen");
/*  67 */     super.addItem(itemName, itemDescription, itemType);
/*     */   }
/*     */ 
/*     */   public void setKeys(Set<String> keySet)
/*     */   {
/*  73 */     if (this.frozen)
/*  74 */       throw new IllegalStateException("The type is frozen");
/*  75 */     super.setKeys(keySet);
/*     */   }
/*     */ 
/*     */   public void freeze()
/*     */   {
/*  83 */     this.frozen = true;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  90 */     if (!this.frozen) {
/*  91 */       return super.equals(obj);
/*     */     }
/*  93 */     return equalsImpl(obj);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 100 */     if (!this.frozen) {
/* 101 */       return super.hashCode();
/*     */     }
/* 103 */     if (this.cachedHashCode != -2147483648)
/* 104 */       return this.cachedHashCode;
/* 105 */     this.cachedHashCode = hashCodeImpl();
/* 106 */     return this.cachedHashCode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 113 */     if (!this.frozen) {
/* 114 */       return super.toString();
/*     */     }
/* 116 */     if (this.cachedToString == null)
/* 117 */       this.cachedToString = super.toString();
/* 118 */     return this.cachedToString;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException
/*     */   {
/* 123 */     in.defaultReadObject();
/* 124 */     freeze();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.metatype.plugins.types.MutableCompositeMetaType
 * JD-Core Version:    0.6.0
 */