/*     */ package org.jboss.monitor;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import javax.management.JMException;
/*     */ import javax.management.MBeanRegistration;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EjbModule;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.InstanceCache;
/*     */ import org.jboss.ejb.StatefulSessionContainer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.monitor.client.BeanCacheSnapshot;
/*     */ 
/*     */ public class BeanCacheMonitor
/*     */   implements BeanCacheMonitorMBean, MBeanRegistration
/*     */ {
/*  56 */   static Logger log = Logger.getLogger(BeanCacheMonitor.class);
/*     */   MBeanServer m_mbeanServer;
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer server, ObjectName name)
/*     */     throws Exception
/*     */   {
/*  70 */     this.m_mbeanServer = server;
/*  71 */     return name;
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean registrationDone)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void preDeregister()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void postDeregister()
/*     */   {
/*     */   }
/*     */ 
/*     */   public BeanCacheSnapshot[] getSnapshots()
/*     */   {
/*     */     try
/*     */     {
/*  92 */       Collection snapshots = listSnapshots();
/*  93 */       BeanCacheSnapshot[] snapshotArray = new BeanCacheSnapshot[snapshots.size()];
/*  94 */       return (BeanCacheSnapshot[])(BeanCacheSnapshot[])snapshots.toArray(snapshotArray);
/*     */     }
/*     */     catch (JMException e)
/*     */     {
/*  98 */       log.error("Problem getting bean cache snapshots", e);
/*  99 */     }return null;
/*     */   }
/*     */ 
/*     */   public Collection listSnapshots()
/*     */     throws JMException
/*     */   {
/* 112 */     ArrayList cacheSnapshots = new ArrayList();
/*     */ 
/* 114 */     Collection ejbModules = this.m_mbeanServer.queryNames(EjbModule.EJB_MODULE_QUERY_NAME, null);
/*     */ 
/* 117 */     for (Iterator i = ejbModules.iterator(); i.hasNext(); )
/*     */     {
/* 119 */       ObjectName ejbModule = (ObjectName)i.next();
/* 120 */       name = ejbModule.getKeyProperty("jndiName");
/*     */ 
/* 125 */       Collection containers = (Collection)this.m_mbeanServer.getAttribute(ejbModule, "Containers");
/* 126 */       for (cs = containers.iterator(); cs.hasNext(); )
/*     */       {
/* 129 */         InstanceCache cache = null;
/* 130 */         Object container = cs.next();
/* 131 */         if ((container instanceof EntityContainer))
/*     */         {
/* 133 */           cache = ((EntityContainer)container).getInstanceCache();
/*     */         }
/* 135 */         else if ((container instanceof StatefulSessionContainer))
/*     */         {
/* 137 */           cache = ((StatefulSessionContainer)container).getInstanceCache();
/*     */         }
/*     */ 
/* 141 */         if ((cache instanceof Monitorable))
/*     */         {
/* 143 */           BeanCacheSnapshot snapshot = new BeanCacheSnapshot();
/* 144 */           snapshot.m_application = name;
/* 145 */           snapshot.m_container = ((Container)container).getBeanMetaData().getEjbName();
/* 146 */           ((Monitorable)cache).sample(snapshot);
/* 147 */           cacheSnapshots.add(snapshot);
/*     */         }
/*     */       }
/*     */     }
/*     */     String name;
/*     */     Iterator cs;
/* 151 */     return cacheSnapshots;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.monitor.BeanCacheMonitor
 * JD-Core Version:    0.6.0
 */