/*     */ package org.jboss.mx.interceptor;
/*     */ 
/*     */ import java.util.Hashtable;
/*     */ import java.util.Set;
/*     */ import javax.management.InstanceAlreadyExistsException;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.modelmbean.ModelMBean;
/*     */ import javax.management.modelmbean.ModelMBeanInfo;
/*     */ import javax.management.modelmbean.ModelMBeanInfoSupport;
/*     */ import javax.management.modelmbean.ModelMBeanOperationInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.modelmbean.RequiredModelMBeanInstantiator;
/*     */ import org.jboss.mx.server.Invocation;
/*     */ import org.jboss.mx.util.AgentID;
/*     */ 
/*     */ public abstract class AbstractSharedInterceptor extends AbstractInterceptor
/*     */   implements SharedInterceptor
/*     */ {
/*  64 */   protected MBeanServer server = null;
/*     */ 
/*  70 */   protected ObjectName objectName = null;
/*     */ 
/*     */   public AbstractSharedInterceptor()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractSharedInterceptor(String name)
/*     */   {
/*  95 */     super(name);
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectName()
/*     */   {
/* 103 */     return this.objectName;
/*     */   }
/*     */ 
/*     */   public MBeanServer getMBeanServer()
/*     */   {
/* 108 */     return this.server;
/*     */   }
/*     */ 
/*     */   public synchronized ObjectName register(MBeanServer server)
/*     */     throws InterceptorNameConflictException
/*     */   {
/* 143 */     this.server = server;
/*     */ 
/* 146 */     if (this.log == null) {
/* 147 */       this.log = Logger.getLogger("JBossMX.Interceptor." + this.name);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 152 */       this.objectName = createObjectName();
/*     */ 
/* 155 */       Set names = server.queryNames(this.objectName, null);
/*     */ 
/* 158 */       if (names.size() > 0) {
/* 159 */         throw new InterceptorNameConflictException("A shared interceptor named '" + this.name + "' already registered " + "to this MBean server (" + AgentID.get(server) + ")");
/*     */       }
/*     */ 
/* 165 */       ModelMBean rmm = RequiredModelMBeanInstantiator.instantiate();
/* 166 */       rmm.setManagedResource(this, "ObjectReference");
/* 167 */       rmm.setModelMBeanInfo(getManagementInterface());
/* 168 */       server.registerMBean(rmm, this.objectName);
/*     */ 
/* 171 */       this.isShared = true;
/*     */     }
/*     */     catch (InstanceAlreadyExistsException e)
/*     */     {
/* 179 */       throw new InterceptorNameConflictException("A shared interceptor named '" + this.name + "' already registered " + "to this MBean server (" + AgentID.get(server) + ")");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 189 */       if (this.log != null) {
/* 190 */         this.log.error(e.toString(), e);
/*     */       }
/*     */     }
/* 193 */     return this.objectName;
/*     */   }
/*     */ 
/*     */   public void init()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer server, ObjectName oname)
/*     */     throws Exception
/*     */   {
/* 247 */     this.server = server;
/*     */ 
/* 249 */     if (oname == null)
/* 250 */       this.objectName = createObjectName();
/*     */     else {
/* 252 */       this.objectName = oname;
/*     */     }
/* 254 */     init();
/*     */ 
/* 256 */     return this.objectName;
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean registrationSuccesful) {
/* 260 */     this.isShared = true;
/*     */ 
/* 262 */     start();
/*     */   }
/*     */ 
/*     */   public void preDeregister() throws Exception {
/* 266 */     stop();
/*     */ 
/* 268 */     this.isShared = false;
/* 269 */     this.objectName = null;
/*     */   }
/*     */ 
/*     */   public void postDeregister() {
/* 273 */     destroy();
/*     */   }
/*     */ 
/*     */   public synchronized void setName(String name)
/*     */   {
/* 292 */     if (isShared()) {
/* 293 */       throw new IllegalArgumentException("Cannot change the interceptor name. Already registered.");
/*     */     }
/* 295 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 308 */     String className = getClass().getName();
/* 309 */     int index = className.lastIndexOf('.');
/*     */ 
/* 311 */     return className.substring(index < 0 ? 0 : index) + "[" + "name=" + this.name + "SHARED " + this.objectName + "]";
/*     */   }
/*     */ 
/*     */   protected ObjectName createObjectName()
/*     */     throws MalformedObjectNameException
/*     */   {
/* 338 */     Hashtable props = new Hashtable(2);
/* 339 */     props.put("type", "Interceptor");
/* 340 */     props.put("name", this.name);
/* 341 */     props.put("ID", "0");
/*     */ 
/* 343 */     return new ObjectName("JBossMX", props);
/*     */   }
/*     */ 
/*     */   private ModelMBeanInfo getManagementInterface()
/*     */   {
/* 351 */     return new ModelMBeanInfoSupport(getClass().getName(), "Interceptor invocation interface", null, null, new ModelMBeanOperationInfo[] { new ModelMBeanOperationInfo("invoke", "Shared interceptor invoke operation.", new MBeanParameterInfo[] { new MBeanParameterInfo("invocation", Invocation.class.getName(), "The invocation object.") }, Object.class.getName(), 2) }, null);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.interceptor.AbstractSharedInterceptor
 * JD-Core Version:    0.6.0
 */