/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.File;
/*     */ import java.io.FileFilter;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.security.CodeSource;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Comparator;
/*     */ import java.util.HashSet;
/*     */ import java.util.LinkedList;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.TreeSet;
/*     */ import java.util.zip.ZipEntry;
/*     */ import java.util.zip.ZipInputStream;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClassLoaderUtils
/*     */ {
/*  57 */   private static Logger log = Logger.getLogger(ClassLoaderUtils.class);
/*     */ 
/*  60 */   private static final Comparator repositoryClassLoaderComparator = new RepositoryClassLoaderComparator(null);
/*     */ 
/*     */   public static void displayClassInfo(Class clazz, StringBuffer results)
/*     */   {
/*  71 */     ClassLoader cl = clazz.getClassLoader();
/*  72 */     results.append("\n" + clazz.getName() + "(" + Integer.toHexString(clazz.hashCode()) + ").ClassLoader=" + cl);
/*  73 */     ClassLoader parent = cl;
/*  74 */     while (parent != null)
/*     */     {
/*  76 */       results.append("\n.." + parent);
/*  77 */       URL[] urls = getClassLoaderURLs(parent);
/*  78 */       int length = urls != null ? urls.length : 0;
/*  79 */       for (int u = 0; u < length; u++)
/*     */       {
/*  81 */         results.append("\n...." + urls[u]);
/*     */       }
/*  83 */       if (parent != null)
/*  84 */         parent = parent.getParent();
/*     */     }
/*  86 */     CodeSource clazzCS = clazz.getProtectionDomain().getCodeSource();
/*  87 */     if (clazzCS != null)
/*  88 */       results.append("\n++++CodeSource: " + clazzCS);
/*     */     else {
/*  90 */       results.append("\n++++Null CodeSource");
/*     */     }
/*  92 */     results.append("\nImplemented Interfaces:");
/*  93 */     Class[] ifaces = clazz.getInterfaces();
/*  94 */     for (int i = 0; i < ifaces.length; i++)
/*     */     {
/*  96 */       Class iface = ifaces[i];
/*  97 */       results.append("\n++" + iface + "(" + Integer.toHexString(iface.hashCode()) + ")");
/*  98 */       ClassLoader loader = ifaces[i].getClassLoader();
/*  99 */       results.append("\n++++ClassLoader: " + loader);
/* 100 */       ProtectionDomain pd = ifaces[i].getProtectionDomain();
/* 101 */       CodeSource cs = pd.getCodeSource();
/* 102 */       if (cs != null)
/* 103 */         results.append("\n++++CodeSource: " + cs);
/*     */       else
/* 105 */         results.append("\n++++Null CodeSource");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static URL[] getClassLoaderURLs(ClassLoader cl)
/*     */   {
/* 115 */     URL[] urls = new URL[0];
/*     */     try
/*     */     {
/* 118 */       Class returnType = urls.getClass();
/* 119 */       Class[] parameterTypes = new Class[0];
/* 120 */       Class clClass = cl.getClass();
/* 121 */       Method getURLs = clClass.getMethod("getURLs", parameterTypes);
/* 122 */       if (returnType.isAssignableFrom(getURLs.getReturnType()))
/*     */       {
/* 124 */         Object[] args = new Object[0];
/* 125 */         urls = (URL[])(URL[])getURLs.invoke(cl, args);
/*     */       }
/* 127 */       if ((urls == null) || (urls.length == 0))
/*     */       {
/* 129 */         Method getCp = clClass.getMethod("getClasspath", parameterTypes);
/* 130 */         if (returnType.isAssignableFrom(getCp.getReturnType()))
/*     */         {
/* 132 */           Object[] args = new Object[0];
/* 133 */           urls = (URL[])(URL[])getCp.invoke(cl, args);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/* 140 */     return urls;
/*     */   }
/*     */ 
/*     */   public static URLClassLoader[] getClassLoaderStack(ClassLoader cl)
/*     */   {
/* 152 */     ArrayList stack = new ArrayList();
/* 153 */     while (cl != null)
/*     */     {
/* 155 */       if ((cl instanceof URLClassLoader))
/*     */       {
/* 157 */         stack.add(cl);
/*     */       }
/* 159 */       cl = cl.getParent();
/*     */     }
/* 161 */     URLClassLoader[] ucls = new URLClassLoader[stack.size()];
/* 162 */     stack.toArray(ucls);
/* 163 */     return ucls;
/*     */   }
/*     */ 
/*     */   public static String getJarClassName(String className)
/*     */   {
/* 174 */     String jarClassName = className.replace('.', '/');
/* 175 */     return jarClassName + ".class";
/*     */   }
/*     */ 
/*     */   public static String getPackageName(String className)
/*     */   {
/* 183 */     int startIndex = 0;
/*     */ 
/* 185 */     if ((className.length() > 0) && (className.charAt(0) == '['))
/*     */     {
/* 188 */       startIndex = className.indexOf('L') + 1;
/*     */     }
/*     */ 
/* 191 */     String pkgName = "";
/* 192 */     int endIndex = className.lastIndexOf('.');
/* 193 */     if (endIndex > 0)
/* 194 */       pkgName = className.substring(startIndex, endIndex);
/* 195 */     return pkgName;
/*     */   }
/*     */ 
/*     */   public static String getResourceName(String className)
/*     */   {
/* 203 */     int startIndex = 0;
/*     */ 
/* 205 */     if ((className.length() > 0) && (className.charAt(0) == '['))
/*     */     {
/* 208 */       startIndex = className.indexOf('L') + 1;
/*     */     }
/*     */ 
/* 211 */     String resName = "";
/* 212 */     int endIndex = className.lastIndexOf('.');
/* 213 */     if (endIndex > 0)
/* 214 */       resName = className.substring(startIndex, endIndex);
/* 215 */     return resName.replace('.', '/');
/*     */   }
/*     */ 
/*     */   public static Set newPackageSet()
/*     */   {
/* 225 */     return new TreeSet(repositoryClassLoaderComparator);
/*     */   }
/*     */ 
/*     */   public static Set clonePackageSet(Object toClone)
/*     */   {
/* 236 */     TreeSet original = (TreeSet)toClone;
/* 237 */     return (Set)original.clone();
/*     */   }
/*     */ 
/*     */   public static void updatePackageMap(URL url, PkgNameListener listener)
/*     */     throws Exception
/*     */   {
/* 251 */     ClassPathIterator cpi = new ClassPathIterator(url);
/* 252 */     updatePackageMap(cpi, listener);
/*     */   }
/*     */ 
/*     */   public static String[] updateClassNamesMap(Object cl, Map classNamesMap, URL url, String[] prevClassNames)
/*     */     throws Exception
/*     */   {
/* 267 */     ClassPathIterator cpi = new ClassPathIterator(url);
/* 268 */     HashSet classNameSet = null;
/* 269 */     if (prevClassNames == null)
/* 270 */       classNameSet = new HashSet();
/*     */     else
/* 272 */       classNameSet = new HashSet(Arrays.asList(prevClassNames));
/* 273 */     return updateClassNamesMap(cl, classNamesMap, cpi, classNameSet);
/*     */   }
/*     */ 
/*     */   static void updatePackageMap(ClassPathIterator cpi, PkgNameListener listener)
/*     */     throws Exception
/*     */   {
/*     */     ClassPathEntry entry;
/* 280 */     while ((entry = cpi.getNextEntry()) != null)
/*     */     {
/* 282 */       String name = entry.getName();
/*     */ 
/* 284 */       if (name.equals("META-INF/INDEX.LIST"))
/*     */       {
/* 286 */         readJarIndex(cpi, listener);
/*     */ 
/* 288 */         break;
/*     */       }
/*     */ 
/* 292 */       if (entry.isDirectory() == true) {
/*     */         continue;
/*     */       }
/* 295 */       String pkgName = entry.toPackageName();
/* 296 */       listener.addPackage(pkgName);
/*     */     }
/* 298 */     cpi.close();
/*     */   }
/*     */ 
/*     */   static String[] updateClassNamesMap(Object cl, Map classNamesMap, ClassPathIterator cpi, HashSet classNameSet)
/*     */     throws Exception
/*     */   {
/* 305 */     boolean trace = log.isTraceEnabled();
/*     */     ClassPathEntry entry;
/* 307 */     while ((entry = cpi.getNextEntry()) != null)
/*     */     {
/* 309 */       String name = entry.getName();
/*     */ 
/* 311 */       if ((entry.isDirectory() == true) || 
/* 314 */         (!name.endsWith(".class"))) {
/*     */         continue;
/*     */       }
/* 317 */       addClass(name, classNamesMap, cl, trace);
/* 318 */       classNameSet.add(name);
/*     */     }
/* 320 */     cpi.close();
/*     */ 
/* 323 */     String[] classNames = new String[classNameSet.size()];
/* 324 */     classNameSet.toArray(classNames);
/* 325 */     return classNames;
/*     */   }
/*     */ 
/*     */   private static void readJarIndex(ClassPathIterator cpi, PkgNameListener listener)
/*     */     throws Exception
/*     */   {
/* 334 */     boolean trace = log.isTraceEnabled();
/* 335 */     InputStream zis = cpi.getInputStream();
/* 336 */     BufferedReader br = new BufferedReader(new InputStreamReader(zis));
/*     */     String line;
/* 339 */     while ((line = br.readLine()) != null)
/*     */     {
/* 341 */       if (line.length() == 0) {
/* 342 */         break;
/*     */       }
/*     */     }
/*     */ 
/* 346 */     String jarName = br.readLine();
/* 347 */     if (trace)
/* 348 */       log.trace("Reading INDEX.LIST for jar: " + jarName);
/* 349 */     while ((line = br.readLine()) != null)
/*     */     {
/* 351 */       if (line.length() == 0)
/*     */         break;
/* 353 */       String pkgName = line.replace('/', '.');
/* 354 */       listener.addPackage(pkgName);
/*     */     }
/* 356 */     br.close();
/*     */   }
/*     */ 
/*     */   private static void addClass(String jarClassName, Map classNamesMap, Object cl, boolean trace)
/*     */   {
/* 368 */     LinkedList ucls = (LinkedList)classNamesMap.get(jarClassName);
/* 369 */     if (ucls == null)
/*     */     {
/* 371 */       ucls = new LinkedList();
/* 372 */       ucls.add(cl);
/* 373 */       classNamesMap.put(jarClassName, ucls);
/*     */     }
/*     */     else
/*     */     {
/* 377 */       boolean uclIsMapped = ucls.contains(cl);
/* 378 */       if (!uclIsMapped)
/*     */       {
/* 380 */         log.debug("Multiple class loaders found for class: " + jarClassName + ", duplicate UCL: " + cl);
/*     */ 
/* 382 */         ucls.add(cl);
/*     */       }
/*     */     }
/* 385 */     if (trace)
/* 386 */       log.trace("Indexed class: " + jarClassName + ", UCL: " + ucls.get(0));
/*     */   }
/*     */ 
/*     */   private static class RepositoryClassLoaderComparator
/*     */     implements Comparator
/*     */   {
/*     */     public int compare(Object o1, Object o2)
/*     */     {
/* 589 */       if ((o1 instanceof LoadMgr3.PkgClassLoader))
/*     */       {
/* 591 */         LoadMgr3.PkgClassLoader pkg1 = (LoadMgr3.PkgClassLoader)o1;
/* 592 */         LoadMgr3.PkgClassLoader pkg2 = (LoadMgr3.PkgClassLoader)o2;
/* 593 */         RepositoryClassLoader rcl1 = pkg1.ucl;
/* 594 */         RepositoryClassLoader rcl2 = pkg2.ucl;
/*     */ 
/* 596 */         int test = pkg1.order - pkg2.order;
/* 597 */         if (test != 0) {
/* 598 */           return test;
/*     */         }
/* 600 */         return rcl1.getAddedOrder() - rcl2.getAddedOrder();
/*     */       }
/*     */ 
/* 604 */       RepositoryClassLoader rcl1 = (RepositoryClassLoader)o1;
/* 605 */       RepositoryClassLoader rcl2 = (RepositoryClassLoader)o2;
/* 606 */       return rcl1.getAddedOrder() - rcl2.getAddedOrder();
/*     */     }
/*     */   }
/*     */ 
/*     */   static class ClassPathIterator
/*     */   {
/*     */     ZipInputStream zis;
/*     */     ClassLoaderUtils.FileIterator fileIter;
/*     */     File file;
/*     */     int rootLength;
/*     */ 
/*     */     ClassPathIterator(URL url)
/*     */       throws IOException
/*     */     {
/* 512 */       String protocol = url != null ? url.getProtocol() : null;
/* 513 */       if (protocol != null)
/*     */       {
/* 516 */         if (protocol.equals("file"))
/*     */         {
/* 518 */           File tmp = new File(url.getFile());
/* 519 */           if (tmp.isDirectory())
/*     */           {
/* 521 */             this.rootLength = (tmp.getPath().length() + 1);
/* 522 */             this.fileIter = new ClassLoaderUtils.FileIterator(tmp);
/*     */           }
/*     */           else
/*     */           {
/* 527 */             InputStream is = new FileInputStream(tmp);
/* 528 */             this.zis = new ZipInputStream(is);
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 534 */           InputStream is = url.openStream();
/* 535 */           this.zis = new ZipInputStream(is);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     ClassLoaderUtils.ClassPathEntry getNextEntry() throws IOException {
/* 541 */       ClassLoaderUtils.ClassPathEntry entry = null;
/* 542 */       if (this.zis != null)
/*     */       {
/* 544 */         ZipEntry zentry = this.zis.getNextEntry();
/* 545 */         if (zentry != null)
/* 546 */           entry = new ClassLoaderUtils.ClassPathEntry(zentry);
/*     */       }
/* 548 */       else if (this.fileIter != null)
/*     */       {
/* 550 */         File fentry = this.fileIter.getNextEntry();
/* 551 */         if (fentry != null)
/* 552 */           entry = new ClassLoaderUtils.ClassPathEntry(fentry, this.rootLength);
/* 553 */         this.file = fentry;
/*     */       }
/*     */ 
/* 556 */       return entry;
/*     */     }
/*     */ 
/*     */     InputStream getInputStream() throws IOException
/*     */     {
/* 561 */       InputStream is = this.zis;
/* 562 */       if (this.zis == null)
/*     */       {
/* 564 */         is = new FileInputStream(this.file);
/*     */       }
/* 566 */       return is;
/*     */     }
/*     */ 
/*     */     void close() throws IOException
/*     */     {
/* 571 */       if (this.zis != null)
/* 572 */         this.zis.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   static class ClassPathEntry
/*     */   {
/*     */     String name;
/*     */     ZipEntry zipEntry;
/*     */     File fileEntry;
/*     */ 
/*     */     ClassPathEntry(ZipEntry zipEntry)
/*     */     {
/* 457 */       this.zipEntry = zipEntry;
/* 458 */       this.name = zipEntry.getName();
/*     */     }
/*     */ 
/*     */     ClassPathEntry(File fileEntry, int rootLength) {
/* 462 */       this.fileEntry = fileEntry;
/* 463 */       this.name = fileEntry.getPath().substring(rootLength);
/*     */     }
/*     */ 
/*     */     String getName()
/*     */     {
/* 468 */       return this.name;
/*     */     }
/*     */ 
/*     */     String toPackageName()
/*     */     {
/* 474 */       String pkgName = this.name;
/* 475 */       char separatorChar = this.zipEntry != null ? '/' : File.separatorChar;
/* 476 */       int index = this.name.lastIndexOf(separatorChar);
/* 477 */       if (index > 0)
/*     */       {
/* 479 */         pkgName = this.name.substring(0, index);
/* 480 */         pkgName = pkgName.replace(separatorChar, '.');
/*     */       }
/*     */       else
/*     */       {
/* 485 */         pkgName = "";
/*     */       }
/* 487 */       return pkgName;
/*     */     }
/*     */ 
/*     */     boolean isDirectory()
/*     */     {
/* 492 */       boolean isDirectory = false;
/* 493 */       if (this.zipEntry != null)
/* 494 */         isDirectory = this.zipEntry.isDirectory();
/*     */       else
/* 496 */         isDirectory = this.fileEntry.isDirectory();
/* 497 */       return isDirectory;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class FileIterator
/*     */   {
/* 398 */     LinkedList subDirectories = new LinkedList();
/*     */     FileFilter filter;
/*     */     File[] currentListing;
/* 401 */     int index = 0;
/*     */ 
/*     */     FileIterator(File start)
/*     */     {
/* 405 */       String name = start.getName();
/*     */ 
/* 407 */       boolean isWar = name.endsWith(".war");
/* 408 */       if (isWar)
/* 409 */         this.currentListing = new File[0];
/*     */       else
/* 411 */         this.currentListing = start.listFiles();
/*     */     }
/*     */ 
/*     */     FileIterator(File start, FileFilter filter) {
/* 415 */       String name = start.getName();
/*     */ 
/* 417 */       boolean isWar = name.endsWith(".war");
/* 418 */       if (isWar)
/* 419 */         this.currentListing = new File[0];
/*     */       else
/* 421 */         this.currentListing = start.listFiles(filter);
/* 422 */       this.filter = filter;
/*     */     }
/*     */ 
/*     */     File getNextEntry()
/*     */     {
/* 427 */       File next = null;
/* 428 */       if ((this.index >= this.currentListing.length) && (this.subDirectories.size() > 0))
/*     */       {
/*     */         do
/*     */         {
/* 432 */           File nextDir = (File)this.subDirectories.removeFirst();
/* 433 */           this.currentListing = nextDir.listFiles(this.filter);
/* 434 */         }while ((this.currentListing.length == 0) && (this.subDirectories.size() > 0));
/* 435 */         this.index = 0;
/*     */       }
/* 437 */       if (this.index < this.currentListing.length)
/*     */       {
/* 439 */         next = this.currentListing[(this.index++)];
/* 440 */         if (next.isDirectory())
/* 441 */           this.subDirectories.addLast(next);
/*     */       }
/* 443 */       return next;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface PkgNameListener
/*     */   {
/*     */     public abstract void addPackage(String paramString);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.ClassLoaderUtils
 * JD-Core Version:    0.6.0
 */