/*    */ package org.jboss.mx.loading;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.CodeSource;
/*    */ import java.security.PrivilegedAction;
/*    */ import java.security.ProtectionDomain;
/*    */ 
/*    */ class ClassToStringAction
/*    */   implements PrivilegedAction
/*    */ {
/*    */   private StringBuffer buffer;
/*    */   private Class clazz;
/*    */ 
/*    */   ClassToStringAction(Class clazz, StringBuffer buffer)
/*    */   {
/* 40 */     this.clazz = clazz;
/* 41 */     this.buffer = buffer;
/*    */   }
/*    */ 
/*    */   public Object run() {
/* 45 */     if (this.clazz != null)
/*    */     {
/* 47 */       this.buffer.append(this.clazz.getName());
/* 48 */       this.buffer.append("@" + Integer.toHexString(this.clazz.hashCode()));
/* 49 */       CodeSource cs = this.clazz.getProtectionDomain().getCodeSource();
/* 50 */       this.buffer.append("<CodeSource: " + cs + ">");
/*    */     }
/*    */     else
/*    */     {
/* 54 */       this.buffer.append("null");
/*    */     }
/* 56 */     return null;
/*    */   }
/*    */ 
/*    */   static void toString(Class clazz, StringBuffer buffer)
/*    */   {
/* 61 */     PrivilegedAction action = new ClassToStringAction(clazz, buffer);
/* 62 */     AccessController.doPrivileged(action);
/*    */   }
/*    */ 
/*    */   static String getProperty(String key, String def)
/*    */   {
/* 81 */     PrivilegedAction action = new SysPropertyAction(key, def);
/* 82 */     String value = (String)AccessController.doPrivileged(action);
/* 83 */     return value;
/*    */   }
/*    */ 
/*    */   static class SysPropertyAction
/*    */     implements PrivilegedAction
/*    */   {
/*    */     private String key;
/*    */     private String def;
/*    */ 
/*    */     SysPropertyAction(String key, String def)
/*    */     {
/* 71 */       this.key = key;
/* 72 */       this.def = def;
/*    */     }
/*    */ 
/*    */     public Object run() {
/* 76 */       return System.getProperty(this.key, this.def);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.ClassToStringAction
 * JD-Core Version:    0.6.0
 */