/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.HashMap;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.JMException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectInstance;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class LoaderRepositoryFactory
/*     */ {
/*     */   public static ObjectName DEFAULT_LOADER_REPOSITORY;
/*  52 */   private static Logger log = Logger.getLogger(LoaderRepositoryFactory.class);
/*     */ 
/*  54 */   private static HashMap referenceCountMap = new HashMap();
/*     */ 
/*     */   public static LoaderRepositoryConfig parseRepositoryConfig(Element config)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 124 */     LoaderRepositoryConfig repositoryConfig = new LoaderRepositoryConfig();
/* 125 */     repositoryConfig.repositoryClassName = config.getAttribute("loaderRepositoryClass");
/* 126 */     if (repositoryConfig.repositoryClassName.length() == 0) {
/* 127 */       repositoryConfig.repositoryClassName = "org.jboss.mx.loading.HeirarchicalLoaderRepository3";
/*     */     }
/*     */ 
/* 130 */     NodeList children = config.getChildNodes();
/* 131 */     int count = children.getLength();
/* 132 */     if (count > 0)
/*     */     {
/* 134 */       for (int n = 0; n < count; n++)
/*     */       {
/* 136 */         Node node = children.item(n);
/* 137 */         int type = node.getNodeType();
/*     */ 
/* 139 */         if ((type != 3) && (type != 4))
/*     */           continue;
/* 141 */         String objectName = node.getNodeValue().trim();
/* 142 */         repositoryConfig.repositoryName = new ObjectName(objectName);
/* 143 */         break;
/*     */       }
/*     */ 
/* 148 */       children = config.getElementsByTagName("loader-repository-config");
/* 149 */       count = children.getLength();
/* 150 */       if (count > 0)
/*     */       {
/* 152 */         Element loaderRepositoryConfig = (Element)children.item(0);
/* 153 */         children = loaderRepositoryConfig.getChildNodes();
/* 154 */         count = children.getLength();
/* 155 */         repositoryConfig.configParserClassName = loaderRepositoryConfig.getAttribute("configParserClass");
/* 156 */         if (repositoryConfig.configParserClassName.length() == 0)
/* 157 */           repositoryConfig.configParserClassName = "org.jboss.mx.loading.HeirarchicalLoaderRepository3ConfigParser";
/* 158 */         StringBuffer configData = new StringBuffer();
/* 159 */         for (int n = 0; n < count; n++)
/*     */         {
/* 161 */           Node node = children.item(n);
/* 162 */           int type = node.getNodeType();
/* 163 */           if ((type != 3) && (type != 4))
/*     */             continue;
/* 165 */           configData.append(node.getNodeValue());
/*     */         }
/*     */ 
/* 168 */         repositoryConfig.repositoryConfig = configData.toString().trim();
/*     */       }
/*     */     }
/* 171 */     return repositoryConfig;
/*     */   }
/*     */ 
/*     */   public static synchronized void createLoaderRepository(MBeanServer server, String repositoryClassName, ObjectName repositoryName)
/*     */     throws JMException
/*     */   {
/* 187 */     LoaderRepositoryConfig config = new LoaderRepositoryConfig();
/* 188 */     config.repositoryClassName = repositoryClassName;
/* 189 */     config.repositoryName = repositoryName;
/* 190 */     createLoaderRepository(server, config);
/*     */   }
/*     */ 
/*     */   public static synchronized void createLoaderRepository(MBeanServer server, LoaderRepositoryConfig config)
/*     */     throws JMException
/*     */   {
/* 203 */     if (config == null)
/* 204 */       config = new LoaderRepositoryConfig();
/* 205 */     String repositoryClassName = config.repositoryClassName;
/* 206 */     ObjectName repositoryName = config.repositoryName;
/*     */     try
/*     */     {
/* 210 */       ObjectInstance oi = server.getObjectInstance(repositoryName);
/* 211 */       if ((repositoryClassName != null) && (!oi.getClassName().equals(repositoryClassName)))
/*     */       {
/* 214 */         throw new JMException("Inconsistent LoaderRepository class specification in repository: " + repositoryName);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (InstanceNotFoundException e)
/*     */     {
/* 220 */       if (repositoryClassName == null) {
/* 221 */         repositoryClassName = "org.jboss.mx.loading.HeirarchicalLoaderRepository3";
/*     */       }
/* 223 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 224 */       LoaderRepository repository = null;
/*     */       try
/*     */       {
/* 228 */         Class repositoryClass = loader.loadClass(repositoryClassName);
/* 229 */         Class[] ctorSig = { MBeanServer.class, ObjectName.class };
/* 230 */         Constructor ctor = repositoryClass.getConstructor(ctorSig);
/* 231 */         Object[] args = { server, DEFAULT_LOADER_REPOSITORY };
/* 232 */         repository = (LoaderRepository)ctor.newInstance(args);
/* 233 */         server.registerMBean(repository, repositoryName);
/*     */       }
/*     */       catch (Exception e2)
/*     */       {
/* 237 */         log.debug("Failed to create loader repository: ", e2);
/* 238 */         throw new JMException("Failed to create loader repository:" + e2);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 244 */         if ((config.configParserClassName != null) && (config.repositoryConfig != null))
/*     */         {
/* 246 */           Class parserClass = loader.loadClass(config.configParserClassName);
/* 247 */           LoaderRepositoryConfigParser parser = (LoaderRepositoryConfigParser)parserClass.newInstance();
/*     */ 
/* 249 */           parser.configure(repository, config.repositoryConfig);
/*     */         }
/*     */       }
/*     */       catch (Exception e2)
/*     */       {
/* 254 */         log.debug("Failed to configure loader repository: ", e2);
/* 255 */         throw new JMException("Failed to configure loader repository: " + e2);
/*     */       }
/*     */     }
/*     */ 
/* 259 */     Integer activeCount = (Integer)referenceCountMap.get(repositoryName);
/* 260 */     if (activeCount == null)
/* 261 */       activeCount = new Integer(1);
/*     */     else
/* 263 */       activeCount = new Integer(activeCount.intValue() + 1);
/* 264 */     referenceCountMap.put(repositoryName, activeCount);
/*     */   }
/*     */ 
/*     */   public static synchronized void destroyLoaderRepository(MBeanServer server, ObjectName repositoryName)
/*     */   {
/* 270 */     if (!repositoryName.equals(DEFAULT_LOADER_REPOSITORY))
/*     */     {
/*     */       try
/*     */       {
/* 274 */         Integer activeCount = (Integer)referenceCountMap.get(repositoryName);
/* 275 */         if (activeCount != null)
/*     */         {
/* 277 */           if (activeCount.intValue() == 1)
/*     */           {
/* 279 */             server.unregisterMBean(repositoryName);
/* 280 */             referenceCountMap.remove(repositoryName);
/* 281 */             log.debug("Unregistered repository: " + repositoryName);
/*     */           }
/*     */           else
/*     */           {
/* 285 */             activeCount = new Integer(activeCount.intValue() - 1);
/* 286 */             referenceCountMap.put(repositoryName, activeCount);
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 292 */         log.warn("Failed to unregister ear loader repository", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  61 */       DEFAULT_LOADER_REPOSITORY = new ObjectName("JMImplementation:service=LoaderRepository,name=Default");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  65 */       log.error("Failed to init DEFAULT_LOADER_REPOSITORY name", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface LoaderRepositoryConfigParser {
/*     */     public abstract void configure(LoaderRepository paramLoaderRepository, String paramString) throws Exception;
/*     */   }
/*     */ 
/*     */   public static class LoaderRepositoryConfig implements Serializable {
/*     */     static final long serialVersionUID = 4226952985429700362L;
/*  79 */     public ObjectName repositoryName = LoaderRepositoryFactory.DEFAULT_LOADER_REPOSITORY;
/*     */     public String repositoryClassName;
/*     */     public String configParserClassName;
/*     */     public String repositoryConfig;
/*     */ 
/*     */     public String toString() {
/*  86 */       StringBuffer tmp = new StringBuffer("LoaderRepositoryConfig(");
/*  87 */       tmp.append("repositoryName: ");
/*  88 */       tmp.append(this.repositoryName);
/*  89 */       tmp.append(", repositoryClassName: ");
/*  90 */       tmp.append(this.repositoryClassName);
/*  91 */       tmp.append(", configParserClassName: ");
/*  92 */       tmp.append(this.configParserClassName);
/*  93 */       tmp.append(", repositoryConfig: ");
/*  94 */       tmp.append(this.repositoryConfig);
/*  95 */       tmp.append(")");
/*  96 */       return tmp.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.LoaderRepositoryFactory
 * JD-Core Version:    0.6.0
 */