/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.StringTokenizer;
/*     */ 
/*     */ public class MBeanElement
/*     */ {
/*     */   public static final String MLET_DELEGATE_TO_CLR = "delegateToCLR";
/*  57 */   private Map properties = new HashMap(2);
/*     */ 
/*  62 */   private String code = null;
/*     */ 
/*  67 */   private String object = null;
/*     */ 
/*  72 */   private String name = null;
/*     */ 
/*  77 */   private String codebase = null;
/*     */ 
/*  82 */   private ArrayList archives = new ArrayList();
/*     */ 
/*  87 */   private ArrayList versions = new ArrayList();
/*     */ 
/*  92 */   private ArrayList argTypes = new ArrayList();
/*     */ 
/*  97 */   private ArrayList argValues = new ArrayList();
/*     */ 
/*     */   public String getCode()
/*     */   {
/* 109 */     return this.code;
/*     */   }
/*     */ 
/*     */   public String getObject()
/*     */   {
/* 121 */     return this.object;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 131 */     return this.name;
/*     */   }
/*     */ 
/*     */   public List getArchives()
/*     */   {
/* 141 */     return this.archives;
/*     */   }
/*     */ 
/*     */   public List getVersions()
/*     */   {
/* 151 */     return this.versions;
/*     */   }
/*     */ 
/*     */   public String getCodebase()
/*     */   {
/* 161 */     return this.codebase;
/*     */   }
/*     */ 
/*     */   public void setCode(String code)
/*     */   {
/* 172 */     this.code = trim(code);
/* 173 */     if (this.code.endsWith(".class"))
/* 174 */       this.code = this.code.substring(0, this.code.length() - 6);
/*     */   }
/*     */ 
/*     */   public void setObject(String object)
/*     */   {
/* 186 */     this.object = trim(object);
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 197 */     this.name = trim(name);
/*     */   }
/*     */ 
/*     */   public void setCodebase(String url)
/*     */   {
/* 208 */     this.codebase = trim(url);
/*     */   }
/*     */ 
/*     */   public void setArchive(String archive)
/*     */   {
/* 213 */     archive = trim(archive);
/* 214 */     StringTokenizer tokenizer = new StringTokenizer(archive, " ,");
/*     */ 
/* 216 */     while (tokenizer.hasMoreTokens())
/* 217 */       this.archives.add(tokenizer.nextToken());
/*     */   }
/*     */ 
/*     */   public void setVersion(String version)
/*     */   {
/* 222 */     version = trim(version);
/* 223 */     StringTokenizer tokenizer = new StringTokenizer(version, " ,");
/*     */ 
/* 225 */     while (tokenizer.hasMoreTokens())
/* 226 */       this.versions.add(tokenizer.nextToken());
/*     */   }
/*     */ 
/*     */   public void addArg(String type, String value)
/*     */   {
/* 231 */     this.argTypes.add(trim(type));
/* 232 */     this.argValues.add(trim(value));
/*     */   }
/*     */ 
/*     */   public String[] getConstructorTypes()
/*     */   {
/* 237 */     return (String[])(String[])this.argTypes.toArray(new String[0]);
/*     */   }
/*     */ 
/*     */   public String[] getConstructorValues()
/*     */   {
/* 242 */     return (String[])(String[])this.argValues.toArray(new String[0]);
/*     */   }
/*     */ 
/*     */   private String trim(String str)
/*     */   {
/* 248 */     if (str == null) {
/* 249 */       return str;
/*     */     }
/*     */ 
/* 252 */     if (str.startsWith("=")) {
/* 253 */       str = str.substring(1, str.length());
/*     */     }
/* 255 */     if ((str.startsWith("\"")) && (str.endsWith("\""))) {
/* 256 */       return str.substring(1, str.length() - 1);
/*     */     }
/* 258 */     return str;
/*     */   }
/*     */ 
/*     */   public void setProperty(String key, Object value)
/*     */   {
/* 263 */     if ((key == null) || (key.equals("")))
/* 264 */       throw new IllegalArgumentException("null or empty string keys not allowed");
/* 265 */     if (value == null) {
/* 266 */       throw new IllegalArgumentException("null values not allowed");
/*     */     }
/* 268 */     this.properties.put(key, value);
/*     */   }
/*     */ 
/*     */   public Object getProperty(String key)
/*     */   {
/* 273 */     return this.properties.get(key);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.MBeanElement
 * JD-Core Version:    0.6.0
 */