/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStreamReader;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.text.ParseException;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.NoSuchElementException;
/*     */ import java.util.Set;
/*     */ import java.util.StringTokenizer;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class MLetParser
/*     */   implements MBeanFileParser
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(MLetParser.class);
/*     */ 
/*     */   public Set parseMBeanFile(String url)
/*     */     throws ParseException, MalformedURLException
/*     */   {
/*  68 */     return parseMBeanFile(new URL(url));
/*     */   }
/*     */ 
/*     */   public Set parseMBeanFile(URL url)
/*     */     throws ParseException
/*     */   {
/*  81 */     Set mlets = new HashSet();
/*  82 */     MBeanElement element = null;
/*     */     try
/*     */     {
/*  86 */       BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
/*  87 */       int c = -1;
/*     */ 
/*  90 */       while ((c = reader.read()) != -1)
/*     */       {
/*  93 */         if (c != 60)
/*     */           continue;
/*  95 */         StringBuffer buf = new StringBuffer(1000);
/*  96 */         boolean readMore = true;
/*     */ 
/*  99 */         while (readMore)
/*     */         {
/* 101 */           c = reader.read();
/*     */ 
/* 103 */           if (c == -1) {
/* 104 */             throw new ParseException("Unexpected end of file. Tag was not closed: " + buf.toString().replace('\t', ' ').replace('\n', ' ').replace('\r', ' ').trim(), 0);
/*     */           }
/* 106 */           if (c == 62)
/*     */           {
/* 108 */             readMore = false;
/* 109 */             break;
/*     */           }
/*     */ 
/* 112 */           buf.append((char)c);
/*     */         }
/*     */ 
/* 116 */         StringTokenizer tokenizer = new StringTokenizer(buf.toString(), "= \n\t\r");
/* 117 */         String tagName = null; String attributeName = null; String attributeValue = null;
/*     */ 
/* 120 */         if (tokenizer.hasMoreTokens()) {
/* 121 */           tagName = tokenizer.nextToken().trim();
/*     */         }
/*     */ 
/* 124 */         if (tagName.equals("MLET"))
/*     */         {
/* 126 */           element = new MBeanElement();
/*     */ 
/* 128 */           while (tokenizer.hasMoreTokens())
/*     */           {
/*     */             try
/*     */             {
/* 133 */               attributeName = tokenizer.nextToken("= \n\t\r").trim();
/* 134 */               attributeValue = tokenizer.nextToken(" \n\t\r").trim();
/*     */ 
/* 136 */               if (attributeValue.equals("=")) {
/* 137 */                 attributeValue = tokenizer.nextToken();
/*     */               }
/*     */ 
/* 140 */               if (attributeName.equals("CODE"))
/*     */               {
/* 142 */                 element.setCode(attributeValue);
/*     */               }
/* 146 */               else if (attributeName.equals("OBJECT")) {
/* 147 */                 element.setObject(attributeValue);
/*     */               }
/* 150 */               else if (attributeName.equals("ARCHIVE"))
/*     */               {
/* 152 */                 element.setArchive(attributeValue);
/*     */               }
/* 155 */               else if (attributeName.equals("CODEBASE")) {
/* 156 */                 element.setCodebase(attributeValue);
/*     */               }
/* 159 */               else if (attributeName.equals("NAME")) {
/* 160 */                 element.setName(attributeValue);
/*     */               }
/* 163 */               else if (attributeName.equals("VERSION")) {
/* 164 */                 element.setVersion(attributeValue);
/*     */               }
/*     */ 
/*     */             }
/*     */             catch (NoSuchElementException e)
/*     */             {
/* 171 */               log.warn("No value found for attribute '" + attributeName);
/*     */             }
/*     */           }
/*     */ 
/* 175 */           if ((element.getCode() == null) && (element.getObject() == null))
/* 176 */             throw new ParseException("<" + buf.toString().replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim() + "> is missing mandatory CODE | OBJECT attribute", 0);
/* 177 */           if (element.getArchives().size() == 0) {
/* 178 */             throw new ParseException("<" + buf.toString().replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim() + "> is missing mandatory ARCHIVE attribute", 0);
/*     */           }
/*     */ 
/*     */         }
/* 182 */         else if (tagName.equals("/MLET"))
/*     */         {
/* 184 */           mlets.add(element);
/* 185 */           element = null;
/*     */         }
/* 189 */         else if (tagName.equals("ARG"))
/*     */         {
/*     */           try
/*     */           {
/* 194 */             if (!tokenizer.nextToken().equals("TYPE")) {
/*     */               continue;
/*     */             }
/* 197 */             String type = tokenizer.nextToken();
/*     */ 
/* 200 */             if (!tokenizer.nextToken().equals("VALUE")) {
/*     */               continue;
/*     */             }
/* 203 */             String value = tokenizer.nextToken(" \n\t\r");
/*     */ 
/* 206 */             if (element != null) {
/* 207 */               element.addArg(type, value);
/*     */             }
/*     */           }
/*     */           catch (NoSuchElementException e)
/*     */           {
/* 212 */             element = null;
/*     */ 
/* 214 */             log.warn("Malformed element: <" + buf.toString() + ">");
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 221 */       mlets.remove(null);
/* 222 */       return mlets;
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 226 */     throw new ParseException(e.toString(), 0);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.MLetParser
 * JD-Core Version:    0.6.0
 */