/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
/*     */ import java.net.URL;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.loading.MLet;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ class MLetRepositoryClassLoader extends RepositoryClassLoader
/*     */ {
/*  42 */   private static final Logger log = Logger.getLogger(MLetRepositoryClassLoader.class);
/*     */   private MLet mlet;
/*     */ 
/*     */   protected MLetRepositoryClassLoader(MLet mlet)
/*     */   {
/*  61 */     super(mlet.getURLs(), mlet);
/*  62 */     this.mlet = mlet;
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectName()
/*     */   {
/*  74 */     throw new UnsupportedOperationException("Not relevent");
/*     */   }
/*     */ 
/*     */   public URL[] getClasspath()
/*     */   {
/*  85 */     return this.mlet.getURLs();
/*     */   }
/*     */ 
/*     */   public URL[] getAllURLs()
/*     */   {
/*  95 */     return this.repository.getURLs();
/*     */   }
/*     */ 
/*     */   public synchronized Class loadClassImpl(String name, boolean resolve, int stopAt)
/*     */     throws ClassNotFoundException
/*     */   {
/* 101 */     this.loadClassDepth += 1;
/* 102 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 104 */     if (trace)
/* 105 */       log.trace("loadClassImpl, name=" + name + ", resolve=" + resolve);
/* 106 */     if (this.repository == null)
/*     */     {
/* 108 */       String msg = "Invalid use of destroyed classloader, UCL destroyed at:";
/* 109 */       throw new ClassNotFoundException(msg, this.unregisterTrace);
/*     */     }
/*     */ 
/* 117 */     boolean acquired = attempt(1L);
/* 118 */     while (!acquired)
/*     */     {
/*     */       try
/*     */       {
/* 126 */         if (trace)
/* 127 */           log.trace("Waiting for loadClass lock");
/* 128 */         wait();
/*     */       }
/*     */       catch (InterruptedException ignore)
/*     */       {
/*     */       }
/* 133 */       acquired = attempt(1L);
/*     */     }
/*     */ 
/* 136 */     ClassLoadingTask task = null;
/*     */     try
/*     */     {
/* 139 */       Thread t = Thread.currentThread();
/*     */ 
/* 141 */       if (this.loadLock.holds() == 1L) {
/* 142 */         LoadMgr3.registerLoaderThread(this, t);
/*     */       }
/*     */ 
/* 145 */       task = new ClassLoadingTask(name, this, t, stopAt);
/*     */ 
/* 149 */       UnifiedLoaderRepository3 ulr3 = (UnifiedLoaderRepository3)this.repository;
/* 150 */       if (!LoadMgr3.beginLoadTask(task, ulr3)) {
/*     */         while (true) {
/* 152 */           if (task.threadTaskCount != 0)
/*     */           {
/*     */             try
/*     */             {
/* 156 */               LoadMgr3.nextTask(t, task, ulr3);
/*     */             }
/*     */             catch (InterruptedException e)
/*     */             {
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/* 169 */       if (this.loadLock.holds() == 1L) {
/* 170 */         LoadMgr3.endLoadTask(task);
/*     */       }
/* 172 */       release();
/* 173 */       notifyAll();
/* 174 */       this.loadClassDepth -= 1;
/*     */     }
/*     */ 
/* 177 */     if (task.loadedClass == null)
/*     */     {
/* 179 */       if ((task.loadException instanceof ClassNotFoundException))
/* 180 */         throw ((ClassNotFoundException)task.loadException);
/* 181 */       if (task.loadException != null)
/*     */       {
/* 183 */         if (log.isTraceEnabled())
/* 184 */           log.trace("Unexpected error during load of:" + name, task.loadException);
/* 185 */         String msg = "Unexpected error during load of: " + name + ", msg=" + task.loadException.getMessage();
/*     */ 
/* 187 */         throw new ClassNotFoundException(msg);
/*     */       }
/*     */ 
/* 191 */       throw new IllegalStateException("ClassLoadingTask.loadedTask is null, name: " + name);
/*     */     }
/*     */ 
/* 194 */     return task.loadedClass;
/*     */   }
/*     */ 
/*     */   public Class loadClassLocally(String name, boolean resolve)
/*     */     throws ClassNotFoundException
/*     */   {
/* 202 */     boolean trace = log.isTraceEnabled();
/* 203 */     if (trace)
/* 204 */       log.trace("loadClassLocally, " + this + " name=" + name);
/* 205 */     Class result = null;
/*     */     try
/*     */     {
/* 208 */       result = this.mlet.loadClass(name, null);
/* 209 */       Class localClass1 = result;
/*     */       return localClass1;
/*     */     }
/*     */     finally
/*     */     {
/* 213 */       if (trace)
/*     */       {
/* 215 */         if (result != null)
/* 216 */           log.trace("loadClassLocally, " + this + " name=" + name + " class=" + result + " cl=" + result.getClassLoader());
/*     */         else
/* 218 */           log.trace("loadClassLocally, " + this + " name=" + name + " not found"); 
/*     */       }
/* 218 */     }throw localObject;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.MLetRepositoryClassLoader
 * JD-Core Version:    0.6.0
 */