/*     */ package org.jboss.mx.loading;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
/*     */ import java.net.URL;
/*     */ import java.security.CodeSource;
/*     */ import java.security.Permission;
/*     */ import java.security.PermissionCollection;
/*     */ import java.security.Policy;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.Enumeration;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ import org.jboss.util.loading.Translatable;
/*     */ 
/*     */ public class UnifiedClassLoader extends RepositoryClassLoader
/*     */   implements UnifiedClassLoaderMBean, Translatable
/*     */ {
/*  63 */   private static final Logger log = Logger.getLogger(UnifiedClassLoader.class);
/*  64 */   private ThreadLocal<String> delegatedClassName = new ThreadLocal();
/*     */ 
/*  69 */   protected URL url = null;
/*     */ 
/*  72 */   protected URL origURL = null;
/*     */ 
/*     */   public UnifiedClassLoader(URL url)
/*     */   {
/*  83 */     this(url, (URL)null);
/*     */   }
/*     */ 
/*     */   public UnifiedClassLoader(URL url, URL origURL)
/*     */   {
/*  95 */     this(url, origURL, UnifiedClassLoader.class.getClassLoader());
/*     */   }
/*     */ 
/*     */   public UnifiedClassLoader(URL url, URL origURL, ClassLoader parent)
/*     */   {
/* 108 */     super(new URL[] { url == null ? new URL[0] : url }, parent);
/*     */ 
/* 110 */     if (log.isTraceEnabled())
/* 111 */       log.trace("New jmx UCL with url " + url);
/* 112 */     this.url = url;
/* 113 */     this.origURL = origURL;
/*     */   }
/*     */ 
/*     */   public UnifiedClassLoader(URL url, LoaderRepository repository)
/*     */   {
/* 125 */     this(url, null, repository);
/*     */   }
/*     */ 
/*     */   public UnifiedClassLoader(URL url, URL origURL, LoaderRepository repository)
/*     */   {
/* 138 */     this(url, origURL);
/*     */ 
/* 141 */     setRepository(repository);
/*     */ 
/* 144 */     repository.addClassLoader(this);
/*     */   }
/*     */ 
/*     */   public UnifiedClassLoader(URL url, MBeanServer server, ObjectName repositoryName)
/*     */     throws Exception
/*     */   {
/* 159 */     this(url, null, server, repositoryName);
/*     */   }
/*     */ 
/*     */   public UnifiedClassLoader(URL url, URL origURL, MBeanServer server, ObjectName repositoryName)
/*     */     throws Exception
/*     */   {
/* 175 */     this(url, origURL);
/* 176 */     LoaderRepository rep = (LoaderRepository)server.invoke(repositoryName, "registerClassLoader", new Object[] { this }, new String[] { getClass().getName() });
/*     */ 
/* 180 */     setRepository(rep);
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectName()
/*     */   {
/* 191 */     String name = "jmx.loading:UCL=" + Integer.toHexString(super.hashCode());
/* 192 */     return ObjectNameFactory.create(name);
/*     */   }
/*     */ 
/*     */   public void unregister()
/*     */   {
/* 197 */     super.unregister();
/* 198 */     this.origURL = null;
/* 199 */     this.url = null;
/*     */   }
/*     */ 
/*     */   public URL getURL()
/*     */   {
/* 206 */     return this.url;
/*     */   }
/*     */ 
/*     */   public URL getOrigURL()
/*     */   {
/* 213 */     return this.origURL;
/*     */   }
/*     */ 
/*     */   public synchronized Class loadClassImpl(String name, boolean resolve, int stopAt)
/*     */     throws ClassNotFoundException
/*     */   {
/* 219 */     this.loadClassDepth += 1;
/* 220 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 222 */     if (trace)
/* 223 */       log.trace("loadClassImpl, name=" + name + ", resolve=" + resolve);
/* 224 */     if (this.repository == null)
/*     */     {
/*     */       try
/*     */       {
/* 232 */         String prevName = (String)this.delegatedClassName.get();
/* 233 */         if (prevName != null)
/*     */         {
/* 235 */           if (prevName.equals(name))
/* 236 */             throw new ClassNotFoundException("Recursing on: " + name);
/*     */         }
/* 238 */         this.delegatedClassName.set(name);
/* 239 */         Class localClass = super.loadClass(name, resolve);
/*     */         return localClass; } catch (ClassNotFoundException ignored) { } finally { this.delegatedClassName.set(null);
/*     */       }
/* 248 */       String msg = "Invalid use of destroyed classloader, UCL destroyed at:";
/* 249 */       throw new ClassNotFoundException(msg, this.unregisterTrace);
/*     */     }
/*     */ 
/* 257 */     boolean acquired = attempt(1L);
/* 258 */     while (!acquired)
/*     */     {
/*     */       try
/*     */       {
/* 266 */         if (trace)
/* 267 */           log.trace("Waiting for loadClass lock");
/* 268 */         wait();
/*     */       }
/*     */       catch (InterruptedException ignore)
/*     */       {
/*     */       }
/* 273 */       acquired = attempt(1L);
/*     */     }
/*     */ 
/* 276 */     ClassLoadingTask task = null;
/*     */     try
/*     */     {
/* 279 */       Thread t = Thread.currentThread();
/*     */ 
/* 281 */       if (this.loadLock.holds() == 1L) {
/* 282 */         LoadMgr3.registerLoaderThread(this, t);
/*     */       }
/*     */ 
/* 285 */       task = new ClassLoadingTask(name, this, t, stopAt);
/*     */ 
/* 289 */       UnifiedLoaderRepository3 ulr3 = (UnifiedLoaderRepository3)this.repository;
/* 290 */       if (!LoadMgr3.beginLoadTask(task, ulr3)) {
/*     */         while (true) {
/* 292 */           if (task.threadTaskCount != 0)
/*     */           {
/*     */             try
/*     */             {
/* 296 */               LoadMgr3.nextTask(t, task, ulr3);
/*     */             }
/*     */             catch (InterruptedException e)
/*     */             {
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/* 309 */       if (this.loadLock.holds() == 1L) {
/* 310 */         LoadMgr3.endLoadTask(task);
/*     */       }
/* 312 */       release();
/* 313 */       notifyAll();
/* 314 */       this.loadClassDepth -= 1;
/*     */     }
/*     */ 
/* 317 */     if (task.loadedClass == null)
/*     */     {
/* 319 */       if ((task.loadException instanceof ClassNotFoundException))
/* 320 */         throw ((ClassNotFoundException)task.loadException);
/* 321 */       if ((task.loadException instanceof NoClassDefFoundError))
/* 322 */         throw ((NoClassDefFoundError)task.loadException);
/* 323 */       if (task.loadException != null)
/*     */       {
/* 325 */         if (log.isTraceEnabled())
/* 326 */           log.trace("Unexpected error during load of:" + name, task.loadException);
/* 327 */         String msg = "Unexpected error during load of: " + name + ", msg=" + task.loadException.getMessage();
/*     */ 
/* 329 */         ClassNotFoundException cnfe = new ClassNotFoundException(msg, task.loadException);
/* 330 */         throw cnfe;
/*     */       }
/*     */ 
/* 334 */       throw new IllegalStateException("ClassLoadingTask.loadedTask is null, name: " + name);
/*     */     }
/*     */ 
/* 337 */     return task.loadedClass;
/*     */   }
/*     */ 
/*     */   protected PermissionCollection getPermissions(CodeSource cs)
/*     */   {
/* 358 */     CodeSource permCS = cs;
/* 359 */     if (this.origURL != null)
/*     */     {
/* 361 */       permCS = new CodeSource(this.origURL, cs.getCertificates());
/*     */     }
/* 363 */     Policy policy = Policy.getPolicy();
/* 364 */     PermissionCollection perms = super.getPermissions(permCS);
/* 365 */     PermissionCollection perms2 = super.getPermissions(cs);
/* 366 */     PermissionCollection perms3 = policy.getPermissions(permCS);
/* 367 */     Enumeration iter = perms2.elements();
/* 368 */     while (iter.hasMoreElements())
/* 369 */       perms.add((Permission)iter.nextElement());
/* 370 */     iter = perms3.elements();
/* 371 */     while (iter.hasMoreElements())
/* 372 */       perms.add((Permission)iter.nextElement());
/* 373 */     if (log.isTraceEnabled())
/* 374 */       log.trace("getPermissions, url=" + this.url + ", origURL=" + this.origURL + " -> " + perms);
/* 375 */     return perms;
/*     */   }
/*     */ 
/*     */   protected ProtectionDomain getProtectionDomain()
/*     */   {
/* 386 */     return getProtectionDomain(this.origURL != null ? this.origURL : this.url);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.loading.UnifiedClassLoader
 * JD-Core Version:    0.6.0
 */