/*     */ package org.jboss.mx.metadata;
/*     */ 
/*     */ import java.beans.IntrospectionException;
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.NotCompliantMBeanException;
/*     */ import javax.management.modelmbean.DescriptorSupport;
/*     */ import javax.management.modelmbean.ModelMBeanAttributeInfo;
/*     */ import javax.management.modelmbean.ModelMBeanConstructorInfo;
/*     */ import javax.management.modelmbean.ModelMBeanInfo;
/*     */ import javax.management.modelmbean.ModelMBeanInfoSupport;
/*     */ import javax.management.modelmbean.ModelMBeanNotificationInfo;
/*     */ import javax.management.modelmbean.ModelMBeanOperationInfo;
/*     */ import org.dom4j.Attribute;
/*     */ import org.dom4j.DocumentException;
/*     */ import org.dom4j.DocumentFactory;
/*     */ import org.dom4j.io.DOMWriter;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.modelmbean.XMBeanConstants;
/*     */ import org.jboss.mx.util.JBossNotCompliantMBeanException;
/*     */ import org.jboss.util.Classes;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.jboss.util.propertyeditor.PropertyEditors;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.w3c.dom.Text;
/*     */ 
/*     */ public class JBossXMBean10 extends AbstractBuilder
/*     */   implements XMBeanConstants
/*     */ {
/*  67 */   private static Logger log = Logger.getLogger(JBossXMBean10.class);
/*     */   private org.dom4j.Element element;
/*  76 */   private String mmbClassName = null;
/*     */ 
/*  81 */   private String resourceClassName = null;
/*     */ 
/*     */   public JBossXMBean10(String mmbClassName, String resourceClassName, org.dom4j.Element element, Map properties)
/*     */   {
/*  89 */     this.mmbClassName = mmbClassName;
/*  90 */     this.resourceClassName = resourceClassName;
/*  91 */     this.element = element;
/*  92 */     setProperties(properties);
/*     */   }
/*     */ 
/*     */   public MBeanInfo build()
/*     */     throws NotCompliantMBeanException
/*     */   {
/*     */     try
/*     */     {
/* 101 */       if (this.element == null)
/*     */       {
/* 103 */         throw new JBossNotCompliantMBeanException("No xml configuration supplied!");
/*     */       }
/* 105 */       String description = this.element.elementTextTrim("description");
/*     */ 
/* 107 */       if (this.resourceClassName == null)
/*     */       {
/* 109 */         this.resourceClassName = this.element.elementTextTrim("class");
/*     */       }
/*     */ 
/* 112 */       List constructors = this.element.elements("constructor");
/* 113 */       List operations = this.element.elements("operation");
/* 114 */       List attributes = this.element.elements("attribute");
/* 115 */       List notifications = this.element.elements("notification");
/*     */ 
/* 117 */       Descriptor descr = getDescriptor(this.element, this.mmbClassName, "mbean");
/*     */ 
/* 119 */       ModelMBeanInfo info = buildMBeanMetaData(description, constructors, operations, attributes, notifications, descr);
/*     */ 
/* 124 */       return (MBeanInfo)info;
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 128 */     throw new JBossNotCompliantMBeanException("Error parsing the XML file: ", t);
/*     */   }
/*     */ 
/*     */   protected Descriptor getDescriptor(org.dom4j.Element parent, String infoName, String type)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 138 */     Descriptor descr = new DescriptorSupport();
/* 139 */     descr.setField("name", infoName);
/* 140 */     descr.setField("displayName", infoName);
/* 141 */     descr.setField("descriptorType", type);
/*     */ 
/* 143 */     org.dom4j.Element descriptors = parent.element("descriptors");
/* 144 */     if (descriptors == null)
/*     */     {
/* 146 */       return descr;
/*     */     }
/*     */ 
/* 149 */     for (Iterator i = descriptors.elementIterator(); i.hasNext(); )
/*     */     {
/* 151 */       org.dom4j.Element descriptor = (org.dom4j.Element)i.next();
/* 152 */       String name = descriptor.getName();
/* 153 */       if (name.equals("persistence"))
/*     */       {
/* 155 */         String persistPolicy = descriptor.attributeValue("persistPolicy");
/* 156 */         String persistPeriod = descriptor.attributeValue("persistPeriod");
/* 157 */         String persistLocation = descriptor.attributeValue("persistLocation");
/* 158 */         String persistName = descriptor.attributeValue("persistName");
/* 159 */         if (persistPolicy != null)
/*     */         {
/* 161 */           validate(persistPolicy, PERSIST_POLICIES);
/* 162 */           descr.setField("persistPolicy", persistPolicy);
/*     */         }
/* 164 */         if (persistPeriod != null)
/*     */         {
/* 166 */           descr.setField("persistPeriod", persistPeriod);
/*     */         }
/* 168 */         if (persistLocation != null)
/*     */         {
/* 170 */           descr.setField("persistLocation", persistLocation);
/*     */         }
/* 172 */         if (persistName != null)
/*     */         {
/* 174 */           descr.setField("persistName", persistName);
/*     */         }
/*     */       }
/* 177 */       else if (name.equals("currencyTimeLimit"))
/*     */       {
/* 179 */         descr.setField("currencyTimeLimit", descriptor.attributeValue("value"));
/*     */       }
/* 181 */       else if (name.equals("default"))
/*     */       {
/* 183 */         String value = descriptor.attributeValue("value");
/* 184 */         descr.setField("default", value);
/*     */       }
/* 186 */       else if (name.equals("display-name"))
/*     */       {
/* 188 */         String value = descriptor.attributeValue("value");
/* 189 */         descr.setField("displayName", value);
/*     */       }
/* 191 */       else if (name.equals("value"))
/*     */       {
/* 193 */         String value = descriptor.attributeValue("value");
/* 194 */         descr.setField("value", value);
/*     */       }
/* 196 */       else if (name.equals("persistence-manager"))
/*     */       {
/* 198 */         descr.setField("persistence-manager", descriptor.attributeValue("value"));
/*     */       }
/* 200 */       else if (name.equals("descriptor"))
/*     */       {
/* 202 */         descr.setField(descriptor.attributeValue("name"), descriptor.attributeValue("value"));
/*     */       }
/* 204 */       else if (name.equals("injection"))
/*     */       {
/* 206 */         descr.setField(descriptor.attributeValue("id"), descriptor.attributeValue("setMethod"));
/*     */       }
/* 208 */       else if (name.equals("interceptors"))
/*     */       {
/* 210 */         Descriptor[] interceptorDescriptors = buildInterceptors(descriptor);
/* 211 */         descr.setField("interceptors", interceptorDescriptors);
/*     */       }
/*     */     }
/*     */ 
/* 215 */     return descr;
/*     */   }
/*     */ 
/*     */   private void validate(String value, String[] valid) throws NotCompliantMBeanException
/*     */   {
/* 220 */     for (int i = 0; i < valid.length; i++)
/*     */     {
/* 222 */       if (valid[i].equalsIgnoreCase(value))
/*     */       {
/* 224 */         return;
/*     */       }
/*     */     }
/* 227 */     throw new JBossNotCompliantMBeanException("Unknown descriptor value: " + value);
/*     */   }
/*     */ 
/*     */   protected ModelMBeanInfo buildMBeanMetaData(String description, List constructors, List operations, List attributes, List notifications, Descriptor descr)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 239 */     ModelMBeanOperationInfo[] operInfo = buildOperationInfo(operations);
/*     */ 
/* 241 */     ModelMBeanAttributeInfo[] attrInfo = buildAttributeInfo(attributes);
/*     */ 
/* 243 */     ModelMBeanConstructorInfo[] constrInfo = buildConstructorInfo(constructors);
/*     */ 
/* 245 */     ModelMBeanNotificationInfo[] notifInfo = buildNotificationInfo(notifications);
/*     */ 
/* 248 */     ModelMBeanInfo info = new ModelMBeanInfoSupport(this.mmbClassName, description, attrInfo, constrInfo, operInfo, notifInfo, descr);
/*     */ 
/* 253 */     return info;
/*     */   }
/*     */ 
/*     */   protected ModelMBeanConstructorInfo[] buildConstructorInfo(List constructors)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 261 */     List infos = new ArrayList();
/*     */ 
/* 263 */     for (Iterator it = constructors.iterator(); it.hasNext(); )
/*     */     {
/* 265 */       org.dom4j.Element constr = (org.dom4j.Element)it.next();
/* 266 */       String name = constr.elementTextTrim("name");
/* 267 */       String description = constr.elementTextTrim("description");
/* 268 */       List params = constr.elements("parameter");
/*     */ 
/* 270 */       MBeanParameterInfo[] paramInfo = buildParameterInfo(params);
/*     */ 
/* 273 */       Descriptor descr = getDescriptor(constr, name, "operation");
/* 274 */       descr.setField("role", "constructor");
/*     */ 
/* 276 */       ModelMBeanConstructorInfo info = new ModelMBeanConstructorInfo(name, description, paramInfo, descr);
/*     */ 
/* 279 */       infos.add(info);
/*     */     }
/*     */ 
/* 282 */     return (ModelMBeanConstructorInfo[])(ModelMBeanConstructorInfo[])infos.toArray(new ModelMBeanConstructorInfo[0]);
/*     */   }
/*     */ 
/*     */   protected ModelMBeanOperationInfo[] buildOperationInfo(List operations)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 289 */     List infos = new ArrayList();
/*     */ 
/* 291 */     for (Iterator it = operations.iterator(); it.hasNext(); )
/*     */     {
/* 293 */       org.dom4j.Element oper = (org.dom4j.Element)it.next();
/* 294 */       String name = oper.elementTextTrim("name");
/* 295 */       String description = oper.elementTextTrim("description");
/* 296 */       String type = oper.elementTextTrim("return-type");
/* 297 */       String impact = oper.attributeValue("impact");
/* 298 */       List params = oper.elements("parameter");
/*     */ 
/* 300 */       MBeanParameterInfo[] paramInfo = buildParameterInfo(params);
/*     */ 
/* 303 */       Descriptor descr = getDescriptor(oper, name, "operation");
/* 304 */       descr.setField("role", "operation");
/*     */ 
/* 307 */       int operImpact = 2;
/*     */ 
/* 309 */       if (impact != null)
/*     */       {
/* 311 */         if (impact.equals("INFO"))
/* 312 */           operImpact = 0;
/* 313 */         else if (impact.equals("ACTION"))
/* 314 */           operImpact = 1;
/* 315 */         else if (impact.equals("ACTION_INFO")) {
/* 316 */           operImpact = 2;
/*     */         }
/*     */       }
/*     */ 
/* 320 */       if (type == null) {
/* 321 */         type = "void";
/*     */       }
/* 323 */       ModelMBeanOperationInfo info = new ModelMBeanOperationInfo(name, description, paramInfo, type, operImpact, descr);
/*     */ 
/* 326 */       infos.add(info);
/*     */     }
/*     */ 
/* 329 */     return (ModelMBeanOperationInfo[])(ModelMBeanOperationInfo[])infos.toArray(new ModelMBeanOperationInfo[0]);
/*     */   }
/*     */ 
/*     */   protected ModelMBeanNotificationInfo[] buildNotificationInfo(List notifications)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 338 */     List infos = new ArrayList();
/*     */ 
/* 340 */     for (Iterator it = notifications.iterator(); it.hasNext(); )
/*     */     {
/* 342 */       org.dom4j.Element notif = (org.dom4j.Element)it.next();
/* 343 */       String name = notif.elementTextTrim("name");
/* 344 */       String description = notif.elementTextTrim("description");
/* 345 */       List notifTypes = notif.elements("notification-type");
/* 346 */       Descriptor descr = getDescriptor(notif, name, "notification");
/*     */ 
/* 348 */       List types = new ArrayList();
/*     */ 
/* 350 */       for (Iterator iterator = notifTypes.iterator(); iterator.hasNext(); )
/*     */       {
/* 352 */         org.dom4j.Element type = (org.dom4j.Element)iterator.next();
/* 353 */         types.add(type.getTextTrim());
/*     */       }
/*     */ 
/* 356 */       ModelMBeanNotificationInfo info = new ModelMBeanNotificationInfo((String[])(String[])types.toArray(new String[types.size()]), name, description, descr);
/*     */ 
/* 359 */       infos.add(info);
/*     */     }
/*     */ 
/* 362 */     return (ModelMBeanNotificationInfo[])(ModelMBeanNotificationInfo[])infos.toArray(new ModelMBeanNotificationInfo[infos.size()]);
/*     */   }
/*     */ 
/*     */   protected ModelMBeanAttributeInfo[] buildAttributeInfo(List attributes)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 371 */     List infos = new ArrayList();
/*     */ 
/* 373 */     for (Iterator it = attributes.iterator(); it.hasNext(); )
/*     */     {
/* 375 */       org.dom4j.Element attr = (org.dom4j.Element)it.next();
/* 376 */       String name = attr.elementTextTrim("name");
/* 377 */       String description = attr.elementTextTrim("description");
/* 378 */       String type = attr.elementTextTrim("type");
/* 379 */       String access = attr.attributeValue("access");
/* 380 */       String getMethod = attr.attributeValue("getMethod");
/* 381 */       String setMethod = attr.attributeValue("setMethod");
/* 382 */       Descriptor descr = getDescriptor(attr, name, "attribute");
/*     */ 
/* 384 */       String unconvertedValue = (String)descr.getFieldValue("value");
/* 385 */       if ((unconvertedValue != null) && (!"java.lang.String".equals(type)))
/*     */       {
/* 387 */         descr.setField("value", convertValue(unconvertedValue, type));
/*     */       }
/*     */       else
/*     */       {
/* 394 */         Object value = getAttributeValue(attr, type, "value");
/* 395 */         if (value != null)
/* 396 */           descr.setField("value", value);
/*     */       }
/* 398 */       String unconvertedDefault = (String)descr.getFieldValue("default");
/* 399 */       if ((unconvertedDefault != null) && (!"java.lang.String".equals(type)))
/*     */       {
/* 401 */         descr.setField("default", convertValue(unconvertedDefault, type));
/*     */       }
/*     */       else
/*     */       {
/* 408 */         Object value = getAttributeValue(attr, type, "default");
/* 409 */         if (value != null)
/* 410 */           descr.setField("default", value);
/*     */       }
/* 412 */       if (getMethod != null)
/*     */       {
/* 414 */         descr.setField("getMethod", getMethod);
/*     */       }
/*     */ 
/* 417 */       if (setMethod != null)
/*     */       {
/* 419 */         descr.setField("setMethod", setMethod);
/*     */       }
/*     */ 
/* 424 */       boolean isReadable = true;
/* 425 */       boolean isWritable = true;
/*     */ 
/* 427 */       if (access.equalsIgnoreCase("read-only")) {
/* 428 */         isWritable = false;
/*     */       }
/* 430 */       else if (access.equalsIgnoreCase("write-only")) {
/* 431 */         isReadable = false;
/*     */       }
/*     */ 
/* 434 */       ModelMBeanAttributeInfo info = new ModelMBeanAttributeInfo(name, type, description, isReadable, isWritable, false, descr);
/*     */ 
/* 439 */       infos.add(info);
/*     */     }
/*     */ 
/* 442 */     return (ModelMBeanAttributeInfo[])(ModelMBeanAttributeInfo[])infos.toArray(new ModelMBeanAttributeInfo[0]);
/*     */   }
/*     */ 
/*     */   protected Object getAttributeValue(org.dom4j.Element attribute, String typeName, String which)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 454 */     Object value = null;
/*     */ 
/* 456 */     org.dom4j.Element descriptors = attribute.element("descriptors");
/*     */     Iterator i;
/* 457 */     if (descriptors != null)
/*     */     {
/* 459 */       for (i = descriptors.elementIterator(); i.hasNext(); )
/*     */       {
/* 462 */         org.dom4j.Element descriptor = (org.dom4j.Element)i.next();
/* 463 */         String name = descriptor.getName();
/* 464 */         if ((name.equals(which)) && (descriptor.hasContent()))
/*     */         {
/*     */           try
/*     */           {
/* 478 */             org.w3c.dom.Element element = toW3CElement(descriptor);
/*     */ 
/* 480 */             boolean replace = true;
/* 481 */             boolean trim = true;
/*     */ 
/* 483 */             String replaceAttr = element.getAttribute("replace");
/* 484 */             if (replaceAttr.length() > 0)
/* 485 */               replace = Boolean.valueOf(replaceAttr).booleanValue();
/* 486 */             String trimAttr = element.getAttribute("trim");
/* 487 */             if (trimAttr.length() > 0) {
/* 488 */               trim = Boolean.valueOf(trimAttr).booleanValue();
/*     */             }
/*     */ 
/* 491 */             ClassLoader cl = Thread.currentThread().getContextClassLoader();
/*     */ 
/* 494 */             Class typeClass = Classes.getPrimitiveTypeForName(typeName);
/* 495 */             if (typeClass == null)
/*     */             {
/*     */               try
/*     */               {
/* 500 */                 typeClass = cl.loadClass(typeName);
/*     */               }
/*     */               catch (ClassNotFoundException e)
/*     */               {
/* 504 */                 throw new JBossNotCompliantMBeanException("Class not found '" + typeName + "'", e);
/*     */               }
/*     */ 
/*     */             }
/*     */ 
/* 512 */             if (typeClass.equals(org.w3c.dom.Element.class))
/*     */             {
/* 515 */               NodeList nl = element.getChildNodes();
/* 516 */               for (int j = 0; j < nl.getLength(); j++)
/*     */               {
/* 518 */                 Node n = nl.item(j);
/* 519 */                 if (n.getNodeType() != 1)
/*     */                   continue;
/* 521 */                 value = n;
/* 522 */                 break;
/*     */               }
/*     */ 
/* 526 */               if (replace)
/*     */               {
/* 528 */                 PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
/* 529 */                 if (editor == null)
/*     */                 {
/* 531 */                   log.warn("Cannot perform property replace on Element");
/*     */                 }
/*     */                 else
/*     */                 {
/* 535 */                   editor.setValue(value);
/* 536 */                   String text = editor.getAsText();
/* 537 */                   text = StringPropertyReplacer.replaceProperties(text);
/* 538 */                   editor.setAsText(text);
/* 539 */                   value = editor.getValue();
/*     */                 }
/*     */               }
/*     */             }
/*     */ 
/* 544 */             if (value == null)
/*     */             {
/* 546 */               PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
/* 547 */               if (editor == null)
/*     */               {
/* 549 */                 throw new JBossNotCompliantMBeanException("No property editor for type '" + typeName + "'");
/*     */               }
/*     */ 
/* 553 */               String attributeText = getElementContent(element, trim, replace);
/* 554 */               editor.setAsText(attributeText);
/* 555 */               value = editor.getValue();
/*     */             }
/*     */           }
/*     */           catch (DocumentException e)
/*     */           {
/* 560 */             throw new JBossNotCompliantMBeanException("cannot convert '" + which + "' descriptor to org.w3c.dom.Element", e);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 569 */     return value;
/*     */   }
/*     */ 
/*     */   private org.w3c.dom.Element toW3CElement(org.dom4j.Element d4element)
/*     */     throws DocumentException
/*     */   {
/* 579 */     org.dom4j.Document d4doc = DocumentFactory.getInstance().createDocument();
/* 580 */     DOMWriter d4Writer = new DOMWriter();
/*     */ 
/* 582 */     d4doc.setRootElement(d4element.createCopy());
/*     */ 
/* 584 */     org.w3c.dom.Document doc = d4Writer.write(d4doc);
/*     */ 
/* 586 */     return doc.getDocumentElement();
/*     */   }
/*     */ 
/*     */   private String getElementContent(org.w3c.dom.Element element, boolean trim, boolean replace)
/*     */   {
/* 594 */     NodeList nl = element.getChildNodes();
/* 595 */     String attributeText = "";
/* 596 */     for (int i = 0; i < nl.getLength(); i++)
/*     */     {
/* 598 */       Node n = nl.item(i);
/* 599 */       if (!(n instanceof Text))
/*     */         continue;
/* 601 */       attributeText = attributeText + ((Text)n).getData();
/*     */     }
/*     */ 
/* 604 */     if (trim)
/* 605 */       attributeText = attributeText.trim();
/* 606 */     if (replace)
/* 607 */       attributeText = StringPropertyReplacer.replaceProperties(attributeText);
/* 608 */     return attributeText;
/*     */   }
/*     */ 
/*     */   protected Object convertValue(String unconverted, String typeName)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 623 */     Object value = null;
/*     */     try
/*     */     {
/* 626 */       value = PropertyEditors.convertValue(unconverted, typeName);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 630 */       log.debug("Failed to load type class", e);
/* 631 */       throw new NotCompliantMBeanException("Class not found for type: " + typeName);
/*     */     }
/*     */     catch (IntrospectionException e)
/*     */     {
/* 636 */       throw new NotCompliantMBeanException("No property editor for type=" + typeName);
/*     */     }
/*     */ 
/* 639 */     return value;
/*     */   }
/*     */ 
/*     */   protected MBeanParameterInfo[] buildParameterInfo(List parameters)
/*     */   {
/* 644 */     Iterator it = parameters.iterator();
/* 645 */     List infos = new ArrayList();
/*     */ 
/* 647 */     while (it.hasNext())
/*     */     {
/* 649 */       org.dom4j.Element param = (org.dom4j.Element)it.next();
/* 650 */       String name = param.elementTextTrim("name");
/* 651 */       String type = param.elementTextTrim("type");
/* 652 */       String descr = param.elementTextTrim("description");
/*     */ 
/* 654 */       MBeanParameterInfo info = new MBeanParameterInfo(name, type, descr);
/*     */ 
/* 656 */       infos.add(info);
/*     */     }
/*     */ 
/* 659 */     return (MBeanParameterInfo[])(MBeanParameterInfo[])infos.toArray(new MBeanParameterInfo[0]);
/*     */   }
/*     */ 
/*     */   protected Descriptor[] buildInterceptors(org.dom4j.Element descriptor)
/*     */   {
/* 664 */     List interceptors = descriptor.elements("interceptor");
/* 665 */     ArrayList tmp = new ArrayList();
/* 666 */     for (int i = 0; i < interceptors.size(); i++)
/*     */     {
/* 668 */       org.dom4j.Element interceptor = (org.dom4j.Element)interceptors.get(i);
/* 669 */       String code = interceptor.attributeValue("code");
/* 670 */       DescriptorSupport interceptorDescr = new DescriptorSupport();
/* 671 */       interceptorDescr.setField("code", code);
/* 672 */       List attributes = interceptor.attributes();
/* 673 */       for (int a = 0; a < attributes.size(); a++)
/*     */       {
/* 675 */         Attribute attr = (Attribute)attributes.get(a);
/* 676 */         String name = attr.getName();
/* 677 */         String value = attr.getValue();
/* 678 */         value = StringPropertyReplacer.replaceProperties(value);
/* 679 */         interceptorDescr.setField(name, value);
/*     */       }
/* 681 */       tmp.add(interceptorDescr);
/*     */     }
/* 683 */     Descriptor[] descriptors = new Descriptor[tmp.size()];
/* 684 */     tmp.toArray(descriptors);
/* 685 */     return descriptors;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.JBossXMBean10
 * JD-Core Version:    0.6.0
 */