/*     */ package org.jboss.mx.metadata;
/*     */ 
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.NotCompliantMBeanException;
/*     */ import org.dom4j.Document;
/*     */ import org.dom4j.DocumentException;
/*     */ import org.dom4j.DocumentType;
/*     */ import org.dom4j.Element;
/*     */ import org.dom4j.io.SAXReader;
/*     */ import org.jboss.mx.modelmbean.XMBeanConstants;
/*     */ import org.jboss.mx.service.ServiceConstants;
/*     */ import org.jboss.mx.util.JBossNotCompliantMBeanException;
/*     */ import org.jboss.util.xml.JBossEntityResolver;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class XMLMetaData extends AbstractBuilder
/*     */   implements ServiceConstants, XMBeanConstants
/*     */ {
/*     */   private static final int NO_VERSION = -1;
/*     */   private static final int JBOSS_XMBEAN_1_0 = 0;
/*     */   private static final int JBOSS_XMBEAN_1_1 = 1;
/*     */   private static final int JBOSS_XMBEAN_1_2 = 2;
/*  67 */   private URL url = null;
/*     */   private Element element;
/*     */   private String versionString;
/*  76 */   private String resourceClassName = null;
/*     */ 
/*  81 */   private String mmbClassName = null;
/*     */ 
/*     */   public XMLMetaData(String mmbClassName, String resourceClassName, URL url)
/*     */   {
/* 100 */     this.url = url;
/* 101 */     this.mmbClassName = mmbClassName;
/* 102 */     this.resourceClassName = resourceClassName;
/*     */   }
/*     */ 
/*     */   public XMLMetaData(String mmbClassName, String resourceClassName, String url)
/*     */     throws MalformedURLException
/*     */   {
/* 120 */     this(mmbClassName, resourceClassName, new URL(url));
/*     */   }
/*     */ 
/*     */   public XMLMetaData(String mmbClassName, String resourceClassName, URL url, Map properties)
/*     */   {
/* 139 */     this(mmbClassName, resourceClassName, url);
/* 140 */     setProperties(properties);
/*     */   }
/*     */ 
/*     */   public XMLMetaData(String mmbClassName, String resourceClassName, String url, Map properties)
/*     */     throws MalformedURLException
/*     */   {
/* 162 */     this(mmbClassName, resourceClassName, new URL(url), properties);
/*     */   }
/*     */ 
/*     */   public XMLMetaData(String mmbClassName, String resourceClassName, Element element, String version)
/*     */   {
/* 178 */     this.mmbClassName = mmbClassName;
/* 179 */     this.resourceClassName = resourceClassName;
/* 180 */     this.element = element;
/* 181 */     this.versionString = version;
/*     */   }
/*     */ 
/*     */   public MBeanInfo build()
/*     */     throws NotCompliantMBeanException
/*     */   {
/*     */     try
/*     */     {
/* 215 */       int version = -1;
/*     */ 
/* 217 */       if (this.versionString == null)
/*     */       {
/* 220 */         SAXReader reader = new SAXReader();
/*     */ 
/* 223 */         if (this.properties.get("xmbean.metadata.sax.parser") != null)
/*     */         {
/*     */           try
/*     */           {
/* 227 */             reader.setXMLReaderClassName(getStringProperty("xmbean.metadata.sax.parser"));
/*     */           }
/*     */           catch (SAXException e)
/*     */           {
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 236 */         reader.setValidation(true);
/*     */         try
/*     */         {
/* 241 */           boolean validate = getBooleanProperty("xmbean.metadata.xml.validate");
/* 242 */           reader.setValidation(validate);
/*     */         }
/*     */         catch (IllegalPropertyException e)
/*     */         {
/*     */         }
/*     */ 
/* 252 */         reader.setEntityResolver(new JBossEntityResolver());
/*     */ 
/* 255 */         Document doc = reader.read(this.url);
/* 256 */         this.element = doc.getRootElement();
/* 257 */         DocumentType type = doc.getDocType();
/*     */ 
/* 259 */         version = validateVersionString(type.getPublicID());
/* 260 */         if (version == -1)
/*     */         {
/* 262 */           version = validateVersionString(type.getSystemID());
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 268 */         version = validateVersionString(this.versionString);
/*     */       }
/*     */ 
/* 271 */       if (this.element == null)
/*     */       {
/* 273 */         throw new IllegalStateException("No element supplied with explict version!");
/*     */       }
/*     */ 
/* 277 */       if ((version == 0) || (version == 1) || (version == 2))
/*     */       {
/* 282 */         return new JBossXMBean10(this.mmbClassName, this.resourceClassName, this.element, this.properties).build();
/*     */       }
/*     */ 
/* 286 */       throw new NotCompliantMBeanException("Unknown xmbean type " + this.versionString);
/*     */     }
/*     */     catch (DocumentException e)
/*     */     {
/*     */     }
/*     */ 
/* 292 */     throw new JBossNotCompliantMBeanException("Error parsing the XML file, from XMLMetaData: ", e);
/*     */   }
/*     */ 
/*     */   private int validateVersionString(String versionString)
/*     */   {
/* 298 */     if ("-//JBoss//DTD JBOSS XMBEAN 1.0//EN".equals(versionString))
/*     */     {
/* 300 */       return 0;
/*     */     }
/* 302 */     if ((versionString != null) && (versionString.endsWith("jboss_xmbean_1_0.dtd")))
/*     */     {
/* 304 */       return 0;
/*     */     }
/* 306 */     if ("-//JBoss//DTD JBOSS XMBEAN 1.1//EN".equals(versionString))
/*     */     {
/* 308 */       return 1;
/*     */     }
/* 310 */     if ((versionString != null) && (versionString.endsWith("jboss_xmbean_1_1.dtd")))
/*     */     {
/* 312 */       return 1;
/*     */     }
/* 314 */     if ("-//JBoss//DTD JBOSS XMBEAN 1.2//EN".equals(versionString))
/*     */     {
/* 316 */       return 2;
/*     */     }
/* 318 */     if ((versionString != null) && (versionString.endsWith("jboss_xmbean_1_2.dtd")))
/*     */     {
/* 320 */       return 2;
/*     */     }
/*     */ 
/* 324 */     return -1;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.metadata.XMLMetaData
 * JD-Core Version:    0.6.0
 */