/*     */ package org.jboss.mx.modelmbean;
/*     */ 
/*     */ import java.beans.BeanInfo;
/*     */ import java.beans.IntrospectionException;
/*     */ import java.beans.Introspector;
/*     */ import java.beans.PropertyDescriptor;
/*     */ import java.beans.PropertyEditor;
/*     */ import java.beans.PropertyEditorManager;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeChangeNotification;
/*     */ import javax.management.AttributeChangeNotificationFilter;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.JMException;
/*     */ import javax.management.ListenerNotFoundException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.RuntimeErrorException;
/*     */ import javax.management.RuntimeOperationsException;
/*     */ import javax.management.modelmbean.InvalidTargetObjectTypeException;
/*     */ import javax.management.modelmbean.ModelMBean;
/*     */ import javax.management.modelmbean.ModelMBeanAttributeInfo;
/*     */ import javax.management.modelmbean.ModelMBeanInfo;
/*     */ import javax.management.modelmbean.ModelMBeanInfoSupport;
/*     */ import javax.management.modelmbean.ModelMBeanOperationInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.interceptor.AbstractInterceptor;
/*     */ import org.jboss.mx.interceptor.Interceptor;
/*     */ import org.jboss.mx.interceptor.ModelMBeanAttributeInterceptor;
/*     */ import org.jboss.mx.interceptor.ModelMBeanInfoInterceptor;
/*     */ import org.jboss.mx.interceptor.ModelMBeanInterceptor;
/*     */ import org.jboss.mx.interceptor.ModelMBeanOperationInterceptor;
/*     */ import org.jboss.mx.interceptor.NullInterceptor;
/*     */ import org.jboss.mx.interceptor.ObjectReferenceInterceptor;
/*     */ import org.jboss.mx.interceptor.PersistenceInterceptor;
/*     */ import org.jboss.mx.interceptor.PersistenceInterceptor2;
/*     */ import org.jboss.mx.persistence.NullPersistence;
/*     */ import org.jboss.mx.persistence.PersistenceManager;
/*     */ import org.jboss.mx.server.AbstractMBeanInvoker;
/*     */ import org.jboss.mx.server.AbstractMBeanInvoker.OperationKey;
/*     */ import org.jboss.mx.server.Invocation;
/*     */ import org.jboss.mx.server.InvocationContext;
/*     */ import org.jboss.mx.server.MBeanInvoker;
/*     */ import org.jboss.mx.server.registry.MBeanEntry;
/*     */ import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
/*     */ 
/*     */ public abstract class ModelMBeanInvoker extends AbstractMBeanInvoker
/*     */   implements ModelMBean, ModelMBeanConstants
/*     */ {
/*  99 */   Logger log = Logger.getLogger(ModelMBeanInvoker.class.getName());
/*     */ 
/* 111 */   protected String resourceType = null;
/*     */ 
/* 116 */   protected PersistenceManager persistence = new NullPersistence();
/*     */ 
/* 121 */   protected JBossNotificationBroadcasterSupport notifier = new JBossNotificationBroadcasterSupport();
/*     */ 
/* 126 */   protected long notifierSequence = 1L;
/*     */ 
/* 131 */   protected long attrNotifierSequence = 1L;
/*     */ 
/*     */   public ModelMBeanInvoker()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ModelMBeanInvoker(ModelMBeanInfo info)
/*     */     throws MBeanException
/*     */   {
/* 151 */     setModelMBeanInfo(info);
/*     */   }
/*     */ 
/*     */   public void setModelMBeanInfo(ModelMBeanInfo info)
/*     */     throws MBeanException, RuntimeOperationsException
/*     */   {
/* 166 */     if (info == null) {
/* 167 */       throw new RuntimeOperationsException(new IllegalArgumentException("MBeanInfo cannot be null"));
/*     */     }
/*     */ 
/* 170 */     this.info = new ModelMBeanInfoSupport(info);
/*     */ 
/* 173 */     ModelMBeanInfo minfo = info;
/* 174 */     Descriptor mbeanDescriptor = null;
/*     */     try
/*     */     {
/* 177 */       mbeanDescriptor = minfo.getDescriptor("", "mbean");
/*     */     }
/*     */     catch (MBeanException e)
/*     */     {
/* 182 */       this.log.warn("Failed to obtain descriptor: mbean", e);
/* 183 */       return;
/*     */     }
/*     */ 
/* 186 */     String type = (String)mbeanDescriptor.getFieldValue("MBeanInfoType");
/*     */ 
/* 188 */     if (type != null)
/*     */     {
/* 190 */       inject("MBeanInfoType", type, MBeanInfo.class, info);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setManagedResource(Object ref, String resourceType)
/*     */     throws MBeanException, InstanceNotFoundException, InvalidTargetObjectTypeException
/*     */   {
/* 206 */     if (!isSupportedResourceType(ref, resourceType)) {
/* 207 */       throw new InvalidTargetObjectTypeException("Unsupported resource type: " + resourceType);
/*     */     }
/* 209 */     setResource(ref);
/* 210 */     this.resourceType = resourceType;
/*     */ 
/* 212 */     if (getServer() != null)
/*     */     {
/*     */       try
/*     */       {
/* 216 */         init(getServer(), this.resourceEntry.getObjectName());
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 220 */         throw new MBeanException(e, "Failed to init from resource");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*     */   {
/* 231 */     this.notifier.addNotificationListener(listener, filter, handback);
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(NotificationListener listener)
/*     */     throws ListenerNotFoundException
/*     */   {
/* 237 */     this.notifier.removeNotificationListener(listener);
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*     */     throws ListenerNotFoundException
/*     */   {
/* 245 */     this.notifier.removeNotificationListener(listener, filter, handback);
/*     */   }
/*     */ 
/*     */   public void sendNotification(String ntfyText)
/*     */     throws MBeanException, RuntimeOperationsException
/*     */   {
/* 258 */     if (ntfyText == null)
/*     */     {
/* 260 */       throw new RuntimeOperationsException(new IllegalArgumentException("ntfyText cannot be null"));
/*     */     }
/*     */ 
/* 264 */     Notification notif = new Notification("jmx.modelmbean.generic", this, 1L, ntfyText);
/*     */ 
/* 271 */     sendNotification(notif);
/*     */   }
/*     */ 
/*     */   public void sendNotification(Notification ntfyObj)
/*     */     throws MBeanException, RuntimeOperationsException
/*     */   {
/* 282 */     if (ntfyObj == null)
/*     */     {
/* 284 */       throw new RuntimeOperationsException(new IllegalArgumentException("ntfyText cannot be null"));
/*     */     }
/*     */ 
/* 288 */     this.notifier.sendNotification(ntfyObj);
/*     */   }
/*     */ 
/*     */   public void sendAttributeChangeNotification(AttributeChangeNotification notification)
/*     */     throws MBeanException
/*     */   {
/* 299 */     if (notification == null)
/*     */     {
/* 301 */       throw new RuntimeOperationsException(new IllegalArgumentException("notification cannot be null"));
/*     */     }
/*     */ 
/* 305 */     this.notifier.sendNotification(notification);
/*     */   }
/*     */ 
/*     */   public void sendAttributeChangeNotification(Attribute oldValue, Attribute newValue)
/*     */     throws MBeanException, RuntimeOperationsException
/*     */   {
/* 320 */     if ((oldValue == null) || (newValue == null))
/*     */     {
/* 322 */       throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"));
/*     */     }
/*     */ 
/* 326 */     if (!oldValue.getName().equals(newValue.getName()))
/*     */     {
/* 328 */       throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name mismatch between oldvalue and newvalue"));
/*     */     }
/*     */ 
/* 333 */     String attr = oldValue.getName();
/* 334 */     String type = ((ModelMBeanInfo)this.info).getAttribute(attr).getType();
/*     */ 
/* 336 */     AttributeChangeNotification notif = new AttributeChangeNotification(this, 1L, System.currentTimeMillis(), "" + attr + " changed from " + oldValue + " to " + newValue, attr, type, oldValue.getValue(), newValue.getValue());
/*     */ 
/* 346 */     this.notifier.sendNotification(notif);
/*     */   }
/*     */ 
/*     */   public MBeanNotificationInfo[] getNotificationInfo()
/*     */   {
/* 351 */     return this.info.getNotifications();
/*     */   }
/*     */ 
/*     */   public void addAttributeChangeNotificationListener(NotificationListener listener, String attributeName, Object handback)
/*     */     throws MBeanException
/*     */   {
/* 362 */     ModelMBeanInfo minfo = (ModelMBeanInfo)this.info;
/* 363 */     AttributeChangeNotificationFilter filter = null;
/* 364 */     if (attributeName != null)
/*     */     {
/* 366 */       ModelMBeanAttributeInfo ainfo = minfo.getAttribute(attributeName);
/* 367 */       if (ainfo == null)
/*     */       {
/* 369 */         throw new RuntimeOperationsException(new IllegalArgumentException("Attribute does not exist: " + attributeName));
/*     */       }
/*     */ 
/* 372 */       filter = new AttributeChangeNotificationFilter();
/* 373 */       filter.enableAttribute(attributeName);
/*     */     }
/*     */     else
/*     */     {
/* 377 */       filter = new AttributeChangeNotificationFilter();
/* 378 */       MBeanAttributeInfo[] allAttributes = minfo.getAttributes();
/* 379 */       for (int i = 0; i < allAttributes.length; i++)
/* 380 */         filter.enableAttribute(allAttributes[i].getName());
/*     */     }
/* 382 */     this.notifier.addNotificationListener(listener, filter, handback);
/*     */   }
/*     */ 
/*     */   public void removeAttributeChangeNotificationListener(NotificationListener listener, String attributeName)
/*     */     throws MBeanException, ListenerNotFoundException
/*     */   {
/* 391 */     if (attributeName != null)
/*     */     {
/* 394 */       ModelMBeanInfo minfo = (ModelMBeanInfo)this.info;
/* 395 */       ModelMBeanAttributeInfo ainfo = minfo.getAttribute(attributeName);
/* 396 */       if (ainfo == null)
/*     */       {
/* 398 */         throw new RuntimeOperationsException(new IllegalArgumentException("Attribute does not exist: " + attributeName));
/*     */       }
/*     */     }
/*     */ 
/* 402 */     this.notifier.removeNotificationListener(listener);
/*     */   }
/*     */ 
/*     */   public void load()
/*     */     throws MBeanException, InstanceNotFoundException
/*     */   {
/* 408 */     if (this.info == null) {
/* 409 */       return;
/*     */     }
/* 411 */     this.persistence.load(this, this.info);
/*     */   }
/*     */ 
/*     */   public void store() throws MBeanException, InstanceNotFoundException
/*     */   {
/* 416 */     this.persistence.store(this.info);
/*     */   }
/*     */ 
/*     */   public ObjectName invokePreRegister(MBeanServer server, ObjectName name)
/*     */     throws Exception
/*     */   {
/* 440 */     if (this.info == null)
/*     */     {
/* 442 */       throw new RuntimeErrorException(new Error("MBeanInfo has not been set."));
/*     */     }
/*     */ 
/* 447 */     ModelMBeanInfo minfo = (ModelMBeanInfo)this.info;
/* 448 */     Descriptor mbeanDescriptor = minfo.getMBeanDescriptor();
/* 449 */     this.getMBeanInfoCtx = new InvocationContext();
/* 450 */     this.getMBeanInfoCtx.setInvoker(this);
/* 451 */     this.getMBeanInfoCtx.setDescriptor(mbeanDescriptor);
/* 452 */     this.getMBeanInfoCtx.setDispatcher(new AbstractInterceptor("MBeanInfo Dispatcher", minfo)
/*     */     {
/*     */       public Object invoke(Invocation invocation) throws Throwable
/*     */       {
/* 456 */         return this.val$minfo;
/*     */       }
/*     */     });
/* 465 */     String[] signature = { "java.lang.Object", "java.lang.String" };
/* 466 */     AbstractMBeanInvoker.OperationKey opKey = new AbstractMBeanInvoker.OperationKey(this, "setManagedResource", signature);
/* 467 */     InvocationContext ctx = new InvocationContext();
/* 468 */     ctx.setInvoker(this);
/* 469 */     ctx.setDispatcher(new AbstractInterceptor("SetMangedResource Dispatcher")
/*     */     {
/*     */       public Object invoke(Invocation invocation) throws Throwable
/*     */       {
/* 473 */         Object[] args = invocation.getArgs();
/* 474 */         ModelMBeanInvoker.this.setManagedResource(args[0], (String)args[1]);
/* 475 */         return null;
/*     */       }
/*     */     });
/* 478 */     this.operationContextMap.put(opKey, ctx);
/*     */ 
/* 480 */     if (getResource() == null)
/*     */     {
/* 482 */       return name;
/*     */     }
/*     */ 
/* 486 */     init(server, name);
/*     */ 
/* 489 */     return super.invokePreRegister(server, name);
/*     */   }
/*     */ 
/*     */   protected void init(MBeanServer server, ObjectName name)
/*     */     throws Exception
/*     */   {
/* 503 */     ModelMBeanInfo minfo = (ModelMBeanInfo)this.info;
/* 504 */     configureInterceptorStack(minfo, server, name);
/* 505 */     initDispatchers();
/*     */ 
/* 508 */     Object resource = getResource();
/* 509 */     if (resource != null)
/*     */     {
/* 511 */       Descriptor mbeanDescriptor = minfo.getMBeanDescriptor();
/* 512 */       String resClassName = getResource().getClass().getName();
/* 513 */       mbeanDescriptor.setField("resourceClass", resClassName);
/* 514 */       minfo.setMBeanDescriptor(mbeanDescriptor);
/*     */     }
/*     */ 
/* 518 */     setValuesFromMBeanInfo();
/*     */ 
/* 520 */     initPersistence(server, name);
/*     */ 
/* 523 */     load();
/*     */   }
/*     */ 
/*     */   protected void initPersistence(MBeanServer server, ObjectName name) throws MBeanException, InstanceNotFoundException
/*     */   {
/* 534 */     ModelMBeanInfo minfo = (ModelMBeanInfo)getMetaData();
/*     */     Descriptor[] descriptors;
/*     */     try {
/* 538 */       descriptors = minfo.getDescriptors("mbean");
/*     */     }
/*     */     catch (MBeanException e)
/*     */     {
/* 542 */       this.log.error("Failed to obtain MBEAN_DESCRIPTORs", e);
/* 543 */       return;
/*     */     }
/*     */ 
/* 546 */     if (descriptors == null)
/*     */     {
/* 548 */       return;
/*     */     }
/* 550 */     String persistMgrName = null;
/* 551 */     for (int i = 0; (i < descriptors.length) && (persistMgrName == null); i++)
/*     */     {
/* 553 */       persistMgrName = (String)descriptors[i].getFieldValue("persistence-manager");
/*     */     }
/* 555 */     if (persistMgrName == null)
/*     */     {
/* 557 */       this.log.trace("No persistence-manager descriptor found, null persistence will be used");
/*     */ 
/* 559 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 564 */       this.persistence = ((PersistenceManager)server.instantiate(persistMgrName));
/* 565 */       this.log.debug("Loaded persistence mgr: " + persistMgrName);
/*     */ 
/* 569 */       Descriptor descriptor = minfo.getMBeanDescriptor();
/* 570 */       descriptor.setField("objectname", name);
/* 571 */       minfo.setMBeanDescriptor(descriptor);
/*     */     }
/*     */     catch (Exception cause)
/*     */     {
/* 575 */       this.log.error("Unable to instantiate the persistence manager:" + persistMgrName, cause);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initOperationContexts(MBeanOperationInfo[] operations)
/*     */   {
/* 583 */     super.initOperationContexts(operations);
/*     */ 
/* 585 */     for (int i = 0; i < operations.length; i++)
/*     */     {
/* 587 */       AbstractMBeanInvoker.OperationKey key = new AbstractMBeanInvoker.OperationKey(this, operations[i]);
/*     */ 
/* 589 */       InvocationContext ctx = (InvocationContext)this.operationContextMap.get(key);
/* 590 */       ModelMBeanOperationInfo info = (ModelMBeanOperationInfo)operations[i];
/* 591 */       ctx.setDescriptor(info.getDescriptor());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initAttributeContexts(MBeanAttributeInfo[] attributes)
/*     */   {
/* 597 */     super.initAttributeContexts(attributes);
/*     */ 
/* 599 */     for (int i = 0; i < attributes.length; i++)
/*     */     {
/* 601 */       ModelMBeanAttributeInfo info = (ModelMBeanAttributeInfo)attributes[i];
/* 602 */       String name = info.getName();
/* 603 */       InvocationContext ctx = (InvocationContext)this.attributeContextMap.get(name);
/* 604 */       ctx.setDescriptor(info.getDescriptor());
/* 605 */       ctx.setReadable(info.isReadable());
/* 606 */       ctx.setWritable(info.isWritable());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void configureInterceptorStack(ModelMBeanInfo info, MBeanServer server, ObjectName name)
/*     */     throws Exception
/*     */   {
/* 627 */     List defaultInterceptors = getInterceptors(this.getMBeanInfoCtx.getDescriptor());
/*     */ 
/* 629 */     List interceptors = null;
/* 630 */     if (defaultInterceptors != null)
/*     */     {
/* 632 */       interceptors = new ArrayList(defaultInterceptors);
/*     */     }
/* 634 */     if (interceptors == null)
/*     */     {
/* 637 */       interceptors = this.getMBeanInfoCtx.getInterceptors();
/*     */     }
/*     */ 
/* 643 */     String mbeanName = name != null ? name.toString() : info.getClassName();
/* 644 */     interceptors.add(new ModelMBeanInfoInterceptor(mbeanName));
/* 645 */     this.getMBeanInfoCtx.setInterceptors(interceptors);
/*     */ 
/* 648 */     for (Iterator it = this.attributeContextMap.entrySet().iterator(); it.hasNext(); )
/*     */     {
/* 650 */       Map.Entry entry = (Map.Entry)it.next();
/*     */ 
/* 652 */       InvocationContext ctx = (InvocationContext)entry.getValue();
/* 653 */       List list = getInterceptors(ctx.getDescriptor());
/* 654 */       if (list == null)
/*     */       {
/* 657 */         if (defaultInterceptors != null)
/*     */         {
/* 659 */           list = new ArrayList(defaultInterceptors);
/*     */         }
/*     */         else
/*     */         {
/* 663 */           list = new ArrayList();
/*     */         }
/*     */       }
/*     */ 
/* 667 */       list.add(new PersistenceInterceptor());
/* 668 */       list.add(new ModelMBeanAttributeInterceptor());
/* 669 */       ctx.setInterceptors(list);
/*     */     }
/*     */ 
/* 673 */     for (Iterator it = this.operationContextMap.entrySet().iterator(); it.hasNext(); )
/*     */     {
/* 675 */       Map.Entry entry = (Map.Entry)it.next();
/*     */ 
/* 677 */       InvocationContext ctx = (InvocationContext)entry.getValue();
/* 678 */       List list = getInterceptors(ctx.getDescriptor());
/* 679 */       if ((list == null) && (defaultInterceptors != null)) {
/* 680 */         list = new ArrayList(defaultInterceptors);
/*     */       }
/*     */ 
/* 683 */       if (this.dynamicResource)
/*     */       {
/* 685 */         if (list == null)
/*     */         {
/* 687 */           list = new ArrayList();
/*     */         }
/* 689 */         list.add(new ModelMBeanOperationInterceptor());
/*     */       }
/*     */ 
/* 692 */       if (list != null)
/*     */       {
/* 698 */         list.add(new NullInterceptor());
/* 699 */         ctx.setInterceptors(list);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected List getInterceptors(Descriptor d)
/*     */     throws Exception
/*     */   {
/* 712 */     if (d == null)
/* 713 */       return null;
/* 714 */     Descriptor[] interceptorDescriptors = (Descriptor[])(Descriptor[])d.getFieldValue("interceptors");
/* 715 */     if (interceptorDescriptors == null) {
/* 716 */       return null;
/*     */     }
/* 718 */     ArrayList interceptors = new ArrayList();
/* 719 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 720 */     for (int i = 0; i < interceptorDescriptors.length; i++)
/*     */     {
/* 722 */       Descriptor desc = interceptorDescriptors[i];
/* 723 */       String code = (String)desc.getFieldValue("code");
/*     */ 
/* 725 */       if ((code.equals(ModelMBeanInterceptor.class.getName())) || (code.equals(ObjectReferenceInterceptor.class.getName())) || (code.equals(PersistenceInterceptor2.class.getName())))
/*     */       {
/* 729 */         this.log.debug("Ignoring obsolete legacy interceptor: " + code);
/*     */       }
/*     */       else
/*     */       {
/* 733 */         Class interceptorClass = loader.loadClass(code);
/* 734 */         Interceptor interceptor = null;
/*     */ 
/* 736 */         Class[] ctorSig = { MBeanInvoker.class };
/*     */         try
/*     */         {
/* 739 */           Constructor ctor = interceptorClass.getConstructor(ctorSig);
/* 740 */           Object[] ctorArgs = { this };
/* 741 */           interceptor = (Interceptor)ctor.newInstance(ctorArgs);
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 745 */           this.log.debug("Could not invoke CTOR(MBeanInvoker) for '" + interceptorClass + "', trying default CTOR: " + t.getMessage());
/*     */ 
/* 749 */           interceptor = (Interceptor)interceptorClass.newInstance();
/*     */         }
/* 751 */         interceptors.add(interceptor);
/*     */ 
/* 754 */         String[] names = desc.getFieldNames();
/* 755 */         HashMap propertyMap = new HashMap();
/* 756 */         if (names.length <= 1)
/*     */           continue;
/* 758 */         BeanInfo beanInfo = Introspector.getBeanInfo(interceptorClass);
/* 759 */         PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
/* 760 */         for (int p = 0; p < props.length; p++)
/*     */         {
/* 762 */           String fieldName = props[p].getName();
/* 763 */           propertyMap.put(fieldName, props[p]);
/*     */         }
/*     */ 
/* 766 */         for (int n = 0; n < names.length; n++)
/*     */         {
/* 768 */           String name = names[n];
/* 769 */           if (name.equals("code"))
/*     */             continue;
/* 771 */           String text = (String)desc.getFieldValue(name);
/* 772 */           PropertyDescriptor pd = (PropertyDescriptor)propertyMap.get(name);
/* 773 */           if (pd == null)
/* 774 */             throw new IntrospectionException("No PropertyDescriptor for attribute:" + name);
/* 775 */           Method setter = pd.getWriteMethod();
/* 776 */           if (setter == null)
/*     */             continue;
/* 778 */           Class ptype = pd.getPropertyType();
/* 779 */           PropertyEditor editor = PropertyEditorManager.findEditor(ptype);
/* 780 */           if (editor == null)
/* 781 */             throw new IntrospectionException("Cannot convert string to interceptor attribute:" + name);
/* 782 */           editor.setAsText(text);
/* 783 */           Object[] args = { editor.getValue() };
/* 784 */           setter.invoke(interceptor, args);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 790 */     if (interceptors.size() == 0)
/* 791 */       interceptors = null;
/* 792 */     return interceptors;
/*     */   }
/*     */ 
/*     */   protected void setValuesFromMBeanInfo() throws JMException
/*     */   {
/* 797 */     for (Iterator it = this.attributeContextMap.entrySet().iterator(); it.hasNext(); )
/*     */     {
/* 799 */       Map.Entry entry = (Map.Entry)it.next();
/* 800 */       String key = (String)entry.getKey();
/*     */ 
/* 802 */       InvocationContext ctx = (InvocationContext)entry.getValue();
/*     */ 
/* 804 */       Object value = ctx.getDescriptor().getFieldValue("value");
/* 805 */       if (value != null)
/*     */       {
/* 807 */         setAttribute(new Attribute(key, value));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean isSupportedResourceType(Object resource, String resourceType)
/*     */   {
/* 816 */     return resourceType.equalsIgnoreCase("ObjectReference");
/*     */   }
/*     */ 
/*     */   protected void override(Invocation invocation)
/*     */     throws MBeanException
/*     */   {
/* 824 */     if ((this.dynamicResource) && (this.info != null))
/*     */     {
/* 826 */       Descriptor current = invocation.getDescriptor();
/* 827 */       if (current != null)
/*     */       {
/* 829 */         ModelMBeanInfo mminfo = (ModelMBeanInfo)this.info;
/* 830 */         Descriptor descriptor = mminfo.getDescriptor((String)current.getFieldValue("name"), (String)current.getFieldValue("descriptorType"));
/* 831 */         if (descriptor != null)
/* 832 */           invocation.setDescriptor(descriptor);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.modelmbean.ModelMBeanInvoker
 * JD-Core Version:    0.6.0
 */