/*     */ package org.jboss.mx.mxbean;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Type;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.JMException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanRegistration;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.NotCompliantMBeanException;
/*     */ import javax.management.NotificationBroadcasterSupport;
/*     */ import javax.management.NotificationEmitter;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.management.openmbean.OpenMBeanAttributeInfo;
/*     */ import javax.management.openmbean.OpenMBeanInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.server.ExceptionHandler;
/*     */ 
/*     */ public class MXBeanDelegate extends NotificationBroadcasterSupport
/*     */   implements DynamicMBean, MBeanRegistration, NotificationEmitter
/*     */ {
/*  61 */   private static final Logger log = Logger.getLogger(MXBeanDelegate.class);
/*     */   private Object implementation;
/*     */   private Class mbeanInterface;
/*     */   private OpenMBeanInfo cachedMBeanInfo;
/*     */   private Map<String, OpenMBeanAttributeInfo> attributeMapping;
/*     */   private Map<String, Method> getters;
/*     */   private Map<String, Method> setters;
/*     */   private Map<String, Method> operations;
/*     */ 
/*     */   public MXBeanDelegate(Object implementation, Class mbeanInterface)
/*     */     throws NotCompliantMBeanException
/*     */   {
/*  97 */     this.implementation = implementation;
/*  98 */     this.mbeanInterface = mbeanInterface;
/*     */   }
/*     */ 
/*     */   protected MXBeanDelegate(Class mbeanInterface)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 114 */     this.implementation = this;
/* 115 */     this.mbeanInterface = mbeanInterface;
/*     */   }
/*     */ 
/*     */   public Object getImplementation()
/*     */   {
/* 125 */     return this.implementation;
/*     */   }
/*     */ 
/*     */   public void setImplementation(Object implementation)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 140 */     if (implementation == null)
/* 141 */       throw new IllegalArgumentException("Null implementation");
/* 142 */     this.implementation = implementation;
/*     */   }
/*     */ 
/*     */   public Class getImplementationClass()
/*     */   {
/* 152 */     return this.implementation.getClass();
/*     */   }
/*     */ 
/*     */   public final Class getMBeanInterface()
/*     */   {
/* 162 */     return this.mbeanInterface;
/*     */   }
/*     */ 
/*     */   public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/*     */     try
/*     */     {
/* 169 */       OpenMBeanAttributeInfo attributeInfo = (OpenMBeanAttributeInfo)this.attributeMapping.get(attribute);
/* 170 */       if (attributeInfo == null)
/* 171 */         throw new AttributeNotFoundException(attribute);
/* 172 */       MBeanAttributeInfo mbeanAttributeInfo = (MBeanAttributeInfo)attributeInfo;
/* 173 */       if (!mbeanAttributeInfo.isReadable()) {
/* 174 */         throw new AttributeNotFoundException("Attribute is not readable: " + attribute);
/*     */       }
/* 176 */       Method method = (Method)this.getters.get(attribute);
/* 177 */       if (method == null) {
/* 178 */         throw new NoSuchMethodException("No method to get attribute: " + attribute);
/*     */       }
/* 180 */       Object result = method.invoke(this.implementation, new Object[0]);
/*     */ 
/* 182 */       return MXBeanUtils.construct(attributeInfo.getOpenType(), result, "Get attribute: " + attribute);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 186 */       JMException result = ExceptionHandler.handleException(e);
/* 187 */       if ((result instanceof AttributeNotFoundException))
/* 188 */         throw ((AttributeNotFoundException)result);
/* 189 */       if ((result instanceof MBeanException))
/* 190 */         throw ((MBeanException)result);
/* 191 */       if ((result instanceof ReflectionException))
/* 192 */         throw ((ReflectionException)result); 
/*     */     }
/* 193 */     throw new MBeanException(e, "Cannot get attribute: " + attribute);
/*     */   }
/*     */ 
/*     */   public void setAttribute(Attribute attribute)
/*     */     throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */   {
/*     */     try
/*     */     {
/* 201 */       String attributeName = attribute.getName();
/* 202 */       OpenMBeanAttributeInfo attributeInfo = (OpenMBeanAttributeInfo)this.attributeMapping.get(attributeName);
/* 203 */       if (attributeInfo == null)
/* 204 */         throw new AttributeNotFoundException(attributeName);
/* 205 */       MBeanAttributeInfo mbeanAttributeInfo = (MBeanAttributeInfo)attributeInfo;
/* 206 */       if (!mbeanAttributeInfo.isWritable()) {
/* 207 */         throw new AttributeNotFoundException("Attribute is not writable: " + attributeName);
/*     */       }
/* 209 */       Method method = (Method)this.setters.get(attributeName);
/* 210 */       if (method == null) {
/* 211 */         throw new NoSuchMethodException("No method to set attribute: " + attribute);
/*     */       }
/* 213 */       Object value = MXBeanUtils.reconstruct(method.getGenericParameterTypes()[0], attribute.getValue(), method);
/*     */ 
/* 215 */       method.invoke(this.implementation, new Object[] { value });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 219 */       JMException result = ExceptionHandler.handleException(e);
/* 220 */       if ((result instanceof AttributeNotFoundException))
/* 221 */         throw ((AttributeNotFoundException)result);
/* 222 */       if ((result instanceof InvalidAttributeValueException))
/* 223 */         throw ((InvalidAttributeValueException)result);
/* 224 */       if ((result instanceof MBeanException))
/* 225 */         throw ((MBeanException)result);
/* 226 */       if ((result instanceof ReflectionException))
/* 227 */         throw ((ReflectionException)result);
/* 228 */       throw new MBeanException(e, "Cannot set attribute: " + attribute);
/*     */     }
/*     */   }
/*     */ 
/*     */   public AttributeList getAttributes(String[] attributes) {
/*     */     JMException result;
/*     */     try {
/* 236 */       AttributeList attrList = new AttributeList(attributes.length);
/* 237 */       for (int i = 0; i < attributes.length; i++)
/*     */       {
/* 239 */         String name = attributes[i];
/* 240 */         Object value = getAttribute(name);
/* 241 */         attrList.add(new Attribute(name, value));
/*     */       }
/* 243 */       return attrList;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 247 */       result = ExceptionHandler.handleException(e);
/*     */     }
/* 249 */     throw new RuntimeException("Cannot get attributes", result);
/*     */   }
/*     */ 
/*     */   public AttributeList setAttributes(AttributeList attributes)
/*     */   {
/* 255 */     AttributeList result = new AttributeList(attributes.size());
/* 256 */     for (int i = 0; i < attributes.size(); i++)
/*     */     {
/* 258 */       Attribute attr = (Attribute)attributes.get(i);
/* 259 */       String name = attr.getName();
/*     */       try
/*     */       {
/* 262 */         setAttribute(attr);
/* 263 */         result.add(new Attribute(name, attr.getValue()));
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 267 */         JMException e = ExceptionHandler.handleException(t);
/* 268 */         result.add(new Attribute(name, e));
/*     */       }
/*     */     }
/* 271 */     return result;
/*     */   }
/*     */ 
/*     */   public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException
/*     */   {
/*     */     try
/*     */     {
/* 278 */       String signatureString = getSignatureString(actionName, signature);
/* 279 */       Method method = (Method)this.operations.get(signatureString);
/* 280 */       if (method == null) {
/* 281 */         throw new NoSuchMethodException("Cannot find method for operation: " + signatureString);
/*     */       }
/* 283 */       Object[] parameters = params;
/* 284 */       if (params.length > 0)
/*     */       {
/* 286 */         parameters = new Object[params.length];
/* 287 */         Type[] parameterTypes = method.getGenericParameterTypes();
/* 288 */         for (int i = 0; i < parameters.length; i++) {
/* 289 */           parameters[i] = MXBeanUtils.reconstruct(parameterTypes[i], params[i], method);
/*     */         }
/*     */       }
/* 292 */       Object result = method.invoke(this.implementation, parameters);
/*     */ 
/* 294 */       if (result == null)
/* 295 */         return null;
/* 296 */       Type returnType = method.getGenericReturnType();
/* 297 */       return MXBeanUtils.construct(returnType, result, method);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 301 */       JMException result = ExceptionHandler.handleException(e);
/* 302 */       if ((result instanceof MBeanException))
/* 303 */         throw ((MBeanException)result);
/* 304 */       if ((result instanceof ReflectionException))
/* 305 */         throw ((ReflectionException)result); 
/*     */     }
/* 306 */     throw new MBeanException(e, "Cannot invoke: " + actionName);
/*     */   }
/*     */ 
/*     */   public ObjectName preRegister(MBeanServer server, ObjectName name)
/*     */     throws Exception
/*     */   {
/* 312 */     return name;
/*     */   }
/*     */ 
/*     */   public void postRegister(Boolean registrationDone)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void preDeregister() throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void postDeregister()
/*     */   {
/*     */   }
/*     */ 
/*     */   public MBeanInfo getMBeanInfo()
/*     */   {
/* 329 */     OpenMBeanInfo info = getCachedMBeanInfo();
/* 330 */     if (info == null)
/*     */     {
/*     */       try
/*     */       {
/* 334 */         info = buildMBeanInfo();
/* 335 */         cacheMBeanInfo(info);
/*     */       }
/*     */       catch (NotCompliantMBeanException e)
/*     */       {
/* 339 */         log.error("Unexcepted exception", e);
/* 340 */         throw new IllegalStateException("Unexcepted exception " + e.toString());
/*     */       }
/*     */     }
/*     */ 
/* 344 */     return (MBeanInfo)info;
/*     */   }
/*     */ 
/*     */   public OpenMBeanInfo getCachedMBeanInfo()
/*     */   {
/* 354 */     return this.cachedMBeanInfo;
/*     */   }
/*     */ 
/*     */   public void cacheMBeanInfo(OpenMBeanInfo info)
/*     */   {
/* 364 */     this.cachedMBeanInfo = info;
/* 365 */     Map attributeMapping = new HashMap();
/* 366 */     MBeanAttributeInfo[] attributes = info.getAttributes();
/* 367 */     for (int i = 0; i < attributes.length; i++)
/*     */     {
/* 369 */       OpenMBeanAttributeInfo attribute = (OpenMBeanAttributeInfo)attributes[i];
/* 370 */       attributeMapping.put(attribute.getName(), attribute);
/*     */     }
/* 372 */     this.attributeMapping = attributeMapping;
/*     */     try
/*     */     {
/* 376 */       HashMap getters = new HashMap();
/* 377 */       HashMap setters = new HashMap();
/*     */ 
/* 379 */       HashMap operations = new HashMap();
/*     */ 
/* 381 */       Method[] methods = this.implementation.getClass().getMethods();
/* 382 */       for (Method method : methods)
/*     */       {
/* 384 */         String methodName = method.getName();
/* 385 */         Type[] signature = method.getGenericParameterTypes();
/* 386 */         Type returnType = method.getGenericReturnType();
/*     */ 
/* 388 */         if ((methodName.startsWith("set")) && (methodName.length() > 3) && (signature.length == 1) && (returnType == Void.TYPE))
/*     */         {
/* 393 */           String key = methodName.substring(3, methodName.length());
/* 394 */           Method setter = (Method)setters.get(key);
/* 395 */           if ((setter != null) && (!setter.getGenericParameterTypes()[0].equals(signature[0])))
/* 396 */             throw new RuntimeException("overloaded type for attribute set: " + key);
/* 397 */           setters.put(key, method);
/*     */         }
/* 399 */         else if ((methodName.startsWith("get")) && (methodName.length() > 3) && (signature.length == 0) && (returnType != Void.TYPE))
/*     */         {
/* 404 */           String key = methodName.substring(3, methodName.length());
/* 405 */           Method getter = (Method)getters.get(key);
/* 406 */           if ((getter != null) && (getter.getName().startsWith("is")))
/* 407 */             throw new RuntimeException("mixed use of get/is for attribute " + key);
/* 408 */           getters.put(key, method);
/*     */         }
/* 410 */         else if ((methodName.startsWith("is")) && (methodName.length() > 2) && (signature.length == 0) && (returnType == Boolean.TYPE))
/*     */         {
/* 415 */           String key = methodName.substring(2, methodName.length());
/* 416 */           Method getter = (Method)getters.get(key);
/* 417 */           if ((getter != null) && (getter.getName().startsWith("get")))
/* 418 */             throw new RuntimeException("mixed use of get/is for attribute " + key);
/* 419 */           getters.put(key, method);
/*     */         }
/*     */         else
/*     */         {
/* 423 */           operations.put(getSignatureString(method), method);
/*     */         }
/*     */       }
/* 426 */       this.getters = getters;
/* 427 */       this.setters = setters;
/* 428 */       this.operations = operations;
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 432 */       log.error("Error: ", e);
/* 433 */       throw e;
/*     */     }
/*     */     catch (Error e)
/*     */     {
/* 437 */       log.error("Error: ", e);
/* 438 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   public OpenMBeanInfo buildMBeanInfo()
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 453 */     if (this.implementation == null) {
/* 454 */       throw new IllegalArgumentException("Null implementation");
/*     */     }
/* 456 */     MXBeanMetaData metadata = new MXBeanMetaData(this.implementation, this.mbeanInterface);
/* 457 */     return (OpenMBeanInfo)metadata.build();
/*     */   }
/*     */ 
/*     */   private String getSignatureString(Method method)
/*     */   {
/* 468 */     String name = method.getName();
/* 469 */     Class[] signature = method.getParameterTypes();
/* 470 */     StringBuilder buffer = new StringBuilder(512);
/* 471 */     buffer.append(name);
/* 472 */     buffer.append("(");
/* 473 */     if (signature != null)
/*     */     {
/* 475 */       for (int i = 0; i < signature.length; i++)
/*     */       {
/* 477 */         buffer.append(signature[i].getName());
/* 478 */         if (i < signature.length - 1)
/* 479 */           buffer.append(",");
/*     */       }
/*     */     }
/* 482 */     buffer.append(")");
/* 483 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   private String getSignatureString(String operation, String[] signature)
/*     */   {
/* 495 */     StringBuilder buffer = new StringBuilder(512);
/* 496 */     buffer.append(operation);
/* 497 */     buffer.append("(");
/* 498 */     if (signature != null)
/*     */     {
/* 500 */       for (int i = 0; i < signature.length; i++)
/*     */       {
/* 502 */         buffer.append(signature[i]);
/* 503 */         if (i < signature.length - 1)
/* 504 */           buffer.append(",");
/*     */       }
/*     */     }
/* 507 */     buffer.append(")");
/* 508 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.mxbean.MXBeanDelegate
 * JD-Core Version:    0.6.0
 */