/*     */ package org.jboss.mx.mxbean;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Type;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.management.IntrospectionException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.NotCompliantMBeanException;
/*     */ import javax.management.NotificationBroadcaster;
/*     */ import javax.management.openmbean.OpenMBeanAttributeInfo;
/*     */ import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
/*     */ import javax.management.openmbean.OpenMBeanConstructorInfo;
/*     */ import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
/*     */ import javax.management.openmbean.OpenMBeanInfoSupport;
/*     */ import javax.management.openmbean.OpenMBeanOperationInfo;
/*     */ import javax.management.openmbean.OpenMBeanOperationInfoSupport;
/*     */ import javax.management.openmbean.OpenMBeanParameterInfo;
/*     */ import javax.management.openmbean.OpenMBeanParameterInfoSupport;
/*     */ import javax.management.openmbean.OpenType;
/*     */ import org.jboss.mx.metadata.AbstractBuilder;
/*     */ 
/*     */ public class MXBeanMetaData extends AbstractBuilder
/*     */ {
/*     */   private Object mbeanInstance;
/*     */   private Class<?> mbeanClass;
/*     */   private Class<?> mbeanInterface;
/*     */ 
/*     */   public static Class<?> findMXBeanInterface(Class<?> mbeanClass)
/*     */   {
/*  78 */     Class concrete = mbeanClass;
/*  79 */     while (null != concrete)
/*     */     {
/*  81 */       Class result = findMXBeanInterface(concrete, concrete.getInterfaces());
/*  82 */       if (null != result)
/*  83 */         return result;
/*  84 */       concrete = concrete.getSuperclass();
/*     */     }
/*  86 */     return null;
/*     */   }
/*     */ 
/*     */   private static Class<?> findMXBeanInterface(Class<?> concrete, Class<?>[] interfaces)
/*     */   {
/*  98 */     String mxName = concrete.getName() + "MXBean";
/*  99 */     String stdName = concrete.getName() + "MBean";
/*     */ 
/* 101 */     for (Class intf : interfaces)
/*     */     {
/* 103 */       String name = intf.getName();
/* 104 */       if ((mxName.equals(name)) || (stdName.equals(name))) {
/* 105 */         return intf;
/*     */       }
/* 107 */       MXBean mxBean = (MXBean)intf.getAnnotation(MXBean.class);
/* 108 */       if ((mxBean != null) && (mxBean.value()))
/* 109 */         return intf;
/*     */     }
/* 111 */     return null;
/*     */   }
/*     */ 
/*     */   public MXBeanMetaData(Object mbeanInstance)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 122 */     this(mbeanInstance.getClass());
/* 123 */     this.mbeanInstance = mbeanInstance;
/*     */   }
/*     */ 
/*     */   public MXBeanMetaData(Class<?> mbeanClass)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 134 */     this.mbeanClass = mbeanClass;
/* 135 */     this.mbeanInterface = findMXBeanInterface(mbeanClass);
/* 136 */     if (this.mbeanInterface == null)
/* 137 */       throw new NotCompliantMBeanException("Cannot obtain MXBean interface for: " + mbeanClass);
/*     */   }
/*     */ 
/*     */   public MXBeanMetaData(Object mbeanInstance, Class<?> mbeanInterface)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 149 */     this.mbeanInstance = mbeanInstance;
/* 150 */     this.mbeanClass = mbeanInstance.getClass();
/* 151 */     this.mbeanInterface = mbeanInterface;
/* 152 */     if (this.mbeanInterface == null)
/* 153 */       this.mbeanInterface = findMXBeanInterface(this.mbeanClass);
/* 154 */     if (this.mbeanInterface == null)
/* 155 */       throw new NotCompliantMBeanException("Cannot obtain mxbean interface for: " + this.mbeanClass);
/* 156 */     if (!this.mbeanInterface.isInterface())
/* 157 */       throw new NotCompliantMBeanException("Management interface is not an interface: " + mbeanInterface);
/*     */   }
/*     */ 
/*     */   public Class<?> getMBeanInterface()
/*     */   {
/* 167 */     return this.mbeanInterface;
/*     */   }
/*     */ 
/*     */   public MBeanInfo build() throws NotCompliantMBeanException
/*     */   {
/*     */     NotCompliantMBeanException e;
/*     */     try {
/* 175 */       if (this.mbeanInterface == null)
/* 176 */         throw new NotCompliantMBeanException("The mbean does not implement a management interface");
/* 177 */       if ((this.mbeanInstance != null) && (!this.mbeanInterface.isInstance(this.mbeanInstance))) {
/* 178 */         throw new NotCompliantMBeanException("The mbean does not implement its management interface " + this.mbeanInterface.getName());
/*     */       }
/* 180 */       OpenMBeanConstructorInfo[] constructorInfo = buildConstructors();
/*     */ 
/* 182 */       HashMap getters = new HashMap();
/* 183 */       HashMap setters = new HashMap();
/*     */ 
/* 185 */       HashMap operInfo = new HashMap();
/* 186 */       List attrInfo = new ArrayList();
/*     */ 
/* 188 */       Method[] methods = this.mbeanInterface.getMethods();
/* 189 */       for (Method method : methods)
/*     */       {
/* 191 */         String methodName = method.getName();
/* 192 */         Type[] signature = method.getGenericParameterTypes();
/* 193 */         Type returnType = method.getGenericReturnType();
/*     */ 
/* 195 */         if ((methodName.startsWith("set")) && (methodName.length() > 3) && (signature.length == 1) && (returnType == Void.TYPE))
/*     */         {
/* 200 */           String key = methodName.substring(3, methodName.length());
/* 201 */           Method setter = (Method)setters.get(key);
/* 202 */           if ((setter != null) && (!setter.getGenericParameterTypes()[0].equals(signature[0])))
/* 203 */             throw new IntrospectionException("overloaded type for attribute set: " + key);
/* 204 */           setters.put(key, method);
/*     */         }
/* 206 */         else if ((methodName.startsWith("get")) && (methodName.length() > 3) && (signature.length == 0) && (returnType != Void.TYPE))
/*     */         {
/* 211 */           String key = methodName.substring(3, methodName.length());
/* 212 */           Method getter = (Method)getters.get(key);
/* 213 */           if ((getter != null) && (getter.getName().startsWith("is")))
/* 214 */             throw new IntrospectionException("mixed use of get/is for attribute " + key);
/* 215 */           getters.put(key, method);
/*     */         }
/* 217 */         else if ((methodName.startsWith("is")) && (methodName.length() > 2) && (signature.length == 0) && (isBooleanReturn(returnType)))
/*     */         {
/* 222 */           String key = methodName.substring(2, methodName.length());
/* 223 */           Method getter = (Method)getters.get(key);
/* 224 */           if ((getter != null) && (getter.getName().startsWith("get")))
/* 225 */             throw new IntrospectionException("mixed use of get/is for attribute " + key);
/* 226 */           getters.put(key, method);
/*     */         }
/*     */         else
/*     */         {
/* 230 */           OpenMBeanOperationInfo info = buildOperation(method);
/* 231 */           operInfo.put(getSignatureString(method), info);
/*     */         }
/*     */       }
/*     */ 
/* 235 */       String[] keys = (String[])getters.keySet().toArray(new String[getters.size()]);
/* 236 */       for (String key : keys)
/*     */       {
/* 238 */         Method getter = (Method)getters.remove(key);
/* 239 */         Method setter = (Method)setters.remove(key);
/* 240 */         OpenMBeanAttributeInfo info = buildAttribute(key, getter, setter);
/* 241 */         attrInfo.add(info);
/*     */       }
/*     */ 
/* 244 */       for (String key : setters.keySet())
/*     */       {
/* 246 */         Method setter = (Method)setters.remove(key);
/* 247 */         OpenMBeanAttributeInfo info = buildAttribute(key, null, setter);
/* 248 */         attrInfo.add(info);
/*     */       }
/*     */ 
/* 251 */       OpenMBeanAttributeInfo[] attributeInfo = (OpenMBeanAttributeInfo[])attrInfo.toArray(new OpenMBeanAttributeInfo[attrInfo.size()]);
/* 252 */       Collection operations = operInfo.values();
/* 253 */       OpenMBeanOperationInfo[] operationInfo = (OpenMBeanOperationInfo[])operations.toArray(new OpenMBeanOperationInfo[operations.size()]);
/*     */ 
/* 255 */       MBeanNotificationInfo[] notifications = null;
/* 256 */       if ((this.mbeanInstance instanceof NotificationBroadcaster))
/* 257 */         notifications = ((NotificationBroadcaster)this.mbeanInstance).getNotificationInfo();
/*     */       else {
/* 259 */         notifications = new MBeanNotificationInfo[0];
/*     */       }
/* 261 */       return buildMBeanInfo(attributeInfo, constructorInfo, operationInfo, notifications);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 266 */       e = new NotCompliantMBeanException("Error generating OpenMBeanInfo.");
/* 267 */       e.initCause(t);
/* 268 */     }throw e;
/*     */   }
/*     */ 
/*     */   private OpenMBeanConstructorInfo[] buildConstructors()
/*     */     throws Exception
/*     */   {
/* 280 */     Constructor[] constructors = this.mbeanClass.getConstructors();
/* 281 */     OpenMBeanConstructorInfo[] constructorInfo = new OpenMBeanConstructorInfo[constructors.length];
/* 282 */     for (int i = 0; i < constructors.length; i++)
/* 283 */       constructorInfo[i] = buildConstructor(constructors[i]);
/* 284 */     return constructorInfo;
/*     */   }
/*     */ 
/*     */   private OpenMBeanConstructorInfo buildConstructor(Constructor<?> constructor)
/*     */     throws Exception
/*     */   {
/* 296 */     Type[] parameterTypes = constructor.getGenericParameterTypes();
/* 297 */     OpenMBeanParameterInfo[] parameterInfo = new OpenMBeanParameterInfo[parameterTypes.length];
/* 298 */     for (int i = 0; i < parameterTypes.length; i++)
/* 299 */       parameterInfo[i] = buildParameter(i, parameterTypes[i]);
/* 300 */     return new OpenMBeanConstructorInfoSupport("MBean Constructor.", "MBean Constructor.", parameterInfo);
/*     */   }
/*     */ 
/*     */   private OpenMBeanParameterInfo buildParameter(int i, Type parameterType)
/*     */     throws Exception
/*     */   {
/* 313 */     OpenType openType = MXBeanUtils.getOpenType(parameterType);
/* 314 */     return new OpenMBeanParameterInfoSupport("arg" + i, "MBean Parameter.", openType);
/*     */   }
/*     */ 
/*     */   private OpenMBeanAttributeInfo buildAttribute(String attrName, Method getter, Method setter)
/*     */     throws Exception
/*     */   {
/* 328 */     boolean isReadable = getter != null;
/* 329 */     boolean isWritable = setter != null;
/* 330 */     boolean isIs = false;
/*     */ 
/* 332 */     OpenType openType = null;
/* 333 */     if (getter != null)
/*     */     {
/* 335 */       openType = MXBeanUtils.getOpenType(getter.getGenericReturnType());
/* 336 */       if (getter.getName().startsWith("is"))
/* 337 */         isIs = true;
/*     */     }
/*     */     else
/*     */     {
/* 341 */       openType = MXBeanUtils.getOpenType(setter.getGenericParameterTypes()[0]);
/*     */     }
/*     */ 
/* 344 */     return new OpenMBeanAttributeInfoSupport(attrName, attrName, openType, isReadable, isWritable, isIs);
/*     */   }
/*     */ 
/*     */   private OpenMBeanOperationInfo buildOperation(Method method)
/*     */     throws Exception
/*     */   {
/* 356 */     Type[] parameterTypes = method.getGenericParameterTypes();
/* 357 */     OpenMBeanParameterInfo[] parameterInfo = new OpenMBeanParameterInfo[parameterTypes.length];
/* 358 */     for (int i = 0; i < parameterTypes.length; i++)
/* 359 */       parameterInfo[i] = buildParameter(i, parameterTypes[i]);
/* 360 */     OpenType openType = MXBeanUtils.getOpenType(method.getGenericReturnType());
/* 361 */     return new OpenMBeanOperationInfoSupport(method.getName(), method.getName(), parameterInfo, openType, 1);
/*     */   }
/*     */ 
/*     */   private OpenMBeanInfoSupport buildMBeanInfo(OpenMBeanAttributeInfo[] attributes, OpenMBeanConstructorInfo[] constructors, OpenMBeanOperationInfo[] operations, MBeanNotificationInfo[] notifications)
/*     */     throws Exception
/*     */   {
/* 376 */     return new OpenMBeanInfoSupport(this.mbeanClass.getName(), this.mbeanClass.getName(), attributes, constructors, operations, notifications);
/*     */   }
/*     */ 
/*     */   private boolean isBooleanReturn(Type returnType)
/*     */   {
/* 388 */     return returnType == Boolean.TYPE;
/*     */   }
/*     */ 
/*     */   private String getSignatureString(Method method)
/*     */   {
/* 399 */     String name = method.getName();
/* 400 */     Class[] signature = method.getParameterTypes();
/* 401 */     StringBuffer buffer = new StringBuffer(512);
/* 402 */     buffer.append(name);
/* 403 */     buffer.append("(");
/* 404 */     if (signature != null)
/*     */     {
/* 406 */       for (int i = 0; i < signature.length; i++)
/*     */       {
/* 408 */         buffer.append(signature[i].getName());
/* 409 */         if (i < signature.length - 1)
/* 410 */           buffer.append(",");
/*     */       }
/*     */     }
/* 413 */     buffer.append(")");
/* 414 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.mxbean.MXBeanMetaData
 * JD-Core Version:    0.6.0
 */