/*     */ package org.jboss.mx.persistence;
/*     */ 
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.management.modelmbean.ModelMBeanAttributeInfo;
/*     */ import javax.management.modelmbean.ModelMBeanInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.modelmbean.ModelMBeanInvoker;
/*     */ 
/*     */ public class DelegatingPersistenceManager
/*     */   implements PersistenceManager
/*     */ {
/*  57 */   private static Logger log = Logger.getLogger(DelegatingPersistenceManager.class);
/*     */   private AttributePersistenceManager persistor;
/*     */   private String persistName;
/*     */   private boolean isLoading;
/*     */ 
/*     */   public void load(ModelMBeanInvoker invoker, MBeanInfo metadata)
/*     */     throws MBeanException
/*     */   {
/*  85 */     if (this.persistor == null)
/*     */     {
/*  88 */       init(invoker, metadata);
/*     */     }
/*     */ 
/*  91 */     if (log.isDebugEnabled()) {
/*  92 */       log.debug("load() called for: '" + this.persistName + "'");
/*     */     }
/*  94 */     AttributeList attrs = null;
/*     */     try
/*     */     {
/*  98 */       attrs = this.persistor.load(this.persistName);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 102 */       log.warn("Caught exception while loading", e);
/* 103 */       throw new MBeanException(e);
/*     */     }
/*     */ 
/* 106 */     if (attrs != null)
/*     */     {
/*     */       try
/*     */       {
/* 112 */         setIsLoading(true);
/*     */ 
/* 114 */         if (log.isDebugEnabled())
/* 115 */           log.debug("loading attributes: " + attrs);
/* 116 */         invoker.setAttributes(attrs);
/*     */       }
/*     */       finally {
/* 119 */         setIsLoading(false);
/*     */       }
/*     */ 
/*     */     }
/* 123 */     else if (log.isDebugEnabled())
/* 124 */       log.debug("No attributes to load");
/*     */   }
/*     */ 
/*     */   public void store(MBeanInfo metadata)
/*     */     throws MBeanException
/*     */   {
/* 142 */     if (this.persistor == null)
/*     */     {
/* 144 */       throw new MBeanException(new Exception("store() called before instance initialized"));
/*     */     }
/*     */ 
/* 148 */     if (isLoading()) {
/* 149 */       return;
/*     */     }
/*     */ 
/* 152 */     if (log.isDebugEnabled()) {
/* 153 */       log.debug("store() called for: '" + this.persistName + "'");
/*     */     }
/*     */ 
/* 156 */     AttributeList attributes = new AttributeList();
/*     */ 
/* 159 */     MBeanAttributeInfo[] attrs = metadata.getAttributes();
/*     */ 
/* 161 */     if ((log.isDebugEnabled()) && (attrs.length > 0)) {
/* 162 */       log.debug("store() --- ModelMBeanAttributeInfo[] ---");
/*     */     }
/* 164 */     for (int i = 0; i < attrs.length; i++)
/*     */     {
/* 168 */       ModelMBeanAttributeInfo attributeInfo = (ModelMBeanAttributeInfo)attrs[i];
/*     */ 
/* 170 */       if (log.isDebugEnabled()) {
/* 171 */         log.debug("  attr (#" + i + ") - " + attributeInfo);
/*     */       }
/* 173 */       if (attributeInfo.isWritable()) {
/* 174 */         Descriptor attrDesc = attributeInfo.getDescriptor();
/*     */ 
/* 176 */         Object name = attrDesc.getFieldValue("name");
/* 177 */         Object value = attrDesc.getFieldValue("attributeValue");
/* 178 */         Object updated = attrDesc.getFieldValue("lastUpdatedTimeStamp2");
/* 179 */         Object pPolicy = attrDesc.getFieldValue("persistPolicy");
/*     */ 
/* 181 */         boolean noPersistPolicy = (pPolicy != null) && (((String)pPolicy).equalsIgnoreCase("Never"));
/*     */ 
/* 190 */         if ((updated != null) && (!noPersistPolicy))
/* 191 */           attributes.add(new Attribute(name.toString(), value));
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/* 196 */       if (!attributes.isEmpty())
/*     */       {
/* 198 */         if (log.isDebugEnabled()) {
/* 199 */           log.debug("calling persistor.store(" + this.persistName + ") attrs=" + attributes);
/*     */         }
/* 201 */         this.persistor.store(this.persistName, attributes);
/*     */       }
/* 204 */       else if (log.isDebugEnabled()) {
/* 205 */         log.debug("nothing to persist");
/*     */       }
/*     */     }
/*     */     catch (Exception e) {
/* 209 */       log.warn("cought exception during store()", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void init(ModelMBeanInvoker invoker, MBeanInfo metadata)
/*     */     throws MBeanException
/*     */   {
/* 225 */     Descriptor desc = ((ModelMBeanInfo)metadata).getMBeanDescriptor();
/*     */ 
/* 227 */     if (log.isDebugEnabled()) {
/* 228 */       log.debug("init() --- ModelMBeanInfo Descriptor --- ");
/* 229 */       log.debug(desc);
/*     */     }
/*     */ 
/* 235 */     String name = (String)desc.getFieldValue("persistName");
/*     */ 
/* 237 */     if (name != null) {
/* 238 */       this.persistName = name;
/*     */     }
/*     */     else
/*     */     {
/* 242 */       ObjectName objectName = (ObjectName)desc.getFieldValue("objectname");
/*     */ 
/* 244 */       if (objectName != null) {
/* 245 */         this.persistName = objectName.toString();
/*     */       }
/*     */       else {
/* 248 */         throw new MBeanException(new Exception("must specify a value for: persistName"));
/*     */       }
/*     */     }
/*     */ 
/* 252 */     if (log.isDebugEnabled()) {
/* 253 */       log.debug("chosen persistent id: '" + this.persistName + "'");
/*     */     }
/*     */ 
/* 257 */     String service = (String)desc.getFieldValue("attribute-persistence-service");
/* 258 */     if (service == null)
/*     */     {
/* 261 */       service = "jboss:service=AttributePersistenceService";
/*     */     }
/*     */ 
/* 265 */     String operation = (String)desc.getFieldValue("attribute-persistence-operation");
/* 266 */     if (operation == null)
/*     */     {
/* 269 */       operation = "apmCreate";
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 274 */       ObjectName objName = new ObjectName(service);
/* 275 */       MBeanServer server = invoker.getServer();
/*     */ 
/* 277 */       this.persistor = ((AttributePersistenceManager)server.invoke(objName, operation, new Object[0], new String[0]));
/*     */ 
/* 281 */       if (this.persistor == null)
/* 282 */         throw new MBeanException(new NullPointerException("null AttributePersistenceManager from: " + service));
/*     */     }
/*     */     catch (MalformedObjectNameException e)
/*     */     {
/* 286 */       throw new MBeanException(e, "not a valid ObjectName: " + service);
/*     */     }
/*     */     catch (InstanceNotFoundException e) {
/* 289 */       throw new MBeanException(e, "service not registered: " + service);
/*     */     }
/*     */     catch (ReflectionException e) {
/* 292 */       throw new MBeanException(e);
/*     */     }
/*     */ 
/* 295 */     if (log.isDebugEnabled())
/* 296 */       log.debug("using AttributePersistenceManager: " + this.persistor.getClass().getName());
/*     */   }
/*     */ 
/*     */   protected boolean isLoading()
/*     */   {
/* 304 */     return this.isLoading;
/*     */   }
/*     */ 
/*     */   protected void setIsLoading(boolean newIsLoading)
/*     */   {
/* 314 */     this.isLoading = newIsLoading;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.persistence.DelegatingPersistenceManager
 * JD-Core Version:    0.6.0
 */