/*     */ package org.jboss.mx.persistence;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.modelmbean.ModelMBeanAttributeInfo;
/*     */ import javax.management.modelmbean.ModelMBeanInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.modelmbean.ModelMBeanInvoker;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ 
/*     */ public class ObjectStreamPersistenceManager
/*     */   implements PersistenceManager
/*     */ {
/*  66 */   protected static Logger log = Logger.getLogger(ObjectStreamPersistenceManager.class);
/*     */   protected boolean isLoading;
/*     */ 
/*     */   public void load(ModelMBeanInvoker mbean, MBeanInfo metadata)
/*     */     throws MBeanException
/*     */   {
/*  91 */     log.debug("load, resource:" + mbean.getResource());
/*     */ 
/*  93 */     if (metadata == null)
/*     */     {
/*  95 */       return;
/*     */     }
/*  97 */     if (log.isTraceEnabled()) {
/*  98 */       log.trace("metadata: " + metadata);
/*     */     }
/* 100 */     File storeFile = getStoreFile(metadata, false);
/* 101 */     if (storeFile == null)
/*     */     {
/* 103 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 108 */       FileInputStream fis = new FileInputStream(storeFile);
/* 109 */       ObjectInputStream ois = new ObjectInputStream(fis);
/* 110 */       ModelMBeanInfo storeMetadata = (ModelMBeanInfo)ois.readObject();
/* 111 */       ois.close();
/* 112 */       log.debug("metadata deserialized");
/* 113 */       if (log.isTraceEnabled())
/* 114 */         log.trace("storeMetadata: " + storeMetadata);
/* 115 */       loadFromMetadata(mbean, storeMetadata);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 119 */       log.error("Error loading MBean state", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void store(MBeanInfo metadata)
/*     */     throws MBeanException
/*     */   {
/* 134 */     if (isLoading())
/*     */     {
/* 136 */       return;
/*     */     }
/*     */ 
/* 139 */     log.debug("store");
/* 140 */     if (log.isTraceEnabled())
/* 141 */       log.trace("metadata: " + metadata);
/* 142 */     File storeFile = getStoreFile(metadata, true);
/* 143 */     if (storeFile == null)
/*     */     {
/* 145 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 150 */       log.debug("Storing to file: " + storeFile.getAbsolutePath());
/* 151 */       FileOutputStream fos = new FileOutputStream(storeFile);
/* 152 */       ObjectOutputStream oos = new ObjectOutputStream(fos);
/* 153 */       oos.writeObject(metadata);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 157 */       throw new MBeanException(e, "Error in persisting MBean.");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void loadFromMetadata(ModelMBeanInvoker mbean, ModelMBeanInfo metadata)
/*     */   {
/* 171 */     AttributeList attributes = new AttributeList();
/*     */ 
/* 173 */     MBeanAttributeInfo[] attrs = metadata.getAttributes();
/* 174 */     for (int i = 0; i < attrs.length; i++)
/*     */     {
/* 177 */       ModelMBeanAttributeInfo attributeInfo = (ModelMBeanAttributeInfo)attrs[i];
/* 178 */       Descriptor attrDesc = attributeInfo.getDescriptor();
/* 179 */       Object name = attrDesc.getFieldValue("name");
/* 180 */       Object value = attrDesc.getFieldValue("attributeValue");
/* 181 */       Object updated = attrDesc.getFieldValue("lastUpdatedTimeStamp2");
/*     */ 
/* 185 */       if (updated == null)
/*     */         continue;
/* 187 */       log.debug("loading attribute  name: " + name + ", value: " + value);
/* 188 */       Attribute curAttribute = new Attribute(name.toString(), value);
/* 189 */       attributes.add(curAttribute);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 195 */       setIsLoading(true);
/* 196 */       mbean.setAttributes(attributes);
/*     */     }
/*     */     finally
/*     */     {
/* 200 */       setIsLoading(false);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected boolean isLoading()
/*     */   {
/* 206 */     return this.isLoading;
/*     */   }
/*     */ 
/*     */   protected void setIsLoading(boolean newIsLoading)
/*     */   {
/* 211 */     this.isLoading = newIsLoading;
/*     */   }
/*     */ 
/*     */   protected File getStoreFile(MBeanInfo metadata, boolean createFile) throws MBeanException
/*     */   {
/* 216 */     Descriptor d = ((ModelMBeanInfo)metadata).getMBeanDescriptor();
/* 217 */     String dirPath = (String)d.getFieldValue("persistLocation");
/* 218 */     String file = (String)d.getFieldValue("persistName");
/* 219 */     if (dirPath == null)
/*     */     {
/* 221 */       log.debug("No persistLocation descriptor value found, using '.'");
/*     */ 
/* 223 */       dirPath = ".";
/*     */     }
/* 225 */     if (file == null)
/*     */     {
/* 227 */       log.debug("No persistName descriptor value found");
/* 228 */       return null;
/*     */     }
/*     */ 
/* 231 */     dirPath = StringPropertyReplacer.replaceProperties(dirPath);
/* 232 */     file = StringPropertyReplacer.replaceProperties(file);
/* 233 */     File dir = new File(dirPath);
/* 234 */     File storeFile = new File(dir, file);
/* 235 */     boolean exists = storeFile.exists();
/* 236 */     log.debug("Store file is: " + storeFile.getAbsolutePath());
/* 237 */     if ((!exists) && (createFile == true))
/*     */     {
/* 239 */       dir.mkdirs();
/*     */       try
/*     */       {
/* 242 */         storeFile.createNewFile();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 246 */         throw new MBeanException(e, "Failed to create store file");
/*     */       }
/*     */     }
/* 249 */     else if (!exists)
/*     */     {
/* 251 */       storeFile = null;
/*     */     }
/* 253 */     return storeFile;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.persistence.ObjectStreamPersistenceManager
 * JD-Core Version:    0.6.0
 */