/*     */ package org.jboss.mx.server;
/*     */ 
/*     */ import javax.management.JMException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanRegistrationException;
/*     */ import javax.management.OperationsException;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.management.RuntimeErrorException;
/*     */ import javax.management.RuntimeMBeanException;
/*     */ import javax.management.RuntimeOperationsException;
/*     */ 
/*     */ public class ExceptionHandler
/*     */ {
/*     */   public static JMException handleException(Throwable t)
/*     */   {
/*  49 */     handleRuntimeExceptionOrError(t);
/*     */ 
/*  52 */     Exception e = (Exception)t;
/*     */ 
/*  54 */     if ((e instanceof OperationsException))
/*  55 */       return (OperationsException)e;
/*  56 */     if ((e instanceof ReflectionException))
/*  57 */       return (ReflectionException)e;
/*  58 */     if ((e instanceof MBeanRegistrationException)) {
/*  59 */       return (MBeanRegistrationException)e;
/*     */     }
/*     */ 
/*  62 */     if ((e instanceof ClassNotFoundException))
/*  63 */       return new ReflectionException(e);
/*  64 */     if ((e instanceof IllegalAccessException))
/*  65 */       return new ReflectionException(e);
/*  66 */     if ((e instanceof InstantiationException))
/*  67 */       return new ReflectionException(e);
/*  68 */     if ((e instanceof NoSuchMethodException)) {
/*  69 */       return new ReflectionException(e);
/*     */     }
/*     */ 
/*  73 */     if ((e instanceof MBeanException))
/*     */     {
/*  75 */       Throwable cause = e.getCause();
/*     */ 
/*  77 */       if ((cause instanceof JMException)) {
/*  78 */         return (JMException)cause;
/*     */       }
/*  80 */       return (MBeanException)e;
/*     */     }
/*     */ 
/*  84 */     return new MBeanException(e);
/*     */   }
/*     */ 
/*     */   private static void handleRuntimeExceptionOrError(Throwable e)
/*     */   {
/*  95 */     if ((e instanceof RuntimeOperationsException))
/*  96 */       throw ((RuntimeOperationsException)e);
/*  97 */     if ((e instanceof RuntimeErrorException))
/*  98 */       throw ((RuntimeErrorException)e);
/*  99 */     if ((e instanceof RuntimeMBeanException)) {
/* 100 */       throw ((RuntimeMBeanException)e);
/*     */     }
/*     */ 
/* 103 */     if ((e instanceof IllegalArgumentException))
/* 104 */       throw new RuntimeOperationsException((IllegalArgumentException)e);
/* 105 */     if ((e instanceof IndexOutOfBoundsException))
/* 106 */       throw new RuntimeOperationsException((IndexOutOfBoundsException)e);
/* 107 */     if ((e instanceof NullPointerException)) {
/* 108 */       throw new RuntimeOperationsException((NullPointerException)e);
/*     */     }
/*     */ 
/* 111 */     if ((e instanceof Error)) {
/* 112 */       throw new RuntimeErrorException((Error)e);
/*     */     }
/*     */ 
/* 115 */     if ((e instanceof RuntimeException))
/* 116 */       throw new RuntimeMBeanException((RuntimeException)e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.server.ExceptionHandler
 * JD-Core Version:    0.6.0
 */