/*     */ package org.jboss.mx.server;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import org.jboss.mx.interceptor.AbstractInterceptor;
/*     */ import org.jboss.mx.interceptor.Interceptor;
/*     */ import org.jboss.util.Classes;
/*     */ 
/*     */ public class InvocationContext
/*     */ {
/*     */   public static final String OP_INVOKE = "invoke";
/*     */   public static final String OP_GETATTRIBUTE = "getAttribute";
/*     */   public static final String OP_SETATTRIBUTE = "setAttribute";
/*     */   public static final String OP_GETMBEANINFO = "getMBeanInfo";
/*     */   public static final String OPERATION_IMPACT = "operation.impact";
/*     */   public static final String ATTRIBUTE_ACCESS = "attribute.access";
/*  54 */   private static final Class VOID = Void.class;
/*     */ 
/*  56 */   public static final Class[] NOCLASSES = new Class[0];
/*     */   private String attributeType;
/*     */   private String name;
/*     */   private String[] signature;
/*     */   private String returnType;
/*     */   private String type;
/*     */   private boolean isWritable;
/*     */   private boolean isReadable;
/*     */   List interceptors;
/*     */   transient Interceptor dispatcher;
/*     */   transient Object target;
/*     */   transient Descriptor descriptor;
/*     */   transient AbstractMBeanInvoker invoker;
/*     */   transient Class attributeTypeClass;
/*     */   transient Class returnTypeClass;
/*     */   transient Class[] signatureClasses;
/*     */ 
/*     */   public InvocationContext()
/*     */   {
/*  60 */     this.attributeType = null;
/*  61 */     this.name = null;
/*  62 */     this.signature = null;
/*  63 */     this.returnType = null;
/*  64 */     this.type = null;
/*  65 */     this.isWritable = true;
/*  66 */     this.isReadable = true;
/*     */ 
/*  68 */     this.interceptors = null;
/*  69 */     this.dispatcher = new NullDispatcher();
/*  70 */     this.target = null;
/*  71 */     this.descriptor = null;
/*  72 */     this.invoker = null;
/*  73 */     this.attributeTypeClass = null;
/*  74 */     this.returnTypeClass = null;
/*  75 */     this.signatureClasses = null;
/*     */   }
/*     */ 
/*     */   public final void copy(InvocationContext src)
/*     */   {
/*  81 */     if (src == null) {
/*  82 */       return;
/*     */     }
/*  84 */     this.attributeType = src.attributeType;
/*  85 */     this.attributeTypeClass = src.attributeTypeClass;
/*  86 */     this.name = src.name;
/*  87 */     this.signature = src.signature;
/*  88 */     this.signatureClasses = src.signatureClasses;
/*  89 */     this.returnType = src.returnType;
/*  90 */     this.returnTypeClass = src.returnTypeClass;
/*  91 */     this.type = src.type;
/*  92 */     this.isWritable = src.isWritable;
/*  93 */     this.interceptors = src.interceptors;
/*  94 */     this.dispatcher = src.dispatcher;
/*  95 */     this.target = src.target;
/*  96 */     this.descriptor = src.descriptor;
/*  97 */     this.invoker = src.invoker;
/*     */   }
/*     */ 
/*     */   public void setType(String type)
/*     */   {
/* 102 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/* 107 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 112 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 117 */     return this.name;
/*     */   }
/*     */ 
/*     */   void setSignature(String[] signature)
/*     */   {
/* 122 */     this.signature = signature;
/*     */   }
/*     */ 
/*     */   void setSignature(MBeanParameterInfo[] signature)
/*     */   {
/* 127 */     this.signature = new String[signature.length];
/*     */ 
/* 129 */     for (int i = 0; i < signature.length; i++)
/* 130 */       this.signature[i] = signature[i].getType();
/*     */   }
/*     */ 
/*     */   public String[] getSignature()
/*     */   {
/* 136 */     return this.signature;
/*     */   }
/*     */ 
/*     */   public Class[] getSignatureClasses() throws ClassNotFoundException
/*     */   {
/* 141 */     if (this.signatureClasses != null)
/* 142 */       return this.signatureClasses;
/* 143 */     if ((this.signature == null) || (this.signature.length == 0))
/* 144 */       return NOCLASSES;
/* 145 */     Class[] signatureClassesTemp = new Class[this.signature.length];
/* 146 */     for (int i = 0; i < this.signature.length; i++)
/* 147 */       signatureClassesTemp[i] = Thread.currentThread().getContextClassLoader().loadClass(this.signature[i]);
/* 148 */     this.signatureClasses = signatureClassesTemp;
/* 149 */     return this.signatureClasses;
/*     */   }
/*     */ 
/*     */   public void setAttributeType(String attrType)
/*     */   {
/* 154 */     this.attributeType = attrType;
/* 155 */     this.attributeTypeClass = null;
/*     */   }
/*     */ 
/*     */   public String getAttributeType()
/*     */   {
/* 160 */     return this.attributeType;
/*     */   }
/*     */ 
/*     */   public Class getAttributeTypeClass() throws ClassNotFoundException
/*     */   {
/* 165 */     if (this.attributeType == null)
/* 166 */       return null;
/* 167 */     if (this.attributeTypeClass != null)
/* 168 */       return this.attributeTypeClass;
/* 169 */     this.attributeTypeClass = loadClass(this.attributeType);
/* 170 */     return this.attributeTypeClass;
/*     */   }
/*     */ 
/*     */   public void setReturnType(String returnType)
/*     */   {
/* 175 */     this.returnType = returnType;
/* 176 */     this.returnTypeClass = null;
/*     */   }
/*     */ 
/*     */   public String getReturnType()
/*     */   {
/* 181 */     return this.returnType;
/*     */   }
/*     */ 
/*     */   public Class getReturnTypeClass() throws ClassNotFoundException
/*     */   {
/* 186 */     if (this.returnType == null)
/* 187 */       return null;
/* 188 */     if (this.returnTypeClass == VOID)
/* 189 */       return null;
/* 190 */     if (this.returnTypeClass != null)
/* 191 */       return this.returnTypeClass;
/* 192 */     if (this.returnType.equals("void"))
/*     */     {
/* 194 */       this.returnTypeClass = VOID;
/* 195 */       return null;
/*     */     }
/*     */ 
/* 198 */     this.returnTypeClass = loadClass(this.returnType);
/* 199 */     return this.returnTypeClass;
/*     */   }
/*     */ 
/*     */   public boolean isReadable()
/*     */   {
/* 204 */     return this.isReadable;
/*     */   }
/*     */ 
/*     */   public void setReadable(boolean readable)
/*     */   {
/* 209 */     this.isReadable = readable;
/*     */   }
/*     */ 
/*     */   public boolean isWritable()
/*     */   {
/* 214 */     return this.isWritable;
/*     */   }
/*     */ 
/*     */   public void setWritable(boolean writable)
/*     */   {
/* 219 */     this.isWritable = writable;
/*     */   }
/*     */ 
/*     */   public void setInterceptors(List interceptors)
/*     */   {
/* 225 */     this.interceptors = interceptors;
/*     */   }
/*     */ 
/*     */   public List getInterceptors()
/*     */   {
/* 231 */     if (this.interceptors == null)
/*     */     {
/* 233 */       this.interceptors = new ArrayList();
/*     */     }
/* 235 */     return this.interceptors;
/*     */   }
/*     */ 
/*     */   public void setDispatcher(Interceptor d)
/*     */   {
/* 240 */     this.dispatcher = d;
/*     */   }
/*     */ 
/*     */   public Interceptor getDispatcher()
/*     */   {
/* 245 */     return this.dispatcher;
/*     */   }
/*     */ 
/*     */   void setTarget(Object o)
/*     */   {
/* 250 */     this.target = o;
/*     */   }
/*     */ 
/*     */   public Object getTarget()
/*     */   {
/* 255 */     return this.target;
/*     */   }
/*     */ 
/*     */   public void setDescriptor(Descriptor d)
/*     */   {
/* 260 */     this.descriptor = d;
/*     */   }
/*     */ 
/*     */   public Descriptor getDescriptor()
/*     */   {
/* 265 */     return this.descriptor;
/*     */   }
/*     */ 
/*     */   public void setInvoker(AbstractMBeanInvoker mi)
/*     */   {
/* 270 */     this.invoker = mi;
/*     */   }
/*     */ 
/*     */   public MBeanInvoker getInvoker()
/*     */   {
/* 275 */     return this.invoker;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 283 */     StringBuffer sbuf = new StringBuffer(256);
/*     */ 
/* 285 */     sbuf.append("InvocationContext[").append(" name=").append(this.name).append(", type=").append(this.type).append(", attributeType=").append(this.attributeType).append(", isReadable=").append(this.isReadable).append(", isWritable=").append(this.isWritable).append(", returnType=").append(this.returnType);
/*     */ 
/* 293 */     if (this.signature != null)
/*     */     {
/* 295 */       sbuf.append(", signature=[");
/* 296 */       for (int i = 0; i < this.signature.length; i++)
/*     */       {
/* 298 */         sbuf.append(" arg[").append(i).append("]=").append(this.signature[i]);
/*     */       }
/* 300 */       sbuf.append(" ] ]");
/*     */     }
/*     */     else
/*     */     {
/* 304 */       sbuf.append(", signature=null ]");
/*     */     }
/* 306 */     return sbuf.toString();
/*     */   }
/*     */ 
/*     */   private Class loadClass(String clazz)
/*     */     throws ClassNotFoundException
/*     */   {
/* 313 */     Class isPrimitive = Classes.getPrimitiveTypeForName(clazz);
/* 314 */     if (isPrimitive != null)
/* 315 */       return Classes.getPrimitiveWrapper(isPrimitive);
/* 316 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 317 */     return cl.loadClass(clazz);
/*     */   }
/*     */ 
/*     */   class NullDispatcher extends AbstractInterceptor
/*     */   {
/*     */     public NullDispatcher()
/*     */     {
/* 326 */       super();
/*     */     }
/*     */ 
/*     */     public Object invoke(Invocation invocation) throws Throwable
/*     */     {
/* 331 */       return null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.server.InvocationContext
 * JD-Core Version:    0.6.0
 */