/*      */ package org.jboss.mx.server;
/*      */ 
/*      */ import java.io.ByteArrayInputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.lang.reflect.Constructor;
/*      */ import java.lang.reflect.InvocationTargetException;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.security.PrivilegedActionException;
/*      */ import java.security.PrivilegedExceptionAction;
/*      */ import java.security.ProtectionDomain;
/*      */ import java.util.ArrayList;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import javax.management.Attribute;
/*      */ import javax.management.AttributeList;
/*      */ import javax.management.AttributeNotFoundException;
/*      */ import javax.management.InstanceAlreadyExistsException;
/*      */ import javax.management.InstanceNotFoundException;
/*      */ import javax.management.IntrospectionException;
/*      */ import javax.management.InvalidAttributeValueException;
/*      */ import javax.management.JMException;
/*      */ import javax.management.JMRuntimeException;
/*      */ import javax.management.ListenerNotFoundException;
/*      */ import javax.management.MBeanException;
/*      */ import javax.management.MBeanInfo;
/*      */ import javax.management.MBeanParameterInfo;
/*      */ import javax.management.MBeanPermission;
/*      */ import javax.management.MBeanRegistrationException;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.MBeanServerDelegate;
/*      */ import javax.management.MBeanTrustPermission;
/*      */ import javax.management.MalformedObjectNameException;
/*      */ import javax.management.NotCompliantMBeanException;
/*      */ import javax.management.NotificationBroadcaster;
/*      */ import javax.management.NotificationFilter;
/*      */ import javax.management.NotificationListener;
/*      */ import javax.management.ObjectInstance;
/*      */ import javax.management.ObjectName;
/*      */ import javax.management.OperationsException;
/*      */ import javax.management.QueryExp;
/*      */ import javax.management.ReflectionException;
/*      */ import javax.management.RuntimeErrorException;
/*      */ import javax.management.RuntimeMBeanException;
/*      */ import javax.management.RuntimeOperationsException;
/*      */ import javax.management.loading.ClassLoaderRepository;
/*      */ import javax.management.modelmbean.DescriptorSupport;
/*      */ import javax.management.modelmbean.ModelMBean;
/*      */ import javax.management.modelmbean.ModelMBeanAttributeInfo;
/*      */ import javax.management.modelmbean.ModelMBeanConstructorInfo;
/*      */ import javax.management.modelmbean.ModelMBeanInfo;
/*      */ import javax.management.modelmbean.ModelMBeanInfoSupport;
/*      */ import javax.management.modelmbean.ModelMBeanNotificationInfo;
/*      */ import javax.management.modelmbean.ModelMBeanOperationInfo;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.mx.loading.LoaderRepository;
/*      */ import org.jboss.mx.modelmbean.ModelMBeanConstants;
/*      */ import org.jboss.mx.modelmbean.RequiredModelMBeanInstantiator;
/*      */ import org.jboss.mx.notification.MBeanServerListenerRegistry;
/*      */ import org.jboss.mx.server.registry.MBeanEntry;
/*      */ import org.jboss.mx.server.registry.MBeanRegistry;
/*      */ import org.jboss.mx.service.ServiceConstants;
/*      */ import org.jboss.mx.util.JMXExceptionDecoder;
/*      */ import org.jboss.mx.util.PropertyAccess;
/*      */ import org.jboss.util.NestedRuntimeException;
/*      */ 
/*      */ public class MBeanServerImpl
/*      */   implements MBeanServer, ServerConstants, ServiceConstants, ModelMBeanConstants
/*      */ {
/*  140 */   private static final Object[] NOPARAMS = new Object[0];
/*      */ 
/*  145 */   private static final String[] NOSIG = new String[0];
/*      */ 
/*  152 */   protected MBeanServer outer = null;
/*      */ 
/*  157 */   protected MBeanRegistry registry = null;
/*      */ 
/*  162 */   private MBeanServerListenerRegistry listeners = new MBeanServerListenerRegistry();
/*      */   private ClassLoaderRepository classLoaderRepository;
/*  174 */   private static Logger log = Logger.getLogger(MBeanServerImpl.class);
/*      */ 
/*      */   public MBeanServerImpl(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate)
/*      */   {
/*  193 */     if (outer == null)
/*  194 */       this.outer = this;
/*      */     else {
/*  196 */       this.outer = outer;
/*      */     }
/*      */ 
/*  199 */     this.classLoaderRepository = getClassLoaderRepository();
/*      */ 
/*  202 */     this.registry = createRegistry(defaultDomain);
/*      */     try
/*      */     {
/*  211 */       HashMap valueMap = new HashMap();
/*  212 */       valueMap.put("JMImplementation", "JMImplementation");
/*      */ 
/*  215 */       this.registry.registerMBean(delegate, new ObjectName("JMImplementation:type=MBeanServerDelegate"), valueMap);
/*      */ 
/*  220 */       ModelMBean rmm = RequiredModelMBeanInstantiator.instantiate();
/*  221 */       rmm.setModelMBeanInfo(getRegistryManagementInterface());
/*  222 */       rmm.setManagedResource(this.registry, "ObjectReference");
/*      */ 
/*  225 */       this.registry.registerMBean(rmm, new ObjectName("JMImplementation:type=MBeanRegistry"), valueMap);
/*      */ 
/*  233 */       ObjectName loaderName = new ObjectName("JMImplementation:service=LoaderRepository,name=Default");
/*  234 */       this.registry.registerMBean(this.classLoaderRepository, loaderName, valueMap);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  239 */       throw new RuntimeException("Cannot create MBeanServer", e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object instantiate(String className)
/*      */     throws ReflectionException, MBeanException
/*      */   {
/*  248 */     return instantiate(className, (ClassLoader)null, NOPARAMS, NOSIG);
/*      */   }
/*      */ 
/*      */   public Object instantiate(String className, Object[] params, String[] signature)
/*      */     throws ReflectionException, MBeanException
/*      */   {
/*  254 */     return instantiate(className, (ClassLoader)null, params, signature);
/*      */   }
/*      */ 
/*      */   public Object instantiate(String className, ObjectName loaderName)
/*      */     throws ReflectionException, MBeanException, InstanceNotFoundException
/*      */   {
/*  260 */     return instantiate(className, loaderName, NOPARAMS, NOSIG);
/*      */   }
/*      */ 
/*      */   public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature)
/*      */     throws ReflectionException, MBeanException, InstanceNotFoundException
/*      */   {
/*  266 */     ClassLoader cl = null;
/*      */     try
/*      */     {
/*  273 */       if (loaderName != null)
/*  274 */         cl = (ClassLoader)this.registry.get(loaderName).getResourceInstance();
/*      */     }
/*      */     catch (ClassCastException e)
/*      */     {
/*  278 */       throw new ReflectionException(e, loaderName + " is not a class loader.");
/*      */     }
/*      */ 
/*  281 */     if (cl == null)
/*  282 */       cl = getClass().getClassLoader();
/*  283 */     if (cl == null) {
/*  284 */       cl = ClassLoader.getSystemClassLoader();
/*      */     }
/*  286 */     return instantiate(className, cl, params, signature);
/*      */   }
/*      */ 
/*      */   public ObjectInstance createMBean(String className, ObjectName name)
/*      */     throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException
/*      */   {
/*      */     try
/*      */     {
/*  294 */       Object mbean = instantiate(className);
/*  295 */       return registerMBean(mbean, name, (ClassLoader)null);
/*      */     }
/*      */     catch (SecurityException e)
/*      */     {
/*  299 */       throw e;
/*      */     }
/*      */     catch (ReflectionException refex)
/*      */     {
/*  304 */       if ((refex.getCause() instanceof InstantiationException))
/*  305 */         throw new NotCompliantMBeanException("Cannot instanciate MBean: " + className);
/*      */     }
/*  307 */     throw refex;
/*      */   }
/*      */ 
/*      */   public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature)
/*      */     throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException
/*      */   {
/*      */     try
/*      */     {
/*  316 */       Object mbean = instantiate(className, params, signature);
/*  317 */       return registerMBean(mbean, name, (ClassLoader)null);
/*      */     }
/*      */     catch (ReflectionException refex) {
/*      */     }
/*  321 */     return handleExceptionOnCreate(refex, className);
/*      */   }
/*      */ 
/*      */   public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName)
/*      */     throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException
/*      */   {
/*      */     try
/*      */     {
/*  330 */       Object mbean = instantiate(className, loaderName);
/*  331 */       return registerMBean(mbean, name, loaderName);
/*      */     }
/*      */     catch (ReflectionException refex) {
/*      */     }
/*  335 */     return handleExceptionOnCreate(refex, className);
/*      */   }
/*      */ 
/*      */   public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature)
/*      */     throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException
/*      */   {
/*      */     try
/*      */     {
/*  344 */       Object mbean = instantiate(className, loaderName, params, signature);
/*  345 */       return registerMBean(mbean, name, loaderName);
/*      */     }
/*      */     catch (ReflectionException refex) {
/*      */     }
/*  349 */     return handleExceptionOnCreate(refex, className);
/*      */   }
/*      */ 
/*      */   private ObjectInstance handleExceptionOnCreate(ReflectionException refex, String className)
/*      */     throws NotCompliantMBeanException, ReflectionException
/*      */   {
/*  360 */     if ((refex.getCause() instanceof InstantiationException)) {
/*  361 */       throw new NotCompliantMBeanException("Cannot instanciate MBean: " + className);
/*      */     }
/*  363 */     throw refex;
/*      */   }
/*      */ 
/*      */   public ObjectInstance registerMBean(Object object, ObjectName name)
/*      */     throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException
/*      */   {
/*  376 */     return registerMBean(object, name, (ClassLoader)null);
/*      */   }
/*      */ 
/*      */   public void unregisterMBean(ObjectName name)
/*      */     throws InstanceNotFoundException, MBeanRegistrationException
/*      */   {
/*  383 */     MBeanEntry entry = this.registry.get(name);
/*  384 */     Object mbean = entry.getResourceInstance();
/*  385 */     name = entry.getObjectName();
/*      */ 
/*  387 */     checkMBeanPermission(entry.getResourceClassName(), null, name, "unregisterMBean");
/*      */     try
/*      */     {
/*  391 */       Object[] args = { name };
/*  392 */       String[] sig = { ObjectName.class.getName() };
/*      */       try
/*      */       {
/*  395 */         AccessController.doPrivileged(new PrivilegedExceptionAction(args, sig)
/*      */         {
/*      */           public Object run()
/*      */             throws Exception
/*      */           {
/*  400 */             return MBeanServerImpl.this.invoke(new ObjectName("JMImplementation:type=MBeanRegistry"), "unregisterMBean", this.val$args, this.val$sig);
/*      */           }
/*      */ 
/*      */         });
/*      */       }
/*      */       catch (PrivilegedActionException e)
/*      */       {
/*  408 */         throw e.getException();
/*      */       }
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  413 */       Throwable result = JMXExceptionDecoder.decodeToJMXException(t);
/*  414 */       if ((result instanceof InstanceNotFoundException))
/*  415 */         throw ((InstanceNotFoundException)result);
/*  416 */       if ((result instanceof MBeanRegistrationException))
/*  417 */         throw ((MBeanRegistrationException)result);
/*  418 */       if ((result instanceof JMRuntimeException))
/*  419 */         throw ((JMRuntimeException)result);
/*  420 */       if ((result instanceof MBeanException))
/*      */       {
/*  422 */         MBeanException e = (MBeanException)result;
/*  423 */         t = e.getTargetException();
/*  424 */         if ((t instanceof InstanceNotFoundException))
/*  425 */           throw ((InstanceNotFoundException)t);
/*  426 */         if ((t instanceof MBeanRegistrationException))
/*  427 */           throw ((MBeanRegistrationException)t);
/*      */       }
/*  429 */       if ((result instanceof RuntimeException))
/*  430 */         throw new RuntimeMBeanException((RuntimeException)result);
/*  431 */       if ((result instanceof Error)) {
/*  432 */         throw new RuntimeErrorException((Error)result);
/*      */       }
/*      */ 
/*  435 */       throw new MBeanRegistrationException(new InvocationTargetException(t), "Cannot unregister MBean");
/*      */     }
/*      */ 
/*  439 */     if ((mbean instanceof NotificationBroadcaster))
/*  440 */       this.listeners.remove(name);
/*      */   }
/*      */ 
/*      */   public ObjectInstance getObjectInstance(ObjectName name)
/*      */     throws InstanceNotFoundException
/*      */   {
/*  446 */     ObjectInstance oi = this.registry.getObjectInstance(name);
/*  447 */     checkMBeanPermission(oi.getClassName(), null, name, "getObjectInstance");
/*      */ 
/*  450 */     return oi;
/*      */   }
/*      */ 
/*      */   public Set queryMBeans(ObjectName name, QueryExp query)
/*      */   {
/*  456 */     checkMBeanPermission(null, null, null, "queryMBeans");
/*      */ 
/*  459 */     Set result = new HashSet();
/*  460 */     if (query != null) {
/*  461 */       query.setMBeanServer(this.outer);
/*      */     }
/*  463 */     SecurityManager sm = System.getSecurityManager();
/*      */ 
/*  465 */     List entries = this.registry.findEntries(name);
/*  466 */     Iterator iterator = entries.iterator();
/*  467 */     while (iterator.hasNext())
/*      */     {
/*  470 */       MBeanEntry entry = (MBeanEntry)iterator.next();
/*  471 */       ObjectName objectName = entry.getObjectName();
/*      */ 
/*  473 */       if (sm != null)
/*      */       {
/*      */         try
/*      */         {
/*  477 */           checkMBeanPermission(entry.getResourceClassName(), null, objectName, "queryMBeans");
/*      */         }
/*      */         catch (SecurityException e)
/*      */         {
/*  482 */           if (log.isTraceEnabled())
/*  483 */             log.trace("Excluded mbean due to security: " + objectName); 
/*      */         }
/*  484 */         continue;
/*      */       }
/*      */ 
/*  488 */       if (queryMBean(objectName, query) == true)
/*      */       {
/*      */         try
/*      */         {
/*  492 */           ObjectInstance instance = this.registry.getObjectInstance(objectName);
/*  493 */           result.add(instance);
/*      */         }
/*      */         catch (InstanceNotFoundException ignored)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  501 */     return result;
/*      */   }
/*      */ 
/*      */   public Set queryNames(ObjectName name, QueryExp query)
/*      */   {
/*  507 */     checkMBeanPermission(null, null, null, "queryNames");
/*      */ 
/*  510 */     Set result = new HashSet();
/*  511 */     if (query != null) {
/*  512 */       query.setMBeanServer(this.outer);
/*      */     }
/*  514 */     SecurityManager sm = System.getSecurityManager();
/*      */ 
/*  516 */     List entries = this.registry.findEntries(name);
/*  517 */     Iterator iterator = entries.iterator();
/*  518 */     while (iterator.hasNext())
/*      */     {
/*  521 */       MBeanEntry entry = (MBeanEntry)iterator.next();
/*  522 */       ObjectName objectName = entry.getObjectName();
/*      */ 
/*  524 */       if (sm != null)
/*      */       {
/*      */         try
/*      */         {
/*  528 */           checkMBeanPermission(entry.getResourceClassName(), null, objectName, "queryNames");
/*      */         }
/*      */         catch (SecurityException e)
/*      */         {
/*  533 */           if (log.isTraceEnabled())
/*  534 */             log.trace("Excluded mbean due to security: " + objectName); 
/*      */         }
/*  535 */         continue;
/*      */       }
/*      */ 
/*  539 */       if (queryMBean(objectName, query) == true) {
/*  540 */         result.add(objectName);
/*      */       }
/*      */     }
/*  543 */     return result;
/*      */   }
/*      */ 
/*      */   public boolean isRegistered(ObjectName name)
/*      */   {
/*  548 */     return this.registry.contains(name);
/*      */   }
/*      */ 
/*      */   public Integer getMBeanCount()
/*      */   {
/*  553 */     return new Integer(this.registry.getSize());
/*      */   }
/*      */ 
/*      */   public Object getAttribute(ObjectName name, String attribute)
/*      */     throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException
/*      */   {
/*  559 */     MBeanEntry entry = this.registry.get(name);
/*  560 */     checkMBeanPermission(entry.getResourceClassName(), attribute, name, "getAttribute");
/*      */ 
/*  563 */     MBeanInvoker mbean = entry.getInvoker();
/*      */ 
/*  565 */     return mbean.getAttribute(attribute);
/*      */   }
/*      */ 
/*      */   public AttributeList getAttributes(ObjectName name, String[] attributes)
/*      */     throws InstanceNotFoundException, ReflectionException
/*      */   {
/*  571 */     MBeanEntry entry = this.registry.get(name);
/*  572 */     String className = entry.getResourceClassName();
/*      */ 
/*  577 */     checkMBeanPermission(className, null, name, "getAttribute");
/*      */ 
/*  579 */     MBeanInvoker mbean = entry.getInvoker();
/*  580 */     AttributeList list = mbean.getAttributes(attributes);
/*  581 */     SecurityManager sm = System.getSecurityManager();
/*  582 */     if (sm != null)
/*      */     {
/*  585 */       Iterator iter = list.iterator();
/*  586 */       while (iter.hasNext())
/*      */       {
/*  588 */         Attribute attr = (Attribute)iter.next();
/*  589 */         String aname = attr.getName();
/*      */         try
/*      */         {
/*  592 */           checkMBeanPermission(className, aname, name, "getAttribute");
/*      */         }
/*      */         catch (SecurityException e)
/*      */         {
/*  596 */           if (log.isTraceEnabled())
/*  597 */             log.trace("Excluded attribute due to security: " + aname);
/*  598 */           iter.remove();
/*      */         }
/*      */       }
/*      */     }
/*  602 */     return list;
/*      */   }
/*      */ 
/*      */   public void setAttribute(ObjectName name, Attribute attribute)
/*      */     throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*      */   {
/*  608 */     MBeanEntry entry = this.registry.get(name);
/*  609 */     String attributeName = null;
/*  610 */     if (attribute != null)
/*  611 */       attributeName = attribute.getName();
/*  612 */     checkMBeanPermission(entry.getResourceClassName(), attributeName, name, "setAttribute");
/*      */ 
/*  615 */     MBeanInvoker mbean = entry.getInvoker();
/*      */ 
/*  617 */     mbean.setAttribute(attribute);
/*      */   }
/*      */ 
/*      */   public AttributeList setAttributes(ObjectName name, AttributeList attributes)
/*      */     throws InstanceNotFoundException, ReflectionException
/*      */   {
/*  623 */     MBeanEntry entry = this.registry.get(name);
/*      */ 
/*  625 */     String className = entry.getResourceClassName();
/*      */ 
/*  630 */     checkMBeanPermission(className, null, name, "setAttribute");
/*      */ 
/*  632 */     MBeanInvoker mbean = entry.getInvoker();
/*  633 */     AttributeList list = mbean.setAttributes(attributes);
/*  634 */     SecurityManager sm = System.getSecurityManager();
/*  635 */     if (sm != null)
/*      */     {
/*  638 */       Iterator iter = list.iterator();
/*  639 */       while (iter.hasNext())
/*      */       {
/*  641 */         Attribute attr = (Attribute)iter.next();
/*  642 */         String aname = attr.getName();
/*      */         try
/*      */         {
/*  645 */           checkMBeanPermission(className, aname, name, "setAttribute");
/*      */         }
/*      */         catch (SecurityException e)
/*      */         {
/*  649 */           if (log.isTraceEnabled())
/*  650 */             log.trace("Excluded attribute due to security: " + aname);
/*  651 */           iter.remove();
/*      */         }
/*      */       }
/*      */     }
/*  655 */     return list;
/*      */   }
/*      */ 
/*      */   public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature)
/*      */     throws InstanceNotFoundException, MBeanException, ReflectionException
/*      */   {
/*  662 */     MBeanEntry entry = this.registry.get(name);
/*  663 */     checkMBeanPermission(entry.getResourceClassName(), operationName, name, "invoke");
/*      */ 
/*  666 */     MBeanInvoker mbean = entry.getInvoker();
/*      */ 
/*  668 */     return mbean.invoke(operationName, params, signature);
/*      */   }
/*      */ 
/*      */   public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
/*  675 */     MBeanEntry entry = this.registry.get(name);
/*  676 */     checkMBeanPermission(entry.getResourceClassName(), null, name, "getMBeanInfo");
/*      */     JMException result;
/*      */     try {
/*  680 */       MBeanInvoker invoker = entry.getInvoker();
/*  681 */       return invoker.getMBeanInfo();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  685 */       result = ExceptionHandler.handleException(e);
/*  686 */       if ((result instanceof InstanceNotFoundException))
/*  687 */         throw ((InstanceNotFoundException)result);
/*  688 */       if ((result instanceof IntrospectionException))
/*  689 */         throw ((IntrospectionException)result);
/*  690 */       if ((result instanceof ReflectionException))
/*  691 */         throw ((ReflectionException)result); 
/*      */     }
/*  692 */     throw new RuntimeException("Cannot obtain MBeanInfo " + name, result);
/*      */   }
/*      */ 
/*      */   public String getDefaultDomain()
/*      */   {
/*  698 */     return this.registry.getDefaultDomain();
/*      */   }
/*      */ 
/*      */   public String[] getDomains()
/*      */   {
/*  703 */     checkMBeanPermission(null, null, null, "getDomains");
/*  704 */     String[] domains = this.registry.getDomains();
/*  705 */     SecurityManager sm = System.getSecurityManager();
/*  706 */     if (sm != null)
/*      */     {
/*  708 */       ArrayList tmp = new ArrayList();
/*      */ 
/*  710 */       int length = domains != null ? domains.length : 0;
/*  711 */       for (int n = 0; n < length; n++)
/*      */       {
/*  713 */         String domain = domains[n];
/*      */         try
/*      */         {
/*  716 */           ObjectName name = new ObjectName(domain, "x", "x");
/*  717 */           checkMBeanPermission(null, null, name, "getDomains");
/*  718 */           tmp.add(domain);
/*      */         }
/*      */         catch (MalformedObjectNameException e)
/*      */         {
/*      */         }
/*      */         catch (SecurityException e)
/*      */         {
/*  726 */           if (log.isTraceEnabled())
/*  727 */             log.trace("Excluded domain due to security: " + domain);
/*      */         }
/*      */       }
/*  730 */       domains = new String[tmp.size()];
/*  731 */       tmp.toArray(domains);
/*      */     }
/*  733 */     return domains;
/*      */   }
/*      */ 
/*      */   public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback)
/*      */     throws InstanceNotFoundException
/*      */   {
/*  746 */     MBeanEntry entry = this.registry.get(name);
/*  747 */     if (!NotificationBroadcaster.class.isInstance(entry.getResourceInstance())) {
/*  748 */       throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + name + " exists but does not implement the NotificationBroadcaster interface."));
/*      */     }
/*  750 */     if (listener == null) {
/*  751 */       throw new RuntimeOperationsException(new IllegalArgumentException("Cannot add null listener"));
/*      */     }
/*  753 */     checkMBeanPermission(entry.getResourceClassName(), null, name, "addNotificationListener");
/*      */ 
/*  756 */     ClassLoader newTCL = entry.getClassLoader();
/*  757 */     NotificationBroadcaster broadcaster = entry.getInvoker();
/*      */ 
/*  759 */     ClassLoader oldTCL = TCLAction.UTIL.getContextClassLoader();
/*  760 */     boolean setCl = (newTCL != oldTCL) && (newTCL != null);
/*      */     try
/*      */     {
/*  763 */       if (setCl) {
/*  764 */         TCLAction.UTIL.setContextClassLoader(newTCL);
/*      */       }
/*  766 */       this.listeners.add(entry.getObjectName(), broadcaster, listener, filter, handback);
/*      */     }
/*      */     finally
/*      */     {
/*  770 */       if (setCl)
/*  771 */         TCLAction.UTIL.setContextClassLoader(oldTCL);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback)
/*      */     throws InstanceNotFoundException
/*      */   {
/*  788 */     MBeanEntry entry = this.registry.get(name);
/*  789 */     if (!NotificationBroadcaster.class.isInstance(entry.getResourceInstance())) {
/*  790 */       throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + name + " exists but does not implement the NotificationBroadcaster interface."));
/*      */     }
/*  792 */     MBeanEntry listenerEntry = this.registry.get(listener);
/*  793 */     if (!NotificationListener.class.isInstance(listenerEntry.getResourceInstance())) {
/*  794 */       throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + listener + " exists but does not implement the NotificationListener interface."));
/*      */     }
/*  796 */     checkMBeanPermission(entry.getResourceClassName(), null, name, "addNotificationListener");
/*      */ 
/*  799 */     ClassLoader newTCL = entry.getClassLoader();
/*  800 */     NotificationBroadcaster broadcaster = entry.getInvoker();
/*      */ 
/*  802 */     ClassLoader oldTCL = TCLAction.UTIL.getContextClassLoader();
/*  803 */     boolean setCl = (newTCL != oldTCL) && (newTCL != null);
/*      */     try
/*      */     {
/*  806 */       if (setCl) {
/*  807 */         TCLAction.UTIL.setContextClassLoader(newTCL);
/*      */       }
/*  809 */       this.listeners.add(entry.getObjectName(), broadcaster, (NotificationListener)this.registry.get(listener).getResourceInstance(), filter, handback);
/*      */     }
/*      */     finally
/*      */     {
/*  814 */       if (setCl)
/*  815 */         TCLAction.UTIL.setContextClassLoader(oldTCL);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeNotificationListener(ObjectName name, NotificationListener listener)
/*      */     throws InstanceNotFoundException, ListenerNotFoundException
/*      */   {
/*  828 */     MBeanEntry entry = this.registry.get(name);
/*  829 */     if (!NotificationBroadcaster.class.isInstance(entry.getResourceInstance())) {
/*  830 */       throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + name + " exists but does not implement the NotificationBroadcaster interface."));
/*      */     }
/*  832 */     checkMBeanPermission(entry.getResourceClassName(), null, name, "removeNotificationListener");
/*      */ 
/*  835 */     ClassLoader newTCL = entry.getClassLoader();
/*      */ 
/*  837 */     ClassLoader oldTCL = TCLAction.UTIL.getContextClassLoader();
/*  838 */     boolean setCl = (newTCL != oldTCL) && (newTCL != null);
/*      */     try
/*      */     {
/*  841 */       if (setCl) {
/*  842 */         TCLAction.UTIL.setContextClassLoader(newTCL);
/*      */       }
/*  844 */       this.listeners.remove(entry.getObjectName(), listener);
/*      */     }
/*      */     finally
/*      */     {
/*  848 */       if (setCl)
/*  849 */         TCLAction.UTIL.setContextClassLoader(oldTCL);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeNotificationListener(ObjectName name, ObjectName listener)
/*      */     throws InstanceNotFoundException, ListenerNotFoundException
/*      */   {
/*  862 */     MBeanEntry entry = this.registry.get(name);
/*  863 */     if (!NotificationBroadcaster.class.isInstance(entry.getResourceInstance())) {
/*  864 */       throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + name + " exists but does not implement the NotificationBroadcaster interface."));
/*      */     }
/*  866 */     MBeanEntry listenerEntry = this.registry.get(listener);
/*  867 */     if (!NotificationListener.class.isInstance(listenerEntry.getResourceInstance())) {
/*  868 */       throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + listener + " exists but does not implement the NotificationListener interface."));
/*      */     }
/*  870 */     checkMBeanPermission(entry.getResourceClassName(), null, name, "removeNotificationListener");
/*      */ 
/*  873 */     ClassLoader newTCL = entry.getClassLoader();
/*      */ 
/*  875 */     ClassLoader oldTCL = TCLAction.UTIL.getContextClassLoader();
/*  876 */     boolean setCl = (newTCL != oldTCL) && (newTCL != null);
/*      */     try
/*      */     {
/*  879 */       if (setCl) {
/*  880 */         TCLAction.UTIL.setContextClassLoader(newTCL);
/*      */       }
/*  882 */       this.listeners.remove(entry.getObjectName(), (NotificationListener)this.registry.get(listener).getResourceInstance());
/*      */     }
/*      */     finally
/*      */     {
/*  886 */       if (setCl)
/*  887 */         TCLAction.UTIL.setContextClassLoader(oldTCL);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback)
/*      */     throws InstanceNotFoundException, ListenerNotFoundException
/*      */   {
/*  903 */     MBeanEntry entry = this.registry.get(name);
/*  904 */     if (!NotificationBroadcaster.class.isInstance(entry.getResourceInstance())) {
/*  905 */       throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + name + " exists but does not implement the NotificationBroadcaster interface."));
/*      */     }
/*  907 */     checkMBeanPermission(entry.getResourceClassName(), null, name, "removeNotificationListener");
/*      */ 
/*  910 */     ClassLoader newTCL = entry.getClassLoader();
/*      */ 
/*  912 */     ClassLoader oldTCL = TCLAction.UTIL.getContextClassLoader();
/*  913 */     boolean setCl = (newTCL != oldTCL) && (newTCL != null);
/*      */     try
/*      */     {
/*  916 */       if (setCl) {
/*  917 */         TCLAction.UTIL.setContextClassLoader(newTCL);
/*      */       }
/*  919 */       this.listeners.remove(entry.getObjectName(), listener, filter, handback);
/*      */     }
/*      */     finally
/*      */     {
/*  923 */       if (setCl)
/*  924 */         TCLAction.UTIL.setContextClassLoader(oldTCL);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback)
/*      */     throws InstanceNotFoundException, ListenerNotFoundException
/*      */   {
/*  940 */     MBeanEntry entry = this.registry.get(name);
/*  941 */     if (!NotificationBroadcaster.class.isInstance(entry.getResourceInstance())) {
/*  942 */       throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + name + " exists but does not implement the NotificationBroadcaster interface."));
/*      */     }
/*  944 */     MBeanEntry listenerEntry = this.registry.get(listener);
/*  945 */     if (!NotificationListener.class.isInstance(listenerEntry.getResourceInstance())) {
/*  946 */       throw new RuntimeOperationsException(new IllegalArgumentException("The MBean " + listener + " exists but does not implement the NotificationListener interface."));
/*      */     }
/*  948 */     checkMBeanPermission(entry.getResourceClassName(), null, name, "removeNotificationListener");
/*      */ 
/*  951 */     ClassLoader newTCL = entry.getClassLoader();
/*      */ 
/*  953 */     ClassLoader oldTCL = TCLAction.UTIL.getContextClassLoader();
/*  954 */     boolean setCl = (newTCL != oldTCL) && (newTCL != null);
/*      */     try
/*      */     {
/*  957 */       if (setCl) {
/*  958 */         TCLAction.UTIL.setContextClassLoader(newTCL);
/*      */       }
/*  960 */       this.listeners.remove(entry.getObjectName(), (NotificationListener)this.registry.get(listener).getResourceInstance(), filter, handback);
/*      */     }
/*      */     finally
/*      */     {
/*  965 */       if (setCl)
/*  966 */         TCLAction.UTIL.setContextClassLoader(oldTCL);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isInstanceOf(ObjectName name, String className)
/*      */     throws InstanceNotFoundException
/*      */   {
/*  974 */     MBeanEntry entry = this.registry.get(name);
/*  975 */     String mbeanClassName = entry.getResourceClassName();
/*  976 */     checkMBeanPermission(mbeanClassName, null, name, "isInstanceOf");
/*      */ 
/*  979 */     if (className.equals(mbeanClassName)) {
/*  980 */       return true;
/*      */     }
/*      */ 
/*  983 */     Class mbeanClass = null;
/*  984 */     Class testClass = null;
/*  985 */     ClassLoader cl = getClassLoaderFor(name);
/*      */     try
/*      */     {
/*  988 */       mbeanClass = cl.loadClass(mbeanClassName);
/*  989 */       testClass = cl.loadClass(className);
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  993 */       return false;
/*      */     }
/*      */ 
/*  998 */     return testClass.isAssignableFrom(mbeanClass);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public ObjectInputStream deserialize(ObjectName name, byte[] data)
/*      */     throws InstanceNotFoundException, OperationsException
/*      */   {
/*      */     try
/*      */     {
/* 1010 */       ClassLoader cl = getClassLoaderFor(name);
/* 1011 */       return new ObjectInputStreamWithClassLoader(new ByteArrayInputStream(data), cl);
/*      */     }
/*      */     catch (IOException e) {
/*      */     }
/* 1015 */     throw new OperationsException("I/O exception deserializing: " + e.getMessage());
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public ObjectInputStream deserialize(String className, byte[] data)
/*      */     throws OperationsException, ReflectionException
/*      */   {
/*      */     try
/*      */     {
/* 1027 */       Class c = getClassLoaderRepository().loadClass(className);
/* 1028 */       ClassLoader cl = c.getClassLoader();
/* 1029 */       return new ObjectInputStreamWithClassLoader(new ByteArrayInputStream(data), cl);
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/* 1033 */       throw new OperationsException("I/O exception deserializing: " + e.getMessage());
/*      */     }
/*      */     catch (ClassNotFoundException e) {
/*      */     }
/* 1037 */     throw new ReflectionException(e, "Class not found from default repository: " + className);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data)
/*      */     throws InstanceNotFoundException, OperationsException, ReflectionException
/*      */   {
/*      */     try
/*      */     {
/* 1050 */       ClassLoader cl = getClassLoader(loaderName);
/* 1051 */       return new ObjectInputStreamWithClassLoader(new ByteArrayInputStream(data), cl);
/*      */     }
/*      */     catch (IOException e) {
/*      */     }
/* 1055 */     throw new OperationsException("I/O exception deserializing: " + e.getMessage());
/*      */   }
/*      */ 
/*      */   public ClassLoader getClassLoaderFor(ObjectName name)
/*      */     throws InstanceNotFoundException
/*      */   {
/* 1062 */     MBeanEntry entry = this.registry.get(name);
/* 1063 */     checkMBeanPermission(entry.getResourceClassName(), null, name, "getClassLoaderFor");
/*      */ 
/* 1066 */     ClassLoader cl = entry.getClassLoader();
/* 1067 */     if (cl == null)
/* 1068 */       cl = entry.getResourceInstance().getClass().getClassLoader();
/* 1069 */     if (cl == null)
/* 1070 */       cl = ClassLoader.getSystemClassLoader();
/* 1071 */     return cl;
/*      */   }
/*      */ 
/*      */   public ClassLoader getClassLoader(ObjectName name)
/*      */     throws InstanceNotFoundException
/*      */   {
/* 1084 */     Object loader = null;
/* 1085 */     if (name == null)
/*      */     {
/* 1087 */       checkMBeanPermission(null, null, name, "getClassLoader");
/* 1088 */       loader = getClass().getClassLoader();
/* 1089 */       if (loader == null)
/* 1090 */         loader = ClassLoader.getSystemClassLoader();
/*      */     }
/*      */     else
/*      */     {
/* 1094 */       MBeanEntry entry = this.registry.get(name);
/* 1095 */       checkMBeanPermission(entry.getResourceClassName(), null, name, "getClassLoader");
/*      */ 
/* 1097 */       loader = entry.getResourceInstance();
/*      */     }
/*      */ 
/* 1100 */     if (!(loader instanceof ClassLoader))
/* 1101 */       throw new InstanceNotFoundException("Not a classloader " + name);
/* 1102 */     return (ClassLoader)loader;
/*      */   }
/*      */ 
/*      */   public ClassLoaderRepository getClassLoaderRepository()
/*      */   {
/* 1112 */     checkMBeanPermission(null, null, null, "getClassLoaderRepository");
/*      */ 
/* 1115 */     if (this.classLoaderRepository == null)
/*      */     {
/* 1117 */       ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 1118 */       String className = PropertyAccess.getProperty("jbossmx.loader.repository.class", "org.jboss.mx.loading.UnifiedLoaderRepository3");
/* 1119 */       PropertyAccess.setProperty("jbossmx.loader.repository.class", className);
/*      */       try
/*      */       {
/* 1123 */         Class repository = cl.loadClass(className);
/* 1124 */         this.classLoaderRepository = ((LoaderRepository)repository.newInstance());
/*      */       }
/*      */       catch (ClassNotFoundException e)
/*      */       {
/* 1128 */         throw new Error("Cannot instantiate loader repository class: " + className);
/*      */       }
/*      */       catch (ClassCastException e)
/*      */       {
/* 1132 */         throw new Error("Loader repository is not an instance of LoaderRepository: " + className);
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/* 1136 */         throw new Error("Error creating loader repository: " + e);
/*      */       }
/*      */     }
/*      */ 
/* 1140 */     return this.classLoaderRepository;
/*      */   }
/*      */ 
/*      */   public void releaseServer()
/*      */   {
/* 1160 */     this.registry.releaseRegistry();
/* 1161 */     this.listeners.removeAll();
/* 1162 */     this.listeners = null;
/* 1163 */     this.registry = null;
/*      */   }
/*      */ 
/*      */   protected Object instantiate(String className, ClassLoader cl, Object[] params, String[] signature)
/*      */     throws ReflectionException, MBeanException
/*      */   {
/* 1186 */     if (className == null) {
/* 1187 */       throw new RuntimeOperationsException(new IllegalArgumentException("Null className"));
/*      */     }
/* 1189 */     if (className.equals("")) {
/* 1190 */       throw new ReflectionException(new ClassNotFoundException("empty class name"));
/*      */     }
/* 1192 */     if (params == null) {
/* 1193 */       params = NOPARAMS;
/*      */     }
/* 1195 */     if (signature == null) {
/* 1196 */       signature = NOSIG;
/*      */     }
/* 1198 */     checkMBeanPermission(className, null, null, "instantiate");
/*      */ 
/* 1200 */     ClassLoader oldTCL = TCLAction.UTIL.getContextClassLoader();
/*      */ 
/* 1202 */     boolean setCl = false;
/*      */     try
/*      */     {
/* 1205 */       Class clazz = null;
/* 1206 */       if (cl != null)
/*      */       {
/* 1208 */         if (cl != oldTCL)
/*      */         {
/* 1210 */           setCl = true;
/* 1211 */           TCLAction.UTIL.setContextClassLoader(cl);
/*      */         }
/* 1213 */         clazz = cl.loadClass(className);
/*      */       }
/*      */       else {
/* 1216 */         clazz = this.classLoaderRepository.loadClass(className);
/*      */       }
/* 1218 */       sign = new Class[signature.length];
/* 1219 */       for (int i = 0; i < signature.length; i++)
/*      */       {
/* 1221 */         if (LoaderRepository.getNativeClassForName(signature[i]) == null)
/*      */         {
/*      */           try
/*      */           {
/* 1225 */             if (cl != null)
/* 1226 */               sign[i] = cl.loadClass(signature[i]);
/*      */             else
/* 1228 */               sign[i] = this.classLoaderRepository.loadClass(signature[i]);
/*      */           }
/*      */           catch (ClassNotFoundException e)
/*      */           {
/* 1232 */             throw new ReflectionException(e, "Constructor parameter class not found: " + signature[i]);
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/* 1237 */           sign[i] = LoaderRepository.getNativeClassForName(signature[i]);
/*      */         }
/*      */       }
/*      */ 
/* 1241 */       Constructor constructor = clazz.getConstructor(sign);
/* 1242 */       e = constructor.newInstance(params);
/*      */       return e;
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1246 */       handleInstantiateExceptions(t, className);
/* 1247 */       log.error("Unhandled exception instantiating class: " + className, t);
/* 1248 */       Class[] sign = null;
/*      */       return sign;
/*      */     }
/*      */     finally
/*      */     {
/* 1252 */       if (setCl)
/* 1253 */         TCLAction.UTIL.setContextClassLoader(oldTCL); 
/* 1253 */     }throw localObject;
/*      */   }
/*      */ 
/*      */   protected void handleInstantiateExceptions(Throwable t, String className)
/*      */     throws ReflectionException, MBeanException
/*      */   {
/* 1263 */     if ((t instanceof ReflectionException)) {
/* 1264 */       throw ((ReflectionException)t);
/*      */     }
/* 1266 */     if ((t instanceof ClassNotFoundException)) {
/* 1267 */       throw new ReflectionException((Exception)t, "Class not found: " + className);
/*      */     }
/* 1269 */     if ((t instanceof InstantiationException)) {
/* 1270 */       throw new ReflectionException((Exception)t, "Cannot instantiate: " + className);
/*      */     }
/* 1272 */     if ((t instanceof IllegalAccessException)) {
/* 1273 */       throw new ReflectionException((Exception)t, "Illegal access to constructor: " + className);
/*      */     }
/* 1275 */     if ((t instanceof NoSuchMethodException)) {
/* 1276 */       throw new ReflectionException((Exception)t, "Cannot find such a public constructor: " + className);
/*      */     }
/* 1278 */     if ((t instanceof SecurityException)) {
/* 1279 */       throw new ReflectionException((Exception)t, "Can't access constructor for " + className);
/*      */     }
/* 1281 */     if ((t instanceof InvocationTargetException))
/*      */     {
/* 1283 */       Throwable root = ((InvocationTargetException)t).getTargetException();
/*      */ 
/* 1285 */       if ((root instanceof RuntimeException))
/* 1286 */         throw new RuntimeMBeanException((RuntimeException)root, className + " constructor has thrown an exception: " + root.toString());
/* 1287 */       if ((root instanceof Error))
/* 1288 */         throw new RuntimeErrorException((Error)root, className + " constructor has thrown an error: " + root.toString());
/* 1289 */       if ((root instanceof Exception)) {
/* 1290 */         throw new MBeanException((Exception)root, className + " constructor has thrown an exception: " + root.toString());
/*      */       }
/* 1292 */       throw new Error("Something went wrong with handling the exception from " + className + " default constructor.");
/*      */     }
/*      */ 
/* 1295 */     if ((t instanceof ExceptionInInitializerError))
/*      */     {
/* 1297 */       Throwable root = ((ExceptionInInitializerError)t).getException();
/*      */ 
/* 1300 */       if ((root instanceof RuntimeException)) {
/* 1301 */         throw new RuntimeMBeanException((RuntimeException)root, "Exception in class " + className + " static initializer: " + root.toString());
/*      */       }
/*      */ 
/* 1304 */       throw new Error("ERROR: it turns out the root cause is not always a runtime exception!");
/*      */     }
/*      */ 
/* 1307 */     if ((t instanceof IllegalArgumentException))
/*      */     {
/* 1310 */       throw new Error("Error in the server: mismatch between expected constructor arguments and supplied arguments.");
/*      */     }
/*      */ 
/* 1313 */     if ((t instanceof Error))
/*      */     {
/* 1315 */       throw new RuntimeErrorException((Error)t, "instantiating " + className + " failed: " + t.toString());
/*      */     }
/*      */   }
/*      */ 
/*      */   protected ObjectInstance registerMBean(Object mbean, ObjectName name, ObjectName loaderName)
/*      */     throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException
/*      */   {
/* 1338 */     ClassLoader cl = null;
/*      */ 
/* 1341 */     if (loaderName == null)
/*      */     {
/* 1343 */       cl = getClass().getClassLoader();
/* 1344 */       if (cl == null)
/* 1345 */         cl = ClassLoader.getSystemClassLoader();
/*      */     }
/*      */     else
/*      */     {
/*      */       try
/*      */       {
/* 1351 */         cl = (ClassLoader)this.registry.get(loaderName).getResourceInstance();
/*      */       }
/*      */       catch (ClassCastException e)
/*      */       {
/* 1355 */         throw new ReflectionException(e, loaderName + " is not a class loader.");
/*      */       }
/*      */     }
/*      */ 
/* 1359 */     return registerMBean(mbean, name, cl);
/*      */   }
/*      */ 
/*      */   protected ObjectInstance registerMBean(Object object, ObjectName name, ClassLoader cl)
/*      */     throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException
/*      */   {
/* 1382 */     Class objectClass = object.getClass();
/* 1383 */     String className = objectClass.getName();
/*      */ 
/* 1386 */     checkMBeanPermission(className, null, name, "registerMBean");
/*      */ 
/* 1389 */     if (System.getSecurityManager() != null)
/*      */     {
/* 1391 */       ProtectionDomain pd = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(objectClass)
/*      */       {
/*      */         public Object run()
/*      */         {
/* 1396 */           return this.val$objectClass.getProtectionDomain();
/*      */         }
/*      */       });
/* 1400 */       if (pd != null)
/*      */       {
/* 1402 */         MBeanTrustPermission p = new MBeanTrustPermission("register");
/* 1403 */         if (!pd.implies(p))
/*      */         {
/* 1405 */           String msg = "MBeanTrustPermission(register) not implied by protection domain of mbean class: " + className + ", pd: " + pd;
/*      */ 
/* 1407 */           throw new SecurityException(msg);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1412 */     HashMap valueMap = null;
/* 1413 */     if (cl != null)
/*      */     {
/* 1415 */       valueMap = new HashMap();
/* 1416 */       valueMap.put("org.jboss.mx.classloader", cl);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1421 */       Object[] args = { object, name, valueMap };
/* 1422 */       String[] sig = { Object.class.getName(), ObjectName.class.getName(), Map.class.getName() };
/*      */       try
/*      */       {
/* 1426 */         ObjectInstance oi = (ObjectInstance)AccessController.doPrivileged(new PrivilegedExceptionAction(args, sig)
/*      */         {
/*      */           public Object run()
/*      */             throws Exception
/*      */           {
/* 1431 */             return MBeanServerImpl.this.invoke(new ObjectName("JMImplementation:type=MBeanRegistry"), "registerMBean", this.val$args, this.val$sig);
/*      */           }
/*      */         });
/* 1436 */         return oi;
/*      */       }
/*      */       catch (PrivilegedActionException e)
/*      */       {
/* 1440 */         throw e.getException();
/*      */       }
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/* 1445 */       Throwable result = JMXExceptionDecoder.decodeToJMXException(t);
/* 1446 */       if ((result instanceof InstanceAlreadyExistsException))
/* 1447 */         throw ((InstanceAlreadyExistsException)result);
/* 1448 */       if ((result instanceof MBeanRegistrationException))
/* 1449 */         throw ((MBeanRegistrationException)result);
/* 1450 */       if ((result instanceof NotCompliantMBeanException))
/* 1451 */         throw ((NotCompliantMBeanException)result);
/* 1452 */       if ((result instanceof JMRuntimeException))
/* 1453 */         throw ((JMRuntimeException)result);
/* 1454 */       if ((result instanceof MBeanException))
/*      */       {
/* 1456 */         MBeanException e = (MBeanException)result;
/* 1457 */         t = e.getTargetException();
/* 1458 */         if ((t instanceof InstanceAlreadyExistsException))
/* 1459 */           throw ((InstanceAlreadyExistsException)t);
/* 1460 */         if ((t instanceof MBeanRegistrationException))
/* 1461 */           throw ((MBeanRegistrationException)t);
/* 1462 */         if ((t instanceof NotCompliantMBeanException))
/* 1463 */           throw ((NotCompliantMBeanException)t);
/*      */       }
/* 1465 */       if ((result instanceof RuntimeException))
/* 1466 */         throw new RuntimeMBeanException((RuntimeException)result);
/* 1467 */       if ((result instanceof Error)) {
/* 1468 */         throw new RuntimeErrorException((Error)result);
/*      */       }
/*      */     }
/* 1471 */     throw new MBeanRegistrationException(new InvocationTargetException(t), "Cannot register MBean");
/*      */   }
/*      */ 
/*      */   protected boolean queryMBean(ObjectName objectName, QueryExp queryExp)
/*      */   {
/* 1487 */     if (queryExp == null) {
/* 1488 */       return true;
/*      */     }
/*      */     try
/*      */     {
/* 1492 */       return queryExp.apply(objectName);
/*      */     }
/*      */     catch (Exception e) {
/*      */     }
/* 1496 */     return false;
/*      */   }
/*      */ 
/*      */   protected MBeanRegistry createRegistry(String defaultDomain)
/*      */   {
/* 1506 */     String registryClass = PropertyAccess.getProperty("jbossmx.mbean.registry.class", "org.jboss.mx.server.registry.BasicMBeanRegistry");
/*      */     try
/*      */     {
/* 1512 */       ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 1513 */       Class clazz = cl.loadClass(registryClass);
/*      */ 
/* 1516 */       Constructor constructor = clazz.getConstructor(new Class[] { ModelMBeanConstants.class, String.class, ClassLoaderRepository.class });
/*      */ 
/* 1519 */       return (MBeanRegistry)constructor.newInstance(new Object[] { this.outer, defaultDomain, this.classLoaderRepository });
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/* 1525 */       throw new NestedRuntimeException("The MBean registry implementation class " + registryClass + " was not found: ", e);
/*      */     }
/*      */     catch (NoSuchMethodException e)
/*      */     {
/* 1530 */       throw new NestedRuntimeException("The MBean registry implementation class " + registryClass + " must contain a default <init>(MBeanServer srvr, String domain) " + " constructor.", e);
/*      */     }
/*      */     catch (InstantiationException e)
/*      */     {
/* 1536 */       throw new NestedRuntimeException("Cannot instantiate class " + registryClass + ": ", e);
/*      */     }
/*      */     catch (IllegalAccessException e)
/*      */     {
/* 1540 */       throw new NestedRuntimeException("Unable to create the MBean registry instance. Illegal access to class " + registryClass + " constructor: ", e);
/*      */     }
/*      */     catch (InvocationTargetException e)
/*      */     {
/*      */     }
/* 1545 */     throw new NestedRuntimeException("Unable to create the MBean registry instance. Class " + registryClass + " has raised an exception in constructor: ", e.getTargetException());
/*      */   }
/*      */ 
/*      */   private ModelMBeanInfo getRegistryManagementInterface()
/*      */   {
/* 1556 */     boolean READABLE = true;
/* 1557 */     boolean WRITABLE = true;
/* 1558 */     boolean BOOLEAN = true;
/*      */ 
/* 1561 */     DescriptorSupport descDefaultDomain = new DescriptorSupport();
/* 1562 */     descDefaultDomain.setField("name", "DefaultDomain");
/* 1563 */     descDefaultDomain.setField("descriptorType", "attribute");
/* 1564 */     descDefaultDomain.setField("displayName", "Default Domain");
/* 1565 */     descDefaultDomain.setField("default", getDefaultDomain());
/* 1566 */     descDefaultDomain.setField("currencyTimeLimit", "-1");
/* 1567 */     ModelMBeanAttributeInfo defaultDomainInfo = new ModelMBeanAttributeInfo("DefaultDomain", String.class.getName(), "The domain to use when an object name has no domain", true, false, false, descDefaultDomain);
/*      */ 
/* 1575 */     DescriptorSupport descSize = new DescriptorSupport();
/* 1576 */     descSize.setField("name", "Size");
/* 1577 */     descSize.setField("descriptorType", "attribute");
/* 1578 */     descSize.setField("displayName", "Size");
/* 1579 */     descSize.setField("getMethod", "getSize");
/* 1580 */     ModelMBeanAttributeInfo sizeInfo = new ModelMBeanAttributeInfo("Size", Integer.TYPE.getName(), "The number of MBeans registered in the MBean Server", true, false, false, descSize);
/*      */ 
/* 1588 */     DescriptorSupport descRegisterMBean = new DescriptorSupport();
/* 1589 */     descRegisterMBean.setField("name", "registerMBean");
/* 1590 */     descRegisterMBean.setField("descriptorType", "operation");
/* 1591 */     descRegisterMBean.setField("role", "operation");
/* 1592 */     MBeanParameterInfo[] registerMBeanParms = { new MBeanParameterInfo("Resource", Object.class.getName(), "A compliant MBean to be registered in the MBean Server"), new MBeanParameterInfo("ObjectName", ObjectName.class.getName(), "The object name of the MBean"), new MBeanParameterInfo("ValueMap", Map.class.getName(), "Values associated with the registration") };
/*      */ 
/* 1608 */     ModelMBeanOperationInfo registerMBeanInfo = new ModelMBeanOperationInfo("registerMBean", "Adds an MBean in the MBeanServer", registerMBeanParms, ObjectInstance.class.getName(), 2, descRegisterMBean);
/*      */ 
/* 1618 */     DescriptorSupport descUnregisterMBean = new DescriptorSupport();
/* 1619 */     descUnregisterMBean.setField("name", "unregisterMBean");
/* 1620 */     descUnregisterMBean.setField("descriptorType", "operation");
/* 1621 */     descUnregisterMBean.setField("role", "operation");
/* 1622 */     MBeanParameterInfo[] unregisterMBeanParms = { new MBeanParameterInfo("ObjectName", ObjectName.class.getName(), "The object name of the MBean to remove") };
/*      */ 
/* 1630 */     ModelMBeanOperationInfo unregisterMBeanInfo = new ModelMBeanOperationInfo("unregisterMBean", "Removes an MBean from the MBeanServer", unregisterMBeanParms, Void.TYPE.getName(), 1, descUnregisterMBean);
/*      */ 
/* 1640 */     DescriptorSupport descGetSize = new DescriptorSupport();
/* 1641 */     descGetSize.setField("name", "getSize");
/* 1642 */     descGetSize.setField("descriptorType", "operation");
/* 1643 */     descGetSize.setField("role", "getter");
/* 1644 */     MBeanParameterInfo[] getSizeParms = new MBeanParameterInfo[0];
/* 1645 */     ModelMBeanOperationInfo getSizeInfo = new ModelMBeanOperationInfo("getSize", "Gets the number of MBeans registered", getSizeParms, Integer.TYPE.getName(), 0, descGetSize);
/*      */ 
/* 1655 */     DescriptorSupport descGet = new DescriptorSupport();
/* 1656 */     descGet.setField("name", "get");
/* 1657 */     descGet.setField("descriptorType", "operation");
/* 1658 */     descGet.setField("role", "operation");
/* 1659 */     MBeanParameterInfo[] getParam = new MBeanParameterInfo[1];
/* 1660 */     getParam[0] = new MBeanParameterInfo("ObjectName", ObjectName.class.getName(), "object name to find");
/* 1661 */     ModelMBeanOperationInfo getInfo = new ModelMBeanOperationInfo("get", "Gets the MBeanEntry for a given ObjectName", getParam, MBeanEntry.class.getName(), 0, descGet);
/*      */ 
/* 1671 */     DescriptorSupport descGetValue = new DescriptorSupport();
/* 1672 */     descGetValue.setField("name", "getValue");
/* 1673 */     descGetValue.setField("descriptorType", "operation");
/* 1674 */     descGetValue.setField("role", "operation");
/* 1675 */     MBeanParameterInfo[] getValueParms = { new MBeanParameterInfo("ObjectName", ObjectName.class.getName(), "The object name of the registered MBean"), new MBeanParameterInfo("Key", String.class.getName(), "The key to the value stored") };
/*      */ 
/* 1686 */     ModelMBeanOperationInfo getValueInfo = new ModelMBeanOperationInfo("getValue", "Get a value stored in the MBean's registration", getValueParms, Object.class.getName(), 0, descGetValue);
/*      */ 
/* 1696 */     DescriptorSupport descMBean = new DescriptorSupport();
/* 1697 */     descMBean.setField("name", RequiredModelMBeanInstantiator.getClassName());
/* 1698 */     descMBean.setField("descriptorType", "MBean");
/* 1699 */     descMBean.setField("displayName", "MBeanServer Registry");
/* 1700 */     ModelMBeanAttributeInfo[] attrInfo = { defaultDomainInfo, sizeInfo };
/*      */ 
/* 1705 */     ModelMBeanConstructorInfo[] ctorInfo = null;
/* 1706 */     ModelMBeanOperationInfo[] opInfo = { registerMBeanInfo, unregisterMBeanInfo, getSizeInfo, getValueInfo, getInfo };
/*      */ 
/* 1714 */     ModelMBeanNotificationInfo[] notifyInfo = null;
/* 1715 */     ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(RequiredModelMBeanInstantiator.getClassName(), "Managed Bean Registry", attrInfo, ctorInfo, opInfo, notifyInfo, descMBean);
/*      */ 
/* 1724 */     return info;
/*      */   }
/*      */ 
/*      */   private void checkMBeanPermission(String className, String member, ObjectName objectName, String action)
/*      */   {
/* 1730 */     SecurityManager sm = System.getSecurityManager();
/* 1731 */     if (sm != null)
/*      */     {
/* 1733 */       MBeanPermission p = new MBeanPermission(className, member, objectName, action);
/*      */ 
/* 1735 */       sm.checkPermission(p);
/*      */     }
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/* 1746 */     return super.toString() + "[ defaultDomain='" + getDefaultDomain() + "' ]";
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.server.MBeanServerImpl
 * JD-Core Version:    0.6.0
 */