/*     */ package org.jboss.mx.server;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import javax.management.Descriptor;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.modelmbean.ModelMBeanAttributeInfo;
/*     */ 
/*     */ public class MethodMapper
/*     */ {
/*  48 */   private HashMap map = null;
/*     */ 
/*     */   public static String getterSignature(MBeanAttributeInfo info)
/*     */   {
/*  57 */     if (null == info)
/*     */     {
/*  59 */       throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
/*     */     }
/*     */ 
/*  62 */     String sig = null;
/*  63 */     if ((info instanceof ModelMBeanAttributeInfo))
/*     */     {
/*  65 */       ModelMBeanAttributeInfo minfo = (ModelMBeanAttributeInfo)info;
/*  66 */       Descriptor desc = minfo.getDescriptor();
/*  67 */       String methodName = (String)desc.getFieldValue("getMethod");
/*  68 */       if (methodName != null)
/*  69 */         sig = methodSignature(info.getType(), methodName, null);
/*     */     }
/*  71 */     if (sig == null)
/*     */     {
/*  73 */       String prefix = info.isIs() ? "is" : "get";
/*  74 */       sig = methodSignature(info.getType(), prefix + info.getName(), null);
/*     */     }
/*  76 */     return sig;
/*     */   }
/*     */ 
/*     */   public static String setterSignature(MBeanAttributeInfo info)
/*     */   {
/*  84 */     if (null == info)
/*     */     {
/*  86 */       throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
/*     */     }
/*     */ 
/*  89 */     String sig = null;
/*  90 */     if ((info instanceof ModelMBeanAttributeInfo))
/*     */     {
/*  92 */       ModelMBeanAttributeInfo minfo = (ModelMBeanAttributeInfo)info;
/*  93 */       Descriptor desc = minfo.getDescriptor();
/*  94 */       String methodName = (String)desc.getFieldValue("setMethod");
/*  95 */       String[] typeSig = { info.getType() };
/*  96 */       if (methodName != null)
/*  97 */         sig = methodSignature(Void.TYPE.getName(), methodName, typeSig);
/*     */     }
/*  99 */     if (sig == null)
/*     */     {
/* 101 */       String[] typeSig = { info.getType() };
/* 102 */       sig = methodSignature(Void.TYPE.getName(), "set" + info.getName(), typeSig);
/*     */     }
/* 104 */     return sig;
/*     */   }
/*     */ 
/*     */   public static String operationSignature(MBeanOperationInfo info)
/*     */   {
/* 112 */     if (null == info)
/*     */     {
/* 114 */       throw new IllegalArgumentException("MBeanOperationInfo cannot be null");
/*     */     }
/*     */ 
/* 117 */     MBeanParameterInfo[] params = info.getSignature();
/* 118 */     String[] signature = new String[params.length];
/* 119 */     for (int i = 0; i < signature.length; i++)
/*     */     {
/* 121 */       signature[i] = params[i].getType();
/*     */     }
/* 123 */     return methodSignature(info.getReturnType(), info.getName(), signature);
/*     */   }
/*     */ 
/*     */   public static String methodSignature(Method method)
/*     */   {
/* 131 */     if (null == method)
/*     */     {
/* 133 */       throw new IllegalArgumentException("Method cannot be null");
/*     */     }
/*     */ 
/* 136 */     Class[] paramtypes = method.getParameterTypes();
/* 137 */     String[] signature = new String[paramtypes.length];
/* 138 */     for (int i = 0; i < signature.length; i++)
/*     */     {
/* 140 */       signature[i] = paramtypes[i].getName();
/*     */     }
/* 142 */     return methodSignature(method.getReturnType().getName(), method.getName(), signature);
/*     */   }
/*     */ 
/*     */   public static String methodSignature(String returnType, String name, String[] signature)
/*     */   {
/* 150 */     if (null == returnType)
/*     */     {
/* 152 */       throw new IllegalArgumentException("returnType cannot be null");
/*     */     }
/* 154 */     if (null == name)
/*     */     {
/* 156 */       throw new IllegalArgumentException("method name cannot be null");
/*     */     }
/*     */ 
/* 159 */     StringBuffer buf = new StringBuffer(returnType).append(';').append(name);
/* 160 */     if (null == signature)
/*     */     {
/* 162 */       return buf.toString();
/*     */     }
/*     */ 
/* 165 */     for (int i = 0; i < signature.length; i++)
/*     */     {
/* 167 */       buf.append(';').append(signature[i]);
/*     */     }
/*     */ 
/* 170 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   public static Method lookupOperation(MBeanOperationInfo info, Object mbean)
/*     */   {
/* 181 */     Class mbeanClass = mbean.getClass();
/* 182 */     Method m = null;
/*     */     try
/*     */     {
/* 185 */       ClassLoader loader = mbeanClass.getClassLoader();
/* 186 */       MBeanParameterInfo[] params = info.getSignature();
/* 187 */       Class[] signature = new Class[params.length];
/* 188 */       for (int i = 0; i < signature.length; i++)
/*     */       {
/* 190 */         Class type = loader.loadClass(params[i].getType());
/* 191 */         signature[i] = type;
/*     */       }
/* 193 */       m = mbeanClass.getMethod(info.getName(), signature);
/*     */ 
/* 195 */       if (Object.class.equals(m.getDeclaringClass())) {
/* 196 */         m = null;
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/* 202 */     return m;
/*     */   }
/*     */ 
/*     */   public MethodMapper(Class resourceClass)
/*     */   {
/* 212 */     this.map = createMap(resourceClass);
/*     */   }
/*     */ 
/*     */   public Method lookupOperation(MBeanOperationInfo info)
/*     */   {
/* 223 */     if (null == info)
/*     */     {
/* 225 */       throw new IllegalArgumentException("MBeanOperationInfo cannot be null");
/*     */     }
/*     */ 
/* 228 */     return (Method)this.map.get(operationSignature(info));
/*     */   }
/*     */ 
/*     */   public Method lookupGetter(MBeanAttributeInfo info)
/*     */   {
/* 236 */     if (null == info)
/*     */     {
/* 238 */       throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
/*     */     }
/*     */ 
/* 241 */     return (Method)this.map.get(getterSignature(info));
/*     */   }
/*     */ 
/*     */   public Method lookupSetter(MBeanAttributeInfo info)
/*     */   {
/* 249 */     if (null == info)
/*     */     {
/* 251 */       throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
/*     */     }
/*     */ 
/* 254 */     return (Method)this.map.get(setterSignature(info));
/*     */   }
/*     */ 
/*     */   public Method lookupMethod(String returnType, String name, String[] signature)
/*     */   {
/* 262 */     if (null == returnType)
/*     */     {
/* 264 */       throw new IllegalArgumentException("returnType cannot be null");
/*     */     }
/*     */ 
/* 267 */     if (null == name)
/*     */     {
/* 269 */       throw new IllegalArgumentException("method name cannot be null");
/*     */     }
/*     */ 
/* 272 */     return (Method)this.map.get(methodSignature(returnType, name, signature));
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 277 */     return this.map.toString();
/*     */   }
/*     */ 
/*     */   protected HashMap createMap(Class resourceClass)
/*     */   {
/* 287 */     HashMap cmap = new HashMap();
/* 288 */     if (resourceClass != null)
/*     */     {
/* 290 */       Method[] methods = resourceClass.getMethods();
/* 291 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/* 293 */         Method method = methods[i];
/* 294 */         cmap.put(methodSignature(method), method);
/*     */       }
/*     */     }
/* 297 */     return cmap;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.server.MethodMapper
 * JD-Core Version:    0.6.0
 */