/*     */ package org.jboss.mx.server;
/*     */ 
/*     */ import javax.management.MBeanServerBuilder;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.mx.standardmbean.StandardMBeanDelegateFactory;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ import org.jboss.util.Classes;
/*     */ 
/*     */ public abstract class ServerConfig
/*     */ {
/*     */   private static ServerConfig instance;
/*     */   private static final String JMI_DOMAIN = "JMImplementation";
/*     */   private static final String DEFAULT_DOMAIN = "DefaultDomain";
/*  55 */   private static final ObjectName mbeanServerDelegateName = ObjectNameFactory.create("JMImplementation:type=MBeanServerDelegate");
/*     */   public static final String SERVER_CONFIG_CLASS_PROPERTY = "jbossmx.server.config.class";
/*     */   public static final String DEFAULT_SERVER_CONFIG_CLASS = "org.jboss.mx.server.JBossMXServerConfig";
/*     */   public static final String MBEAN_SERVER_BUILDER_CLASS_PROPERTY = "javax.management.builder.initial";
/*     */ 
/*     */   public static synchronized ServerConfig getInstance()
/*     */   {
/*  72 */     if (instance != null)
/*  73 */       return instance;
/*  74 */     instance = (ServerConfig)Classes.instantiate(ServerConfig.class, "jbossmx.server.config.class", "org.jboss.mx.server.JBossMXServerConfig");
/*  75 */     return instance;
/*     */   }
/*     */ 
/*     */   public String getDefaultDomain()
/*     */   {
/*  96 */     return "DefaultDomain";
/*     */   }
/*     */ 
/*     */   public String getJMIDomain()
/*     */   {
/* 106 */     return "JMImplementation";
/*     */   }
/*     */ 
/*     */   public ObjectName getMBeanServerDelegateName()
/*     */   {
/* 116 */     return mbeanServerDelegateName;
/*     */   }
/*     */ 
/*     */   public MBeanServerBuilder getMBeanServerBuilder()
/*     */   {
/* 126 */     String defaultMBeanServerBuilder = getDefaultMBeanServerBuilderClassName();
/* 127 */     return (MBeanServerBuilder)Classes.instantiate(MBeanServerBuilder.class, "javax.management.builder.initial", defaultMBeanServerBuilder);
/*     */   }
/*     */ 
/*     */   public abstract ObjectName getLoaderRepositoryName();
/*     */ 
/*     */   public abstract StandardMBeanDelegateFactory getStandardMBeanDelegateFactory();
/*     */ 
/*     */   protected abstract String getDefaultMBeanServerBuilderClassName();
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.server.ServerConfig
 * JD-Core Version:    0.6.0
 */