package org.jboss.mx.server.registry;

import java.util.List;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public abstract interface MBeanRegistry
{
  public abstract ObjectInstance registerMBean(Object paramObject, ObjectName paramObjectName, Map paramMap)
    throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException;

  public abstract void unregisterMBean(ObjectName paramObjectName)
    throws InstanceNotFoundException, MBeanRegistrationException;

  public abstract MBeanEntry get(ObjectName paramObjectName)
    throws InstanceNotFoundException;

  public abstract String getDefaultDomain();

  public abstract String[] getDomains();

  public abstract ObjectInstance getObjectInstance(ObjectName paramObjectName)
    throws InstanceNotFoundException;

  public abstract Object getValue(ObjectName paramObjectName, String paramString)
    throws InstanceNotFoundException;

  public abstract boolean contains(ObjectName paramObjectName);

  public abstract List findEntries(ObjectName paramObjectName);

  public abstract int getSize();

  public abstract void releaseRegistry();
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.server.registry.MBeanRegistry
 * JD-Core Version:    0.6.0
 */