/*     */ package org.jboss.mx.standardmbean;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Iterator;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.JMException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.NotCompliantMBeanException;
/*     */ import javax.management.ReflectionException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.loading.LoaderRepository;
/*     */ import org.jboss.mx.metadata.StandardMetaData;
/*     */ import org.jboss.mx.server.ExceptionHandler;
/*     */ 
/*     */ public class StandardMBeanImpl
/*     */   implements StandardMBeanDelegate
/*     */ {
/*  57 */   private static final Logger log = Logger.getLogger(StandardMBeanImpl.class);
/*     */   private Object implementation;
/*     */   private Class mbeanInterface;
/*     */   private MBeanInfo cachedMBeanInfo;
/*     */ 
/*     */   public StandardMBeanImpl(Object implementation, Class mbeanInterface)
/*     */     throws NotCompliantMBeanException
/*     */   {
/*  92 */     this.implementation = implementation;
/*  93 */     this.mbeanInterface = mbeanInterface;
/*     */   }
/*     */ 
/*     */   protected StandardMBeanImpl(Class mbeanInterface)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 110 */     this.implementation = this;
/* 111 */     this.mbeanInterface = mbeanInterface;
/*     */   }
/*     */ 
/*     */   public Object getImplementation()
/*     */   {
/* 121 */     return this.implementation;
/*     */   }
/*     */ 
/*     */   public void setImplementation(Object implementation)
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 137 */     if (implementation == null)
/* 138 */       throw new IllegalArgumentException("Null implementation");
/* 139 */     this.implementation = implementation;
/*     */   }
/*     */ 
/*     */   public Class getImplementationClass()
/*     */   {
/* 149 */     return this.implementation.getClass();
/*     */   }
/*     */ 
/*     */   public final Class getMBeanInterface()
/*     */   {
/* 159 */     return this.mbeanInterface;
/*     */   }
/*     */ 
/*     */   public Object getAttribute(String attribute)
/*     */     throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/*     */     try
/*     */     {
/* 167 */       Method method = this.implementation.getClass().getMethod("get" + attribute, null);
/* 168 */       return method.invoke(this.implementation, new Object[0]);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 172 */       JMException result = ExceptionHandler.handleException(e);
/* 173 */       if ((result instanceof AttributeNotFoundException))
/* 174 */         throw ((AttributeNotFoundException)result);
/* 175 */       if ((result instanceof MBeanException))
/* 176 */         throw ((MBeanException)result);
/* 177 */       if ((result instanceof ReflectionException))
/* 178 */         throw ((ReflectionException)result); 
/*     */     }
/* 179 */     throw new MBeanException(e, "Cannot get attribute: " + attribute);
/*     */   }
/*     */ 
/*     */   public void setAttribute(Attribute attribute)
/*     */     throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */   {
/*     */     try
/*     */     {
/* 188 */       Class[] clArr = null;
/* 189 */       if (attribute.getValue() != null)
/*     */       {
/* 191 */         clArr = new Class[] { attribute.getValue().getClass() };
/*     */       }
/* 193 */       Method method = this.implementation.getClass().getMethod("set" + attribute.getName(), clArr);
/* 194 */       method.invoke(this.implementation, new Object[] { attribute.getValue() });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 198 */       JMException result = ExceptionHandler.handleException(e);
/* 199 */       if ((result instanceof AttributeNotFoundException))
/* 200 */         throw ((AttributeNotFoundException)result);
/* 201 */       if ((result instanceof InvalidAttributeValueException))
/* 202 */         throw ((InvalidAttributeValueException)result);
/* 203 */       if ((result instanceof MBeanException))
/* 204 */         throw ((MBeanException)result);
/* 205 */       if ((result instanceof ReflectionException))
/* 206 */         throw ((ReflectionException)result);
/* 207 */       throw new MBeanException(e, "Cannot set attribute: " + attribute);
/*     */     }
/*     */   }
/*     */ 
/*     */   public AttributeList getAttributes(String[] attributes) {
/*     */     JMException result;
/*     */     try {
/* 215 */       AttributeList attrList = new AttributeList(attributes.length);
/* 216 */       for (int i = 0; i < attributes.length; i++)
/*     */       {
/* 218 */         String name = attributes[i];
/* 219 */         Object value = getAttribute(name);
/* 220 */         attrList.add(new Attribute(name, value));
/*     */       }
/* 222 */       return attrList;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 226 */       result = ExceptionHandler.handleException(e);
/*     */     }
/* 228 */     throw new RuntimeException("Cannot get attributes", result);
/*     */   }
/*     */ 
/*     */   public AttributeList setAttributes(AttributeList attributes)
/*     */   {
/*     */     JMException result;
/*     */     try
/*     */     {
/* 237 */       AttributeList attrList = new AttributeList(attributes.size());
/* 238 */       Iterator it = attributes.iterator();
/* 239 */       while (it.hasNext())
/*     */       {
/* 241 */         Attribute attr = (Attribute)it.next();
/* 242 */         setAttribute(attr);
/* 243 */         String name = attr.getName();
/* 244 */         Object value = getAttribute(name);
/* 245 */         attrList.add(new Attribute(name, value));
/*     */       }
/* 247 */       return attrList;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 251 */       result = ExceptionHandler.handleException(e);
/*     */     }
/* 253 */     throw new RuntimeException("Cannot set attributes", result);
/*     */   }
/*     */ 
/*     */   public Object invoke(String actionName, Object[] params, String[] signature)
/*     */     throws MBeanException, ReflectionException
/*     */   {
/*     */     try
/*     */     {
/* 262 */       Class[] sigcl = new Class[signature.length];
/* 263 */       for (int i = 0; i < signature.length; i++)
/*     */       {
/* 265 */         sigcl[i] = loadClass(signature[i]);
/*     */       }
/* 267 */       Method method = this.implementation.getClass().getMethod(actionName, sigcl);
/* 268 */       return method.invoke(this.implementation, params);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 272 */       JMException result = ExceptionHandler.handleException(e);
/* 273 */       if ((result instanceof MBeanException))
/* 274 */         throw ((MBeanException)result);
/* 275 */       if ((result instanceof ReflectionException))
/* 276 */         throw ((ReflectionException)result); 
/*     */     }
/* 277 */     throw new MBeanException(e, "Cannot invoke: " + actionName);
/*     */   }
/*     */ 
/*     */   private Class loadClass(String className)
/*     */     throws ClassNotFoundException
/*     */   {
/* 286 */     Class clazz = LoaderRepository.getNativeClassForName(className);
/* 287 */     if (clazz == null) {
/* 288 */       ClassLoader cl = getClass().getClassLoader();
/* 289 */       clazz = cl.loadClass(className);
/*     */     }
/* 291 */     return clazz;
/*     */   }
/*     */ 
/*     */   public MBeanInfo getMBeanInfo()
/*     */   {
/* 296 */     MBeanInfo info = getCachedMBeanInfo();
/* 297 */     if (info == null)
/*     */     {
/*     */       try
/*     */       {
/* 301 */         info = buildMBeanInfo();
/* 302 */         cacheMBeanInfo(info);
/*     */       }
/*     */       catch (NotCompliantMBeanException e)
/*     */       {
/* 306 */         log.error("Unexcepted exception", e);
/* 307 */         throw new IllegalStateException("Unexcepted exception " + e.toString());
/*     */       }
/*     */     }
/*     */ 
/* 311 */     return info;
/*     */   }
/*     */ 
/*     */   public MBeanInfo getCachedMBeanInfo()
/*     */   {
/* 321 */     return this.cachedMBeanInfo;
/*     */   }
/*     */ 
/*     */   public void cacheMBeanInfo(MBeanInfo info)
/*     */   {
/* 332 */     this.cachedMBeanInfo = info;
/*     */   }
/*     */ 
/*     */   public MBeanInfo buildMBeanInfo()
/*     */     throws NotCompliantMBeanException
/*     */   {
/* 344 */     if (this.implementation == null) {
/* 345 */       throw new IllegalArgumentException("Null implementation");
/*     */     }
/* 347 */     StandardMetaData metaData = new StandardMetaData(this.implementation, this.mbeanInterface);
/* 348 */     this.mbeanInterface = metaData.getMBeanInterface();
/* 349 */     return metaData.build();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.standardmbean.StandardMBeanImpl
 * JD-Core Version:    0.6.0
 */