/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.InstanceNotFoundException;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.management.RuntimeErrorException;
/*     */ import javax.management.RuntimeMBeanException;
/*     */ import javax.management.RuntimeOperationsException;
/*     */ 
/*     */ public class DefaultExceptionHandler
/*     */   implements ProxyExceptionHandler
/*     */ {
/*     */   public Object handleInstanceNotFound(ProxyContext ctx, InstanceNotFoundException e, Method m, Object[] args)
/*     */     throws Exception
/*     */   {
/*  56 */     throw new RuntimeProxyException("Instance not found: " + e.toString());
/*     */   }
/*     */ 
/*     */   public Object handleAttributeNotFound(ProxyContext ctx, AttributeNotFoundException e, Method m, Object[] args)
/*     */     throws Exception
/*     */   {
/*  64 */     throw new RuntimeProxyException("Attribute not found: " + e.toString());
/*     */   }
/*     */ 
/*     */   public Object handleInvalidAttributeValue(ProxyContext ctx, InvalidAttributeValueException e, Method m, Object[] args)
/*     */     throws Exception
/*     */   {
/*  72 */     throw new RuntimeProxyException("Invalid attribute value: " + e.toString());
/*     */   }
/*     */ 
/*     */   public Object handleMBeanException(ProxyContext ctx, MBeanException e, Method m, Object[] args)
/*     */     throws Exception
/*     */   {
/*  82 */     throw e.getTargetException();
/*     */   }
/*     */ 
/*     */   public Object handleReflectionException(ProxyContext ctx, ReflectionException e, Method m, Object[] args)
/*     */     throws Exception
/*     */   {
/*  93 */     Exception target = e.getTargetException();
/*  94 */     if ((target instanceof RuntimeException)) {
/*  95 */       throw target;
/*     */     }
/*  97 */     throw new RuntimeProxyException(target.toString());
/*     */   }
/*     */ 
/*     */   public Object handleRuntimeOperationsException(ProxyContext ctx, RuntimeOperationsException e, Method m, Object[] args)
/*     */     throws Exception
/*     */   {
/* 106 */     throw e.getTargetException();
/*     */   }
/*     */ 
/*     */   public Object handleRuntimeMBeanException(ProxyContext ctx, RuntimeMBeanException e, Method m, Object[] args)
/*     */     throws Exception
/*     */   {
/* 115 */     throw e.getTargetException();
/*     */   }
/*     */ 
/*     */   public Object handleRuntimeError(ProxyContext ctx, RuntimeErrorException e, Method m, Object[] args)
/*     */     throws Exception
/*     */   {
/* 123 */     throw e.getTargetError();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.DefaultExceptionHandler
 * JD-Core Version:    0.6.0
 */