/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
/*     */ import javax.management.JMException;
/*     */ import javax.management.ListenerNotFoundException;
/*     */ import javax.management.MBeanNotificationInfo;
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationEmitter;
/*     */ import javax.management.NotificationFilter;
/*     */ import javax.management.NotificationListener;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.notification.ListenerRegistration;
/*     */ import org.jboss.mx.notification.ListenerRegistry;
/*     */ import org.jboss.mx.notification.ListenerRegistry.ListenerRegistrationIterator;
/*     */ 
/*     */ public class JBossNotificationBroadcasterSupport
/*     */   implements NotificationEmitter
/*     */ {
/*  48 */   private static final Logger log = Logger.getLogger(JBossNotificationBroadcasterSupport.class);
/*     */ 
/*  51 */   private static final MBeanNotificationInfo[] NO_NOTIFICATIONS = new MBeanNotificationInfo[0];
/*     */ 
/*  54 */   private ListenerRegistry registry = new ListenerRegistry();
/*     */ 
/*  57 */   private SynchronizedLong sequenceNumber = new SynchronizedLong(0L);
/*     */ 
/*     */   public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*     */   {
/*     */     try
/*     */     {
/*  72 */       this.registry.add(listener, filter, handback);
/*     */     }
/*     */     catch (JMException e)
/*     */     {
/*  77 */       throw new RuntimeException(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(NotificationListener listener)
/*     */     throws ListenerNotFoundException
/*     */   {
/*  84 */     this.registry.remove(listener);
/*     */   }
/*     */ 
/*     */   public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback)
/*     */     throws ListenerNotFoundException
/*     */   {
/*  92 */     this.registry.remove(listener, filter, handback);
/*     */   }
/*     */ 
/*     */   public MBeanNotificationInfo[] getNotificationInfo()
/*     */   {
/*  97 */     return NO_NOTIFICATIONS;
/*     */   }
/*     */ 
/*     */   public void sendNotification(Notification notification)
/*     */   {
/* 102 */     ListenerRegistry.ListenerRegistrationIterator iterator = this.registry.iterator();
/* 103 */     while (iterator.hasNext())
/*     */     {
/* 105 */       ListenerRegistration registration = iterator.nextRegistration();
/* 106 */       NotificationFilter filter = registration.getFilter();
/* 107 */       if (filter == null)
/* 108 */         handleNotification(registration.getListener(), notification, registration.getHandback());
/* 109 */       else if (filter.isNotificationEnabled(notification))
/* 110 */         handleNotification(registration.getListener(), notification, registration.getHandback());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleNotification(NotificationListener listener, Notification notification, Object handback)
/*     */   {
/*     */     try
/*     */     {
/* 127 */       listener.handleNotification(notification, handback);
/*     */     }
/*     */     catch (Throwable ignored)
/*     */     {
/* 131 */       log.debug("Ignored unhandled throwable from listener", ignored);
/*     */     }
/*     */   }
/*     */ 
/*     */   public long nextNotificationSequenceNumber()
/*     */   {
/* 143 */     return this.sequenceNumber.increment();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.JBossNotificationBroadcasterSupport
 * JD-Core Version:    0.6.0
 */