/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ 
/*     */ public class ObjectNameConverter
/*     */ {
/*     */   public static ObjectName convert(String pObjectName)
/*     */     throws MalformedObjectNameException
/*     */   {
/*  77 */     if (pObjectName == null) {
/*  78 */       throw new MalformedObjectNameException("null name");
/*     */     }
/*     */ 
/*  82 */     if (pObjectName.length() == 0) {
/*  83 */       pObjectName = "*:*";
/*     */     }
/*     */ 
/*  86 */     int lIndex = pObjectName.indexOf(":");
/*  87 */     if (lIndex < 0) {
/*  88 */       throw new MalformedObjectNameException("missing domain");
/*     */     }
/*  90 */     String lDomain = pObjectName.substring(0, lIndex);
/*  91 */     if (lIndex + 1 < pObjectName.length()) {
/*  92 */       return createObjectName(lDomain, pObjectName.substring(lIndex + 1));
/*     */     }
/*  94 */     throw new MalformedObjectNameException("properties missing");
/*     */   }
/*     */ 
/*     */   public static ObjectName convert(String pDomainName, Hashtable pProperties)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 112 */     if (pDomainName == null) {
/* 113 */       throw new MalformedObjectNameException("missing domain");
/*     */     }
/* 115 */     if ((pProperties == null) || (pProperties.size() == 0)) {
/* 116 */       throw new MalformedObjectNameException(" null or empty properties");
/*     */     }
/* 118 */     return createObjectName(pDomainName, pProperties, false);
/*     */   }
/*     */ 
/*     */   public static Hashtable getProperties(ObjectName pObjectName)
/*     */   {
/* 133 */     Hashtable lReturn = reverseProperties(pObjectName.getKeyPropertyList());
/* 134 */     if (pObjectName.isPropertyPattern()) {
/* 135 */       lReturn.put("*", "*");
/*     */     }
/* 137 */     return lReturn;
/*     */   }
/*     */ 
/*     */   public static String getString(ObjectName pObjectName)
/*     */   {
/* 152 */     String lReturn = pObjectName.getDomain() + ":" + reverseString(pObjectName.getKeyPropertyList());
/* 153 */     if (pObjectName.isPropertyPattern()) {
/* 154 */       lReturn = lReturn + ",*";
/*     */     }
/* 156 */     return lReturn;
/*     */   }
/*     */ 
/*     */   public static String convertCharacters(String pValue, boolean pEncrypt)
/*     */   {
/* 168 */     String lReturn = pValue;
/* 169 */     if (pEncrypt) {
/* 170 */       int lIndex = lReturn.indexOf("%");
/* 171 */       while (lIndex >= 0) {
/* 172 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%25" + (lIndex + 1 < lReturn.length() ? lReturn.substring(lIndex + 1) : "");
/*     */ 
/* 175 */         lIndex = lReturn.indexOf("%", lIndex + 2);
/*     */       }
/* 177 */       lIndex = lReturn.indexOf("*");
/* 178 */       while (lIndex >= 0) {
/* 179 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%2a" + (lIndex + 1 < lReturn.length() ? lReturn.substring(lIndex + 1) : "");
/*     */ 
/* 182 */         lIndex = lReturn.indexOf("*");
/*     */       }
/* 184 */       lIndex = lReturn.indexOf(":");
/* 185 */       while (lIndex >= 0) {
/* 186 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%3a" + (lIndex + 1 < lReturn.length() ? lReturn.substring(lIndex + 1) : "");
/*     */ 
/* 189 */         lIndex = lReturn.indexOf(":");
/*     */       }
/* 191 */       lIndex = lReturn.indexOf("?");
/* 192 */       while (lIndex >= 0) {
/* 193 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%3f" + (lIndex + 1 < lReturn.length() ? lReturn.substring(lIndex + 1) : "");
/*     */ 
/* 196 */         lIndex = lReturn.indexOf("?");
/*     */       }
/* 198 */       lIndex = lReturn.indexOf("=");
/* 199 */       while (lIndex >= 0) {
/* 200 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%3d" + (lIndex + 1 < lReturn.length() ? lReturn.substring(lIndex + 1) : "");
/*     */ 
/* 203 */         lIndex = lReturn.indexOf("=");
/*     */       }
/* 205 */       lIndex = lReturn.indexOf(",");
/* 206 */       while (lIndex >= 0) {
/* 207 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%2c" + (lIndex + 1 < lReturn.length() ? lReturn.substring(lIndex + 1) : "");
/*     */ 
/* 210 */         lIndex = lReturn.indexOf(",");
/*     */       }
/* 212 */       lIndex = lReturn.indexOf("'");
/* 213 */       while (lIndex >= 0) {
/* 214 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%27" + (lIndex + 1 < lReturn.length() ? lReturn.substring(lIndex + 1) : "");
/*     */ 
/* 217 */         lIndex = lReturn.indexOf("'");
/*     */       }
/* 219 */       lIndex = lReturn.indexOf("\"");
/* 220 */       while (lIndex >= 0) {
/* 221 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%22" + (lIndex + 1 < lReturn.length() ? lReturn.substring(lIndex + 1) : "");
/*     */ 
/* 224 */         lIndex = lReturn.indexOf("\"");
/*     */       }
/*     */     } else {
/* 227 */       int lIndex = lReturn.indexOf("%2a");
/* 228 */       while (lIndex >= 0) {
/* 229 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "*" + (lIndex + 3 < lReturn.length() ? lReturn.substring(lIndex + 3) : "");
/*     */ 
/* 232 */         lIndex = lReturn.indexOf("%2a");
/*     */       }
/* 234 */       lIndex = lReturn.indexOf("%3a");
/* 235 */       while (lIndex >= 0) {
/* 236 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + ":" + (lIndex + 3 < lReturn.length() ? lReturn.substring(lIndex + 3) : "");
/*     */ 
/* 239 */         lIndex = lReturn.indexOf("%3a");
/*     */       }
/* 241 */       lIndex = lReturn.indexOf("%3f");
/* 242 */       while (lIndex >= 0) {
/* 243 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "?" + (lIndex + 3 < lReturn.length() ? lReturn.substring(lIndex + 3) : "");
/*     */ 
/* 246 */         lIndex = lReturn.indexOf("%3f");
/*     */       }
/* 248 */       lIndex = lReturn.indexOf("%3d");
/* 249 */       while (lIndex >= 0) {
/* 250 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "=" + (lIndex + 3 < lReturn.length() ? lReturn.substring(lIndex + 3) : "");
/*     */ 
/* 253 */         lIndex = lReturn.indexOf("%3d");
/*     */       }
/* 255 */       lIndex = lReturn.indexOf("%2c");
/* 256 */       while (lIndex >= 0) {
/* 257 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "," + (lIndex + 3 < lReturn.length() ? lReturn.substring(lIndex + 3) : "");
/*     */ 
/* 260 */         lIndex = lReturn.indexOf("%2c");
/*     */       }
/* 262 */       lIndex = lReturn.indexOf("%25");
/* 263 */       while (lIndex >= 0) {
/* 264 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%" + (lIndex + 3 < lReturn.length() ? lReturn.substring(lIndex + 3) : "");
/*     */ 
/* 267 */         lIndex = lReturn.indexOf("%25");
/*     */       }
/* 269 */       lIndex = lReturn.indexOf("%27");
/* 270 */       while (lIndex >= 0) {
/* 271 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "'" + (lIndex + 3 < lReturn.length() ? lReturn.substring(lIndex + 3) : "");
/*     */ 
/* 274 */         lIndex = lReturn.indexOf("%27");
/*     */       }
/* 276 */       lIndex = lReturn.indexOf("%22");
/* 277 */       while (lIndex >= 0) {
/* 278 */         lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "\"" + (lIndex + 3 < lReturn.length() ? lReturn.substring(lIndex + 3) : "");
/*     */ 
/* 281 */         lIndex = lReturn.indexOf("%22");
/*     */       }
/*     */     }
/* 284 */     return lReturn;
/*     */   }
/*     */ 
/*     */   private static ObjectName createObjectName(String domain, String properties)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 301 */     if ((null == properties) || (properties.length() < 1))
/*     */     {
/* 303 */       throw new MalformedObjectNameException("null or empty properties");
/*     */     }
/*     */ 
/* 311 */     if ((properties.startsWith(",")) || (properties.endsWith(",")) || (properties.indexOf(",,") != -1))
/*     */     {
/* 313 */       throw new MalformedObjectNameException("empty key/value pair in properties string");
/*     */     }
/*     */ 
/* 316 */     Hashtable ptable = new Hashtable();
/*     */ 
/* 318 */     StringTokenizer tokenizer = new StringTokenizer(properties, ",");
/* 319 */     boolean lPattern = false;
/* 320 */     while (tokenizer.hasMoreTokens())
/*     */     {
/* 322 */       String chunk = tokenizer.nextToken();
/*     */ 
/* 324 */       if (chunk.equals("*"))
/*     */       {
/* 326 */         lPattern = true;
/* 327 */         continue;
/*     */       }
/*     */ 
/* 330 */       int keylen = chunk.length();
/* 331 */       int eqpos = chunk.indexOf('=');
/*     */ 
/* 334 */       if ((eqpos < 1) || (keylen == eqpos + 1))
/*     */       {
/* 336 */         throw new MalformedObjectNameException("malformed key/value pair: " + chunk);
/*     */       }
/*     */ 
/* 339 */       String key = chunk.substring(0, eqpos);
/* 340 */       if (ptable.containsKey(key))
/*     */       {
/* 342 */         throw new MalformedObjectNameException("duplicate key: " + key);
/*     */       }
/*     */ 
/* 345 */       ptable.put(key, chunk.substring(eqpos + 1, keylen));
/*     */     }
/*     */ 
/* 348 */     return createObjectName(domain, ptable, lPattern);
/*     */   }
/*     */ 
/*     */   private static ObjectName createObjectName(String domain, Hashtable properties, boolean pPattern)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 360 */     if ((null == properties) || ((!pPattern) && (properties.size() < 1)))
/*     */     {
/* 362 */       throw new MalformedObjectNameException("null or empty properties");
/*     */     }
/*     */ 
/* 365 */     Iterator it = properties.keySet().iterator();
/* 366 */     Hashtable lReturn = new Hashtable(properties.size());
/* 367 */     while (it.hasNext())
/*     */     {
/* 369 */       String key = null;
/*     */       try
/*     */       {
/* 372 */         key = (String)it.next();
/*     */       }
/*     */       catch (ClassCastException e)
/*     */       {
/* 376 */         throw new MalformedObjectNameException("key is not a string");
/*     */       }
/*     */ 
/* 379 */       String val = null;
/*     */       try
/*     */       {
/* 382 */         val = (String)properties.get(key);
/*     */       }
/*     */       catch (ClassCastException e)
/*     */       {
/* 386 */         throw new MalformedObjectNameException("value is not a string");
/*     */       }
/*     */ 
/* 390 */       String lKey = convertCharacters(key, true);
/* 391 */       String lValue = convertCharacters(val, true);
/*     */ 
/* 393 */       lReturn.put(lKey, lValue);
/*     */     }
/* 395 */     ObjectName result = new ObjectName(domain, lReturn);
/* 396 */     if (pPattern)
/* 397 */       return new ObjectName(result.getCanonicalName() + ",*");
/* 398 */     return result;
/*     */   }
/*     */ 
/*     */   private static Hashtable reverseProperties(Hashtable pProperties) {
/* 402 */     Hashtable lReturn = new Hashtable(pProperties.size());
/* 403 */     Iterator i = pProperties.keySet().iterator();
/* 404 */     while (i.hasNext()) {
/* 405 */       String lKey = (String)i.next();
/* 406 */       String lValue = (String)pProperties.get(lKey);
/* 407 */       lKey = convertCharacters(lKey, false);
/* 408 */       lValue = convertCharacters(lValue, false);
/* 409 */       lReturn.put(lKey, lValue);
/*     */     }
/* 411 */     return lReturn;
/*     */   }
/*     */ 
/*     */   private static String reverseString(Hashtable pProperties) {
/* 415 */     StringBuffer lReturn = new StringBuffer();
/* 416 */     Iterator i = pProperties.keySet().iterator();
/* 417 */     while (i.hasNext()) {
/* 418 */       String lKey = (String)i.next();
/* 419 */       String lValue = (String)pProperties.get(lKey);
/* 420 */       lKey = convertCharacters(lKey, false);
/* 421 */       lValue = convertCharacters(lValue, false);
/* 422 */       if (lReturn.length() > 0) {
/* 423 */         lReturn.append(",");
/*     */       }
/* 425 */       lReturn.append(lKey);
/* 426 */       lReturn.append("=");
/* 427 */       lReturn.append(lValue);
/*     */     }
/* 429 */     return lReturn.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.ObjectNameConverter
 * JD-Core Version:    0.6.0
 */