/*    */ package org.jboss.naming;
/*    */ 
/*    */ import java.util.Hashtable;
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.NamingException;
/*    */ 
/*    */ public class JndiBinder
/*    */ {
/*    */   private String bindTo;
/*    */   private Object target;
/*    */   private boolean serializable;
/*    */   private Hashtable properties;
/*    */ 
/*    */   public void setBindTo(String bindTo)
/*    */   {
/* 43 */     this.bindTo = bindTo;
/*    */   }
/*    */ 
/*    */   public void setTarget(Object target)
/*    */   {
/* 48 */     this.target = target;
/*    */   }
/*    */ 
/*    */   public void setSerializable(boolean serializable)
/*    */   {
/* 53 */     this.serializable = serializable;
/*    */   }
/*    */ 
/*    */   public void setJndiProperties(Hashtable properties)
/*    */   {
/* 58 */     this.properties = properties;
/*    */   }
/*    */ 
/*    */   public void start() throws Exception
/*    */   {
/* 63 */     InitialContext ctx1 = null;
/* 64 */     if (this.properties != null)
/*    */     {
/* 66 */       ctx1 = new InitialContext(this.properties);
/*    */     }
/* 68 */     else ctx1 = new InitialContext();
/* 69 */     InitialContext ctx = ctx1;
/*    */     try
/*    */     {
/* 73 */       if (this.serializable)
/*    */       {
/* 75 */         Util.rebind(ctx, this.bindTo, this.target);
/*    */       }
/*    */       else
/*    */       {
/* 79 */         NonSerializableFactory.rebind(ctx, this.bindTo, this.target);
/*    */       }
/*    */     }
/*    */     catch (NamingException e) {
/* 83 */       NamingException namingException = new NamingException("Could not bind JndiBinder service into JNDI under jndiName:" + ctx.getNameInNamespace() + "/" + this.bindTo);
/* 84 */       namingException.setRootCause(e);
/* 85 */       throw namingException;
/*    */     }
/*    */   }
/*    */ 
/*    */   public void stop() throws Exception
/*    */   {
/* 91 */     InitialContext ctx1 = null;
/* 92 */     if (this.properties != null)
/*    */     {
/* 94 */       ctx1 = new InitialContext(this.properties);
/*    */     }
/* 96 */     else ctx1 = new InitialContext();
/* 97 */     InitialContext ctx = ctx1;
/* 98 */     if (this.serializable)
/*    */     {
/* 100 */       Util.unbind(ctx, this.bindTo);
/*    */     }
/*    */     else
/*    */     {
/* 104 */       NonSerializableFactory.unbind(this.bindTo);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.JndiBinder
 * JD-Core Version:    0.6.0
 */