/*     */ package org.jboss.naming;
/*     */ 
/*     */ import javax.naming.MalformedLinkException;
/*     */ import javax.naming.RefAddr;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.StringRefAddr;
/*     */ 
/*     */ public class LinkRefPair extends Reference
/*     */ {
/*     */   private static final long serialVersionUID = 6036946190113161492L;
/*  44 */   private static final String linkRefPairClassName = LinkRefPair.class.getName();
/*     */   static final String remoteAddress = "remoteAddress";
/*     */   static final String localAddress = "localAddress";
/*     */   private static final String guidAddress = "guid";
/*     */ 
/*     */   public LinkRefPair(String remote, String local)
/*     */   {
/*  69 */     super(linkRefPairClassName, LinkRefPairObjectFactory.className, null);
/*  70 */     add(new StringRefAddr("guid", LinkRefPairObjectFactory.guid));
/*  71 */     add(new StringRefAddr("remoteAddress", remote));
/*  72 */     add(new StringRefAddr("localAddress", local));
/*     */   }
/*     */ 
/*     */   public String getGUID()
/*     */     throws MalformedLinkException
/*     */   {
/*  85 */     if ((this.className != null) && (this.className.equals(linkRefPairClassName)))
/*     */     {
/*  87 */       RefAddr refAddr = get("guid");
/*  88 */       if ((refAddr != null) && ((refAddr instanceof StringRefAddr)))
/*     */       {
/*  90 */         Object content = refAddr.getContent();
/*  91 */         if ((content != null) && ((content instanceof String))) {
/*  92 */           return (String)content;
/*     */         }
/*  94 */         throw new MalformedLinkException("Content is not a string: " + content);
/*     */       }
/*     */ 
/*  97 */       throw new MalformedLinkException("RefAddr is not a string reference: " + refAddr);
/*     */     }
/*     */ 
/* 100 */     throw new MalformedLinkException("Class is not a LinkRefPair: " + this.className);
/*     */   }
/*     */ 
/*     */   public String getRemoteLinkName()
/*     */     throws MalformedLinkException
/*     */   {
/* 111 */     if ((this.className != null) && (this.className.equals(linkRefPairClassName)))
/*     */     {
/* 113 */       RefAddr refAddr = get("remoteAddress");
/* 114 */       if ((refAddr != null) && ((refAddr instanceof StringRefAddr)))
/*     */       {
/* 116 */         Object content = refAddr.getContent();
/* 117 */         if ((content != null) && ((content instanceof String))) {
/* 118 */           return (String)content;
/*     */         }
/* 120 */         throw new MalformedLinkException("Content is not a string: " + content);
/*     */       }
/*     */ 
/* 123 */       throw new MalformedLinkException("RefAddr is not a string reference: " + refAddr);
/*     */     }
/*     */ 
/* 126 */     throw new MalformedLinkException("Class is not a LinkRefPair: " + this.className);
/*     */   }
/*     */ 
/*     */   public String getLocalLinkName()
/*     */     throws MalformedLinkException
/*     */   {
/* 137 */     if ((this.className != null) && (this.className.equals(linkRefPairClassName)))
/*     */     {
/* 139 */       RefAddr refAddr = get("localAddress");
/* 140 */       if ((refAddr != null) && ((refAddr instanceof StringRefAddr)))
/*     */       {
/* 142 */         Object content = refAddr.getContent();
/* 143 */         if ((content != null) && ((content instanceof String))) {
/* 144 */           return (String)content;
/*     */         }
/* 146 */         throw new MalformedLinkException("Content is not a string: " + content);
/*     */       }
/*     */ 
/* 149 */       throw new MalformedLinkException("RefAddr is not a string reference: " + refAddr);
/*     */     }
/*     */ 
/* 152 */     throw new MalformedLinkException("Class is not a LinkRefPair: " + this.className);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.LinkRefPair
 * JD-Core Version:    0.6.0
 */