/*    */ package org.jboss.net.sockets;
/*    */ 
/*    */ import java.io.Externalizable;
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInput;
/*    */ import java.io.ObjectOutput;
/*    */ import java.net.Socket;
/*    */ import java.rmi.server.RMIClientSocketFactory;
/*    */ import java.util.concurrent.Semaphore;
/*    */ 
/*    */ public class QueuedClientSocketFactory
/*    */   implements RMIClientSocketFactory, Externalizable
/*    */ {
/*    */   private transient Semaphore permits;
/*    */   private long numPermits;
/*    */ 
/*    */   public QueuedClientSocketFactory()
/*    */   {
/*    */   }
/*    */ 
/*    */   public QueuedClientSocketFactory(long nPermits)
/*    */   {
/* 45 */     this.permits = new Semaphore((int)nPermits, true);
/* 46 */     this.numPermits = nPermits;
/*    */   }
/*    */ 
/*    */   public Socket createSocket(String host, int port)
/*    */     throws IOException
/*    */   {
/*    */     try
/*    */     {
/* 61 */       this.permits.acquire();
/* 62 */       Socket localSocket = new Socket(host, port);
/*    */       return localSocket;
/*    */     }
/*    */     catch (InterruptedException ex)
/*    */     {
/* 66 */       throw new IOException("Failed to acquire FIFOSemaphore for ClientSocketFactory");
/*    */     }
/*    */     finally
/*    */     {
/* 70 */       this.permits.release(); } throw localObject;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object obj)
/*    */   {
/* 76 */     return obj instanceof QueuedClientSocketFactory;
/*    */   }
/*    */ 
/*    */   public int hashCode() {
/* 80 */     return getClass().getName().hashCode();
/*    */   }
/*    */ 
/*    */   public void writeExternal(ObjectOutput out)
/*    */     throws IOException
/*    */   {
/* 86 */     out.writeLong(this.numPermits);
/*    */   }
/*    */ 
/*    */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*    */   {
/* 91 */     this.numPermits = in.readLong();
/* 92 */     this.permits = new Semaphore((int)this.numPermits, true);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.sockets.QueuedClientSocketFactory
 * JD-Core Version:    0.6.0
 */