/*    */ package org.jboss.net.sockets;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import java.lang.reflect.Proxy;
/*    */ import java.rmi.NoSuchObjectException;
/*    */ import java.rmi.Remote;
/*    */ import java.rmi.RemoteException;
/*    */ import java.rmi.server.RMIClientSocketFactory;
/*    */ import java.rmi.server.RMIServerSocketFactory;
/*    */ import java.rmi.server.UnicastRemoteObject;
/*    */ import java.util.HashMap;
/*    */ 
/*    */ public class RMIMultiSocketServer
/*    */ {
/* 40 */   private static HashMap handlermap = new HashMap();
/* 41 */   private static HashMap stubmap = new HashMap();
/*    */ 
/*    */   public static Remote exportObject(Remote obj, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, Class[] interfaces, int numSockets)
/*    */     throws RemoteException
/*    */   {
/* 51 */     Remote[] stubs = new Remote[numSockets];
/*    */ 
/* 53 */     Method[] methods = obj.getClass().getMethods();
/*    */ 
/* 55 */     HashMap invokerMap = new HashMap();
/* 56 */     for (int i = 0; i < methods.length; i++) {
/* 57 */       Long methodkey = new Long(MethodHash.calculateHash(methods[i]));
/* 58 */       invokerMap.put(methodkey, methods[i]);
/*    */     }
/*    */ 
/* 61 */     RMIMultiSocketHandler[] handlers = new RMIMultiSocketHandler[numSockets];
/* 62 */     for (int i = 0; i < numSockets; i++)
/*    */     {
/* 64 */       int theport = port == 0 ? 0 : port + i;
/* 65 */       handlers[i] = new RMIMultiSocketHandler(obj, invokerMap);
/* 66 */       stubs[i] = UnicastRemoteObject.exportObject(handlers[i], theport, csf, ssf);
/*    */     }
/*    */ 
/* 69 */     Remote remote = (Remote)Proxy.newProxyInstance(obj.getClass().getClassLoader(), interfaces, new RMIMultiSocketClient(stubs));
/*    */ 
/* 73 */     stubmap.put(remote, stubs);
/* 74 */     handlermap.put(remote, handlers);
/* 75 */     return remote;
/*    */   }
/*    */ 
/*    */   public static Remote exportObject(Remote obj, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, int numSockets)
/*    */     throws RemoteException
/*    */   {
/* 85 */     return exportObject(obj, port, csf, ssf, obj.getClass().getInterfaces(), numSockets);
/*    */   }
/*    */ 
/*    */   public static boolean unexportObject(Remote obj, boolean force)
/*    */     throws NoSuchObjectException
/*    */   {
/* 91 */     handlermap.remove(obj);
/* 92 */     Remote[] stubs = (Remote[])(Remote[])stubmap.remove(obj);
/* 93 */     for (int i = 0; i < stubs.length; i++)
/*    */     {
/* 95 */       UnicastRemoteObject.unexportObject(stubs[i], force);
/*    */     }
/*    */ 
/* 98 */     return true;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.sockets.RMIMultiSocketServer
 * JD-Core Version:    0.6.0
 */