/*    */ package org.jboss.profileservice.management;
/*    */ 
/*    */ import org.jboss.deployers.spi.management.RuntimeComponentDispatcher;
/*    */ import org.jboss.metatype.api.types.MetaType;
/*    */ import org.jboss.metatype.api.values.MetaValue;
/*    */ import org.jboss.metatype.api.values.MetaValueFactory;
/*    */ 
/*    */ public abstract class AbstractRuntimeComponentDispatcher
/*    */   implements RuntimeComponentDispatcher
/*    */ {
/*    */   private MetaValueFactory valueFactory;
/*    */ 
/*    */   protected AbstractRuntimeComponentDispatcher(MetaValueFactory valueFactory)
/*    */   {
/* 39 */     if (valueFactory == null)
/* 40 */       valueFactory = MetaValueFactory.getInstance();
/* 41 */     this.valueFactory = valueFactory;
/*    */   }
/*    */ 
/*    */   protected MetaValue create(Object value)
/*    */   {
/* 52 */     return this.valueFactory.create(value);
/*    */   }
/*    */ 
/*    */   protected Object unwrap(MetaValue metaValue)
/*    */   {
/* 63 */     return this.valueFactory.unwrap(metaValue);
/*    */   }
/*    */ 
/*    */   protected Object[] toArguments(MetaValue[] param)
/*    */   {
/* 74 */     Object[] args = new Object[param.length];
/* 75 */     for (int i = 0; i < param.length; i++)
/*    */     {
/* 77 */       args[i] = unwrap(param[i]);
/*    */     }
/* 79 */     return param;
/*    */   }
/*    */ 
/*    */   protected static String[] toSignature(MetaValue[] param)
/*    */   {
/* 90 */     String[] signature = new String[param.length];
/* 91 */     for (int i = 0; i < param.length; i++)
/*    */     {
/* 93 */       signature[i] = param[i].getMetaType().getTypeName();
/*    */     }
/* 95 */     return signature;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.management.AbstractRuntimeComponentDispatcher
 * JD-Core Version:    0.6.0
 */