/*    */ package org.jboss.profileservice.management;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.util.Map;
/*    */ import java.util.Set;
/*    */ import org.jboss.managed.api.ManagedProperty;
/*    */ 
/*    */ public class BaseManagedObject
/*    */   implements Serializable
/*    */ {
/*    */   private static final long serialVersionUID = 1L;
/*    */   private String simpleName;
/*    */   private Map<String, ManagedProperty> properties;
/*    */ 
/*    */   public BaseManagedObject(String simpleName, Map<String, ManagedProperty> properties)
/*    */   {
/* 18 */     this.simpleName = simpleName;
/* 19 */     this.properties = properties;
/*    */   }
/*    */ 
/*    */   public String getSimpleName()
/*    */   {
/* 24 */     return this.simpleName;
/*    */   }
/*    */ 
/*    */   public String getName() {
/* 28 */     return this.simpleName;
/*    */   }
/*    */ 
/*    */   public Set<String> getPropertyNames()
/*    */   {
/* 38 */     return this.properties.keySet();
/*    */   }
/*    */ 
/*    */   public ManagedProperty getProperty(String name)
/*    */   {
/* 49 */     ManagedProperty prop = (ManagedProperty)this.properties.get(name);
/* 50 */     return prop;
/*    */   }
/*    */ 
/*    */   public Map<String, ManagedProperty> getProperties()
/*    */   {
/* 60 */     return this.properties;
/*    */   }
/*    */ 
/*    */   protected void toString(StringBuilder sb)
/*    */   {
/* 69 */     sb.append("simpleName=");
/* 70 */     sb.append(this.simpleName);
/* 71 */     sb.append(", properties=");
/* 72 */     sb.append(this.properties);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.management.BaseManagedObject
 * JD-Core Version:    0.6.0
 */