/*    */ package org.jboss.profileservice.management.plugins;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.util.HashMap;
/*    */ import java.util.Map;
/*    */ import org.jboss.deployers.spi.management.DeploymentTemplateInfo;
/*    */ import org.jboss.managed.api.ManagedProperty;
/*    */ 
/*    */ public class BasicDeploymentTemplateInfo
/*    */   implements DeploymentTemplateInfo, Serializable
/*    */ {
/*    */   private static final long serialVersionUID = 1L;
/*    */   private String name;
/*    */   private String description;
/*    */   private Map<String, ManagedProperty> properties;
/*    */ 
/*    */   public BasicDeploymentTemplateInfo(String name, String description)
/*    */   {
/* 46 */     this(name, description, new HashMap());
/*    */   }
/*    */ 
/*    */   public BasicDeploymentTemplateInfo(String name, String description, HashMap<String, ManagedProperty> properties)
/*    */   {
/* 51 */     this.name = name;
/* 52 */     this.description = description;
/* 53 */     this.properties = properties;
/*    */   }
/*    */ 
/*    */   public String getDescription()
/*    */   {
/* 58 */     return this.description;
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 63 */     return this.name;
/*    */   }
/*    */ 
/*    */   public Map<String, ManagedProperty> getProperties()
/*    */   {
/* 68 */     return this.properties;
/*    */   }
/*    */ 
/*    */   public void setProperties(Map<String, ManagedProperty> properties) {
/* 72 */     this.properties = properties;
/*    */   }
/*    */ 
/*    */   public void addProperty(ManagedProperty property) {
/* 76 */     this.properties.put(property.getName(), property);
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 81 */     StringBuilder tmp = new StringBuilder(super.toString());
/* 82 */     tmp.append('{');
/* 83 */     tmp.append(this.name);
/* 84 */     tmp.append(",description=");
/* 85 */     tmp.append(this.description);
/* 86 */     tmp.append(",properties=");
/* 87 */     tmp.append(this.properties);
/* 88 */     tmp.append('}');
/* 89 */     return tmp.toString();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.management.plugins.BasicDeploymentTemplateInfo
 * JD-Core Version:    0.6.0
 */