/*     */ package org.jboss.profileservice.management.templates;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileWriter;
/*     */ import java.net.URI;
/*     */ import java.util.Map;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import org.jboss.deployers.spi.management.DeploymentTemplate;
/*     */ import org.jboss.deployers.spi.management.DeploymentTemplateInfo;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ManagedProperty;
/*     */ import org.jboss.metatype.api.types.CompositeMetaType;
/*     */ import org.jboss.metatype.api.values.CompositeValue;
/*     */ import org.jboss.metatype.api.values.SimpleValue;
/*     */ import org.jboss.util.xml.DOMWriter;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.w3c.dom.DOMImplementation;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Text;
/*     */ 
/*     */ public class DsXmlDataSourceTemplate
/*     */   implements DeploymentTemplate
/*     */ {
/*  57 */   private static final Logger log = Logger.getLogger(DsXmlDataSourceTemplate.class);
/*     */   private DeploymentTemplateInfo info;
/*     */ 
/*     */   public VirtualFile applyTemplate(VirtualFile root, String deploymentBaseName, DeploymentTemplateInfo values)
/*     */     throws Exception
/*     */   {
/*  67 */     String dsName = deploymentBaseName + "-ds.xml";
/*  68 */     URI dsXmlURI = new URI(root.toURI() + dsName);
/*  69 */     File dsXml = new File(dsXmlURI.getPath());
/*  70 */     writeTemplate(dsXml, values);
/*  71 */     VirtualFile dsXmlVF = root.findChild(dsName);
/*  72 */     return dsXmlVF;
/*     */   }
/*     */ 
/*     */   public void updateTemplateDeployment(VFSDeployment ctx, DeploymentTemplateInfo values)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public DeploymentTemplateInfo getInfo()
/*     */   {
/*  90 */     return this.info;
/*     */   }
/*     */ 
/*     */   public void setInfo(DeploymentTemplateInfo info) {
/*  94 */     this.info = info;
/*     */   }
/*     */ 
/*     */   protected void writeTemplate(File dsXml, DeploymentTemplateInfo values)
/*     */     throws Exception
/*     */   {
/* 100 */     FileWriter fw = new FileWriter(dsXml);
/* 101 */     fw.write("<datasources>\n");
/* 102 */     Map properties = values.getProperties();
/*     */ 
/* 104 */     ManagedProperty dsType = (ManagedProperty)properties.get("datasource-type");
/* 105 */     if ((dsType == null) || (dsType.getValue() == null))
/* 106 */       throw new IllegalStateException("Required datasource-type value not found");
/* 107 */     fw.write(60);
/* 108 */     fw.write(dsType.getValue().toString());
/* 109 */     fw.write(">\n");
/*     */ 
/* 112 */     for (ManagedProperty p : properties.values())
/*     */     {
/* 114 */       String tagName = p.getName();
/* 115 */       if (tagName.equals("datasource-type"))
/*     */         continue;
/* 117 */       if ((p.isMandatory()) && (p.getValue() == null))
/* 118 */         throw new IllegalStateException("Required " + tagName + " value not found");
/* 119 */       fw.write("  <");
/* 120 */       fw.write(tagName);
/* 121 */       fw.write(62);
/*     */       CompositeValue cvalue;
/* 123 */       if ((p.getMetaType() instanceof CompositeMetaType))
/*     */       {
/* 125 */         cvalue = (CompositeValue)p.getValue();
/* 126 */         for (String key : cvalue.getMetaType().keySet())
/*     */         {
/* 128 */           if (cvalue.containsKey(key))
/*     */           {
/* 130 */             SimpleValue svalue = (SimpleValue)cvalue.get(key);
/* 131 */             String string = svalue.toString();
/* 132 */             fw.write("  <");
/* 133 */             fw.write(key);
/* 134 */             fw.write(62);
/* 135 */             fw.write(string);
/* 136 */             fw.write("</");
/* 137 */             fw.write(tagName);
/* 138 */             fw.write(">\n");
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 144 */         Object value = p.getValue();
/* 145 */         if (value == null)
/* 146 */           value = "";
/* 147 */         fw.write(value.toString());
/* 148 */         fw.write("</");
/* 149 */         fw.write(tagName);
/* 150 */         fw.write(">\n");
/*     */       }
/*     */     }
/*     */ 
/* 154 */     fw.write("</");
/* 155 */     fw.write(dsType.getValue().toString());
/* 156 */     fw.write(">\n");
/* 157 */     fw.write("</datasources>\n");
/* 158 */     fw.flush();
/* 159 */     fw.close();
/*     */   }
/*     */ 
/*     */   protected Document buildDocument(DeploymentTemplateInfo values)
/*     */     throws Exception
/*     */   {
/* 165 */     Document document = null;
/* 166 */     DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
/* 167 */     DocumentBuilder builder = factory.newDocumentBuilder();
/* 168 */     DOMImplementation impl = builder.getDOMImplementation();
/* 169 */     document = impl.createDocument(null, null, null);
/* 170 */     Element ds = document.createElement("datasources");
/* 171 */     document.appendChild(ds);
/* 172 */     Map properties = values.getProperties();
/*     */ 
/* 174 */     ManagedProperty dsType = (ManagedProperty)properties.get("datasource-type");
/* 175 */     if ((dsType == null) || (dsType.getValue() == null))
/* 176 */       throw new IllegalStateException("Required datasource-type value not found");
/* 177 */     Element dsTypeElem = document.createElement(dsType.getValue().toString());
/* 178 */     ds.appendChild(dsTypeElem);
/*     */ 
/* 180 */     for (ManagedProperty p : properties.values())
/*     */     {
/* 182 */       String tagName = p.getName();
/* 183 */       if (tagName.equals("datasource-type"))
/*     */         continue;
/* 185 */       if ((p.isMandatory()) && (p.getValue() == null))
/* 186 */         throw new IllegalStateException("Required " + tagName + " value not found");
/* 187 */       Element element = document.createElement(tagName);
/* 188 */       Text t = document.createTextNode(p.getValue().toString());
/* 189 */       element.appendChild(t);
/* 190 */       dsTypeElem.appendChild(element);
/*     */     }
/*     */ 
/* 193 */     log.debug("Updated metadata to: " + DOMWriter.printNode(document, true));
/* 194 */     return document;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.management.templates.DsXmlDataSourceTemplate
 * JD-Core Version:    0.6.0
 */