/*    */ package org.jboss.proxy;
/*    */ 
/*    */ import java.io.Externalizable;
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.invocation.Invocation;
/*    */ import org.jboss.invocation.InvocationContext;
/*    */ 
/*    */ public class ClientMethodInterceptor extends Interceptor
/*    */   implements Externalizable
/*    */ {
/*    */   private static final long serialVersionUID = 6010013004557885014L;
/*    */ 
/*    */   public Object invoke(Invocation mi)
/*    */     throws Throwable
/*    */   {
/* 52 */     Method m = mi.getMethod();
/* 53 */     String methodName = m.getName();
/*    */ 
/* 55 */     if (methodName.equals("toString"))
/*    */     {
/* 57 */       Object obj = getObject(mi);
/* 58 */       return obj.toString();
/*    */     }
/* 60 */     if (methodName.equals("equals"))
/*    */     {
/* 62 */       Object obj = getObject(mi);
/* 63 */       Object[] args = mi.getArguments();
/* 64 */       String thisString = obj.toString();
/* 65 */       String argsString = args[0] == null ? "" : args[0].toString();
/* 66 */       return new Boolean(thisString.equals(argsString));
/*    */     }
/* 68 */     if (methodName.equals("hashCode"))
/*    */     {
/* 70 */       Object obj = getObject(mi);
/* 71 */       return new Integer(obj.hashCode());
/*    */     }
/*    */ 
/* 74 */     return getNext().invoke(mi);
/*    */   }
/*    */ 
/*    */   protected Object getObject(Invocation mi)
/*    */   {
/* 85 */     Object cacheId = mi.getInvocationContext().getCacheId();
/* 86 */     if (cacheId != null) {
/* 87 */       return cacheId;
/*    */     }
/* 89 */     return mi.getInvocationContext().getInvoker();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ClientMethodInterceptor
 * JD-Core Version:    0.6.0
 */