/*     */ package org.jboss.proxy;
/*     */ 
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashMap;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.invocation.InvocationContext;
/*     */ import org.jboss.invocation.InvocationKey;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ 
/*     */ public class GenericProxyFactory
/*     */ {
/*     */   public Object createProxy(Object id, ObjectName targetName, Invoker invoker, String jndiName, String proxyBindingName, ArrayList interceptorClasses, ClassLoader loader, Class[] ifaces)
/*     */   {
/*  61 */     return createProxy(id, targetName, invoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces, null);
/*     */   }
/*     */ 
/*     */   public Object createProxy(Object id, ObjectName targetName, ObjectName invokerName, String jndiName, String proxyBindingName, ArrayList interceptorClasses, ClassLoader loader, Class[] ifaces)
/*     */   {
/*  78 */     Invoker invoker = (Invoker)Registry.lookup(invokerName);
/*  79 */     if (invoker == null)
/*  80 */       throw new RuntimeException("Failed to find invoker for name: " + invokerName);
/*  81 */     return createProxy(id, targetName, invoker, jndiName, proxyBindingName, interceptorClasses, loader, ifaces, null);
/*     */   }
/*     */ 
/*     */   public Object createProxy(Object id, ObjectName targetName, Invoker invoker, String jndiName, String proxyBindingName, ArrayList interceptorClasses, ClassLoader loader, Class[] ifaces, HashMap ctx)
/*     */   {
/*     */     InvocationContext context;
/*     */     InvocationContext context;
/* 100 */     if (ctx != null)
/* 101 */       context = new InvocationContext(ctx);
/*     */     else
/* 103 */       context = new InvocationContext();
/* 104 */     Integer nameHash = new Integer(targetName.hashCode());
/* 105 */     context.setObjectName(nameHash);
/* 106 */     context.setCacheId(id);
/* 107 */     if (jndiName != null) {
/* 108 */       context.setValue(InvocationKey.JNDI_NAME, jndiName);
/*     */     }
/* 110 */     if (invoker == null)
/* 111 */       throw new RuntimeException("Null invoker given for name: " + targetName);
/* 112 */     context.setInvoker(invoker);
/* 113 */     if (proxyBindingName != null) {
/* 114 */       context.setInvokerProxyBinding(proxyBindingName);
/*     */     }
/*     */ 
/* 117 */     boolean wantIClientAccess = false;
/* 118 */     for (int n = 0; (!wantIClientAccess) && (n < interceptorClasses.size()); n++)
/*     */     {
/* 120 */       Class type = (Class)interceptorClasses.get(n);
/* 121 */       wantIClientAccess = type.isAssignableFrom(IClientContainer.class);
/*     */     }
/*     */     ClientContainer client;
/*     */     ClientContainer client;
/* 124 */     if (wantIClientAccess)
/*     */     {
/* 126 */       client = new ClientContainerEx(context);
/*     */     }
/*     */     else
/*     */     {
/* 130 */       client = new ClientContainer(context);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 135 */       loadInterceptorChain(interceptorClasses, client);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 139 */       throw new NestedRuntimeException("Failed to load interceptor chain", e);
/*     */     }
/*     */ 
/* 142 */     ArrayList tmp = new ArrayList(Arrays.asList(ifaces));
/* 143 */     Class[] ifaces2 = new Class[tmp.size()];
/* 144 */     tmp.toArray(ifaces2);
/* 145 */     return Proxy.newProxyInstance(loader, ifaces2, client);
/*     */   }
/*     */ 
/*     */   protected void loadInterceptorChain(ArrayList chain, ClientContainer client)
/*     */     throws Exception
/*     */   {
/* 162 */     Interceptor last = null;
/* 163 */     for (int i = 0; i < chain.size(); i++)
/*     */     {
/* 165 */       Class clazz = (Class)chain.get(i);
/* 166 */       Interceptor interceptor = (Interceptor)clazz.newInstance();
/* 167 */       if (last == null)
/*     */       {
/* 169 */         last = interceptor;
/* 170 */         client.setNext(interceptor);
/*     */       }
/*     */       else
/*     */       {
/* 174 */         last.setNext(interceptor);
/* 175 */         last = interceptor;
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.GenericProxyFactory
 * JD-Core Version:    0.6.0
 */