/*     */ package org.jboss.proxy;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import org.jboss.security.RunAs;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextFactory;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ 
/*     */ abstract interface SecurityActions
/*     */ {
/*  53 */   public static final SecurityActions NON_PRIVILEGED = new SecurityActions()
/*     */   {
/*     */     public Principal getPrincipal()
/*     */     {
/*  58 */       Principal p = null;
/*  59 */       SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  60 */       if (sc != null)
/*     */       {
/*  62 */         p = sc.getUtil().getUserPrincipal();
/*     */       }
/*  64 */       return p;
/*     */     }
/*     */ 
/*     */     public Object getCredential()
/*     */     {
/*  70 */       Object cred = null;
/*  71 */       SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  72 */       if (sc != null)
/*     */       {
/*  74 */         cred = sc.getUtil().getCredential();
/*     */       }
/*  76 */       return cred;
/*     */     }
/*     */ 
/*     */     public RunAs getCallerRunAsIdentity()
/*     */     {
/*  81 */       RunAs rai = null;
/*     */ 
/*  83 */       SecurityContext existingSC = getSecurityContext();
/*  84 */       if (existingSC != null)
/*     */       {
/*  86 */         rai = existingSC.getOutgoingRunAs();
/*     */       }
/*  88 */       return rai;
/*     */     }
/*     */ 
/*     */     public SecurityContext getSecurityContext()
/*     */     {
/*  93 */       return SecurityContextAssociation.getSecurityContext();
/*     */     }
/*     */ 
/*     */     public void setSecurityContext(SecurityContext sc)
/*     */     {
/*  98 */       SecurityContextAssociation.setSecurityContext(sc);
/*     */     }
/*     */ 
/*     */     public SecurityContext createSecurityContext(Principal p, Object cred, String sdomain)
/*     */       throws Exception
/*     */     {
/* 104 */       return SecurityContextFactory.createSecurityContext(p, cred, null, sdomain);
/*     */     }
/*  53 */   };
/*     */ 
/* 108 */   public static final SecurityActions PRIVILEGED = new SecurityActions()
/*     */   {
/* 110 */     private final PrivilegedAction getPrincipalAction = new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 115 */         Principal p = null;
/* 116 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 117 */         if (sc != null)
/*     */         {
/* 119 */           p = sc.getUtil().getUserPrincipal();
/*     */         }
/* 121 */         return p;
/*     */       }
/* 110 */     };
/*     */ 
/* 125 */     private final PrivilegedAction getCredentialAction = new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 130 */         Object cred = null;
/* 131 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/* 132 */         if (sc != null)
/*     */         {
/* 134 */           cred = sc.getUtil().getCredential();
/*     */         }
/* 136 */         return cred;
/*     */       }
/* 125 */     };
/*     */ 
/* 140 */     private final PrivilegedAction getSecurityContextAction = new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 144 */         return SecurityContextAssociation.getSecurityContext();
/*     */       }
/* 140 */     };
/*     */ 
/*     */     public Principal getPrincipal()
/*     */     {
/* 150 */       return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
/*     */     }
/*     */ 
/*     */     public Object getCredential()
/*     */     {
/* 155 */       return AccessController.doPrivileged(this.getCredentialAction);
/*     */     }
/*     */ 
/*     */     public RunAs getCallerRunAsIdentity()
/*     */     {
/* 160 */       return (RunAs)AccessController.doPrivileged(new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 164 */           RunAs rai = null;
/*     */ 
/* 166 */           SecurityContext existingSC = SecurityActions.2.this.getSecurityContext();
/* 167 */           if (existingSC != null)
/*     */           {
/* 169 */             rai = existingSC.getOutgoingRunAs();
/*     */           }
/* 171 */           return rai;
/*     */         }
/*     */       });
/*     */     }
/*     */ 
/*     */     public SecurityContext getSecurityContext() {
/* 178 */       return (SecurityContext)AccessController.doPrivileged(this.getSecurityContextAction);
/*     */     }
/*     */ 
/*     */     public void setSecurityContext(SecurityContext sc)
/*     */     {
/* 183 */       AccessController.doPrivileged(new PrivilegedAction(sc)
/*     */       {
/*     */         public Object run()
/*     */         {
/* 187 */           SecurityContextAssociation.setSecurityContext(this.val$sc);
/* 188 */           return null;
/*     */         }
/*     */       });
/*     */     }
/*     */ 
/*     */     public SecurityContext createSecurityContext(Principal p, Object cred, String sdomain) throws PrivilegedActionException {
/* 195 */       return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(p, cred, sdomain)
/*     */       {
/*     */         public Object run() throws Exception
/*     */         {
/* 199 */           return SecurityContextFactory.createSecurityContext(this.val$p, this.val$cred, null, this.val$sdomain);
/*     */         }
/*     */       });
/*     */     }
/* 108 */   };
/*     */ 
/*     */   public abstract Principal getPrincipal();
/*     */ 
/*     */   public abstract Object getCredential();
/*     */ 
/*     */   public abstract RunAs getCallerRunAsIdentity();
/*     */ 
/*     */   public abstract SecurityContext createSecurityContext(Principal paramPrincipal, Object paramObject, String paramString)
/*     */     throws Exception;
/*     */ 
/*     */   public abstract SecurityContext getSecurityContext();
/*     */ 
/*     */   public abstract void setSecurityContext(SecurityContext paramSecurityContext);
/*     */ 
/*     */   public static class UTIL
/*     */   {
/*     */     static SecurityActions getSecurityActions()
/*     */     {
/*  49 */       return System.getSecurityManager() == null ? SecurityActions.NON_PRIVILEGED : SecurityActions.PRIVILEGED;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.SecurityActions
 * JD-Core Version:    0.6.0
 */