/*     */ package org.jboss.proxy.compiler;
/*     */ 
/*     */ import org.apache.bcel.generic.BasicType;
/*     */ import org.apache.bcel.generic.ObjectType;
/*     */ import org.apache.bcel.generic.Type;
/*     */ import org.jboss.util.UnreachableStatementException;
/*     */ 
/*     */ public abstract class Utility extends org.apache.bcel.classfile.Utility
/*     */ {
/*     */   public static Type getType(Class clazz)
/*     */   {
/*  75 */     if (clazz.isPrimitive()) {
/*  76 */       if (clazz.equals(Boolean.TYPE)) {
/*  77 */         return Type.BOOLEAN;
/*     */       }
/*  79 */       if (clazz.equals(Byte.TYPE)) {
/*  80 */         return Type.BYTE;
/*     */       }
/*  82 */       if (clazz.equals(Character.TYPE)) {
/*  83 */         return Type.CHAR;
/*     */       }
/*  85 */       if (clazz.equals(Double.TYPE)) {
/*  86 */         return Type.DOUBLE;
/*     */       }
/*  88 */       if (clazz.equals(Float.TYPE)) {
/*  89 */         return Type.FLOAT;
/*     */       }
/*  91 */       if (clazz.equals(Integer.TYPE)) {
/*  92 */         return Type.INT;
/*     */       }
/*  94 */       if (clazz.equals(Long.TYPE)) {
/*  95 */         return Type.LONG;
/*     */       }
/*  97 */       if (clazz.equals(Short.TYPE)) {
/*  98 */         return Type.SHORT;
/*     */       }
/* 100 */       if (clazz.equals(Void.TYPE)) {
/* 101 */         return Type.VOID;
/*     */       }
/*     */ 
/* 105 */       throw new UnreachableStatementException();
/*     */     }
/*     */ 
/* 109 */     String name = clazz.getName();
/*     */ 
/* 111 */     if (clazz.isArray()) {
/* 112 */       return Type.getType(name);
/*     */     }
/*     */ 
/* 115 */     return new ObjectType(name);
/*     */   }
/*     */ 
/*     */   public static Type[] getTypes(Class[] classes)
/*     */   {
/* 125 */     Type[] types = new Type[classes.length];
/*     */ 
/* 127 */     for (int i = 0; i < classes.length; i++) {
/* 128 */       types[i] = getType(classes[i]);
/*     */     }
/*     */ 
/* 131 */     return types;
/*     */   }
/*     */ 
/*     */   public static String getObjectEquivalentClassName(BasicType t)
/*     */   {
/* 151 */     switch (t.getType()) {
/*     */     case 10:
/* 153 */       return "java.lang.Integer";
/*     */     case 9:
/* 156 */       return "java.lang.Short";
/*     */     case 4:
/* 159 */       return "java.lang.Boolean";
/*     */     case 5:
/* 162 */       return "java.lang.Character";
/*     */     case 8:
/* 165 */       return "java.lang.Byte";
/*     */     case 6:
/* 168 */       return "java.lang.Float";
/*     */     case 7:
/* 171 */       return "java.lang.Double";
/*     */     case 11:
/* 174 */       return "java.lang.Long";
/*     */     }
/*     */ 
/* 177 */     throw new IllegalArgumentException("Unexpected Type: " + t);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.compiler.Utility
 * JD-Core Version:    0.6.0
 */