/*     */ package org.jboss.proxy.ejb;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.rmi.RemoteException;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.spi.HandleDelegate;
/*     */ import javax.rmi.CORBA.Stub;
/*     */ import javax.rmi.PortableRemoteObject;
/*     */ import org.jboss.iiop.CorbaORB;
/*     */ import org.jboss.proxy.ejb.handle.HandleDelegateImpl;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.portable.ObjectImpl;
/*     */ 
/*     */ public class HandleImplIIOP
/*     */   implements Handle, Serializable
/*     */ {
/*     */   static final long serialVersionUID = -501170775289648475L;
/*     */   private String ior;
/*  59 */   private transient Class<?> stubClass = EJBObject.class;
/*     */ 
/*     */   public HandleImplIIOP(String ior)
/*     */   {
/*  68 */     this.ior = ior;
/*     */   }
/*     */ 
/*     */   public HandleImplIIOP(EJBObject obj)
/*     */   {
/*  78 */     this((org.omg.CORBA.Object)obj);
/*     */   }
/*     */ 
/*     */   public HandleImplIIOP(org.omg.CORBA.Object obj)
/*     */   {
/*  88 */     this.ior = CorbaORB.getInstance().object_to_string(obj);
/*  89 */     this.stubClass = obj.getClass();
/*     */   }
/*     */ 
/*     */   public EJBObject getEJBObject()
/*     */     throws RemoteException
/*     */   {
/*     */     try
/*     */     {
/* 106 */       org.omg.CORBA.Object obj = CorbaORB.getInstance().string_to_object(this.ior);
/* 107 */       return narrow(obj);
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 111 */       throw e;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 115 */     throw new RemoteException("Could not get EJBObject from Handle", e);
/*     */   }
/*     */ 
/*     */   private EJBObject narrow(org.omg.CORBA.Object obj)
/*     */     throws ClassCastException, RemoteException
/*     */   {
/* 122 */     if (obj == null) {
/* 123 */       return null;
/*     */     }
/*     */ 
/* 126 */     if (this.stubClass.isAssignableFrom(obj.getClass())) {
/* 127 */       return (EJBObject)obj;
/*     */     }
/*     */ 
/* 130 */     if (this.stubClass == EJBObject.class) {
/* 131 */       return (EJBObject)PortableRemoteObject.narrow(obj, EJBObject.class);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 136 */       Stub stub = (Stub)this.stubClass.newInstance();
/* 137 */       stub._set_delegate(((ObjectImpl)obj)._get_delegate());
/* 138 */       return (EJBObject)stub;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 142 */     throw new RemoteException("Error creating stub", e);
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream oostream)
/*     */     throws IOException
/*     */   {
/* 148 */     HandleDelegate delegate = HandleDelegateImpl.getDelegate();
/* 149 */     delegate.writeEJBObject(getEJBObject(), oostream);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream oistream) throws IOException, ClassNotFoundException
/*     */   {
/* 154 */     HandleDelegate delegate = HandleDelegateImpl.getDelegate();
/* 155 */     EJBObject obj = delegate.readEJBObject(oistream);
/* 156 */     this.ior = CorbaORB.getInstance().object_to_string((org.omg.CORBA.Object)obj);
/* 157 */     this.stubClass = obj.getClass();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.HandleImplIIOP
 * JD-Core Version:    0.6.0
 */