/*     */ package org.jboss.proxy.ejb.handle;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.spi.HandleDelegate;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.rmi.CORBA.Stub;
/*     */ import javax.rmi.PortableRemoteObject;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ import org.omg.CORBA.BAD_OPERATION;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.portable.ObjectImpl;
/*     */ 
/*     */ public class HandleDelegateImpl
/*     */   implements HandleDelegate
/*     */ {
/*     */   public static HandleDelegate getDelegate()
/*     */   {
/*     */     try
/*     */     {
/*  65 */       InitialContext ctx = new InitialContext();
/*  66 */       return (HandleDelegate)ctx.lookup("java:comp/HandleDelegate");
/*     */     }
/*     */     catch (NamingException e) {
/*     */     }
/*  70 */     throw new NestedRuntimeException(e);
/*     */   }
/*     */ 
/*     */   public void writeEJBObject(EJBObject ejbObject, ObjectOutputStream oostream)
/*     */     throws IOException
/*     */   {
/*  79 */     oostream.writeObject(ejbObject);
/*     */   }
/*     */ 
/*     */   public EJBObject readEJBObject(ObjectInputStream oistream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  85 */     Object ejbObject = oistream.readObject();
/*  86 */     reconnect(ejbObject);
/*  87 */     return (EJBObject)PortableRemoteObject.narrow(ejbObject, EJBObject.class);
/*     */   }
/*     */ 
/*     */   public void writeEJBHome(EJBHome ejbHome, ObjectOutputStream oostream)
/*     */     throws IOException
/*     */   {
/*  93 */     oostream.writeObject(ejbHome);
/*     */   }
/*     */ 
/*     */   public EJBHome readEJBHome(ObjectInputStream oistream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  99 */     Object ejbHome = oistream.readObject();
/* 100 */     reconnect(ejbHome);
/* 101 */     return (EJBHome)PortableRemoteObject.narrow(ejbHome, EJBHome.class);
/*     */   }
/*     */ 
/*     */   protected void reconnect(Object object) throws IOException
/*     */   {
/* 106 */     if ((object instanceof ObjectImpl))
/*     */     {
/*     */       try
/*     */       {
/* 111 */         ObjectImpl objectImpl = (ObjectImpl)object;
/* 112 */         objectImpl._get_delegate();
/*     */       }
/*     */       catch (BAD_OPERATION e)
/*     */       {
/*     */         try
/*     */         {
/* 119 */           Stub stub = (Stub)object;
/* 120 */           ORB orb = (ORB)new InitialContext().lookup("java:comp/ORB");
/* 121 */           stub.connect(orb);
/*     */         }
/*     */         catch (NamingException ne)
/*     */         {
/* 125 */           throw new IOException("Unable to lookup java:comp/ORB");
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/* 130 */       throw new IOException("Not an ObjectImpl " + object.getClass().getName());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.handle.HandleDelegateImpl
 * JD-Core Version:    0.6.0
 */