/*     */ package org.jboss.proxy.ejb.handle;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectInputStream.GetField;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectOutputStream.PutField;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.rmi.RemoteException;
/*     */ import java.rmi.ServerException;
/*     */ import java.util.Hashtable;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.HomeHandle;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.naming.NamingContextFactory;
/*     */ 
/*     */ public class HomeHandleImpl
/*     */   implements HomeHandle
/*     */ {
/*     */   static final long serialVersionUID = 208629381571948124L;
/*  54 */   private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("jndiName", String.class), new ObjectStreamField("jndiEnv", Hashtable.class) };
/*     */   private String jndiName;
/*     */   private Hashtable jndiEnv;
/*     */ 
/*     */   public HomeHandleImpl(String jndiName)
/*     */   {
/*  80 */     this.jndiName = jndiName;
/*  81 */     this.jndiEnv = ((Hashtable)NamingContextFactory.lastInitialContextEnv.get());
/*     */   }
/*     */ 
/*     */   public EJBHome getEJBHome()
/*     */     throws RemoteException
/*     */   {
/*     */     try
/*     */     {
/* 100 */       InitialContext ic = null;
/* 101 */       if (this.jndiEnv != null)
/* 102 */         ic = new InitialContext(this.jndiEnv);
/*     */       else
/* 104 */         ic = new InitialContext();
/* 105 */       EJBHome home = (EJBHome)ic.lookup(this.jndiName);
/* 106 */       return home;
/*     */     }
/*     */     catch (NamingException e) {
/*     */     }
/* 110 */     throw new ServerException("Could not get EJBHome", e);
/*     */   }
/*     */ 
/*     */   public String getJNDIName()
/*     */   {
/* 119 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream ois)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 125 */     ObjectInputStream.GetField getField = ois.readFields();
/* 126 */     this.jndiName = ((String)getField.get("jndiName", null));
/* 127 */     this.jndiEnv = ((Hashtable)getField.get("jndiEnv", null));
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream oos)
/*     */     throws IOException
/*     */   {
/* 133 */     ObjectOutputStream.PutField putField = oos.putFields();
/* 134 */     putField.put("jndiName", this.jndiName);
/* 135 */     putField.put("jndiEnv", this.jndiEnv);
/* 136 */     oos.writeFields();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.handle.HomeHandleImpl
 * JD-Core Version:    0.6.0
 */