/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import org.jboss.metadata.spi.signature.Signature;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ArrayInfo;
/*     */ import org.jboss.reflect.spi.PrimitiveInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ 
/*     */ public class ArrayInfoImpl extends ClassInfoImpl
/*     */   implements ArrayInfo
/*     */ {
/*     */   private static final long serialVersionUID = 3905804162787980599L;
/*     */   protected TypeInfo componentType;
/*  48 */   protected int hash = -1;
/*     */ 
/*     */   public ArrayInfoImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ArrayInfoImpl(TypeInfo componentType)
/*     */   {
/*  64 */     if (componentType == null) {
/*  65 */       throw new IllegalArgumentException("Null component type.");
/*     */     }
/*  67 */     this.componentType = componentType;
/*  68 */     StringBuilder builder = new StringBuilder();
/*  69 */     builder.append("[");
/*  70 */     TypeInfo temp = componentType;
/*  71 */     while (temp.isArray())
/*     */     {
/*  73 */       builder.append("[");
/*  74 */       temp = ((ArrayInfo)temp).getComponentType();
/*     */     }
/*  76 */     if (PrimitiveInfo.class.equals(temp.getClass()))
/*     */     {
/*  79 */       String encodedName = Signature.getPrimativeArrayType(temp.getName());
/*  80 */       builder.append(encodedName);
/*     */     }
/*     */     else
/*     */     {
/*  84 */       builder.append("L").append(temp.getName()).append(";");
/*     */     }
/*  86 */     this.name = builder.toString();
/*  87 */     calculateHash();
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public Class<? extends Object> getType()
/*     */   {
/*  94 */     if (this.annotatedElement == null)
/*     */     {
/*     */       try
/*     */       {
/*  98 */         TypeInfoFactory tif = SerializationHelper.getTypeInfoFactory();
/*  99 */         this.annotatedElement = tif.getTypeInfo(this.name, this.componentType.getType().getClassLoader()).getType();
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 103 */         throw new UndeclaredThrowableException(t);
/*     */       }
/*     */     }
/* 106 */     return (Class)this.annotatedElement;
/*     */   }
/*     */ 
/*     */   public TypeInfo getComponentType()
/*     */   {
/* 111 */     return this.componentType;
/*     */   }
/*     */ 
/*     */   public AnnotationValue getAnnotation(String name)
/*     */   {
/* 116 */     return null;
/*     */   }
/*     */ 
/*     */   public AnnotationValue[] getAnnotations()
/*     */   {
/* 121 */     return UNKNOWN_ANNOTATIONS;
/*     */   }
/*     */ 
/*     */   public boolean isAnnotationPresent(String name)
/*     */   {
/* 126 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 131 */     if (this == o) return true;
/* 132 */     if (!(o instanceof ArrayInfo)) return false;
/* 133 */     if (!super.equals(o)) return false;
/*     */ 
/* 135 */     ArrayInfo arrayInfo = (ArrayInfo)o;
/*     */ 
/* 137 */     return this.componentType.equals(arrayInfo.getComponentType());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 142 */     return this.hash;
/*     */   }
/*     */ 
/*     */   protected void calculateHash()
/*     */   {
/* 149 */     int result = super.hashCode();
/* 150 */     result = 29 * result + this.componentType.hashCode();
/* 151 */     this.hash = result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.ArrayInfoImpl
 * JD-Core Version:    0.6.0
 */