/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import org.jboss.reflect.spi.EnumConstantInfo;
/*     */ import org.jboss.reflect.spi.EnumInfo;
/*     */ 
/*     */ public class EnumInfoImpl extends ClassInfoImpl
/*     */   implements EnumInfo
/*     */ {
/*     */   private static final long serialVersionUID = 3617851958849713457L;
/*     */   protected EnumConstantInfoImpl[] enumConstants;
/*  44 */   protected HashMap<String, EnumConstantInfo> constants = new HashMap();
/*     */ 
/*     */   public EnumInfoImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public EnumInfoImpl(String name, int modifiers)
/*     */   {
/*  61 */     super(name, modifiers);
/*     */   }
/*     */ 
/*     */   public void setEnumConstants(EnumConstantInfoImpl[] enumConstants)
/*     */   {
/*  71 */     for (int i = 0; i < enumConstants.length; i++)
/*  72 */       this.constants.put(enumConstants[i].getName(), enumConstants[i]);
/*  73 */     this.enumConstants = enumConstants;
/*     */   }
/*     */ 
/*     */   public EnumConstantInfo[] getEnumConstants()
/*     */   {
/*  78 */     return this.enumConstants;
/*     */   }
/*     */ 
/*     */   public EnumConstantInfo getEnumConstant(String name)
/*     */   {
/*  83 */     return (EnumConstantInfo)this.constants.get(name);
/*     */   }
/*     */ 
/*     */   public Object getEnumValue(String name)
/*     */   {
/*  89 */     return Enum.valueOf(getType(), name);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/*  95 */     if (this == o) return true;
/*  96 */     if ((o == null) || (!(o instanceof EnumInfo))) return false;
/*  97 */     if (!super.equals(o)) return false;
/*     */ 
/*  99 */     EnumInfo enumInfo = (EnumInfo)o;
/*     */ 
/* 101 */     return getName().equals(enumInfo.getName());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.EnumInfoImpl
 * JD-Core Version:    0.6.0
 */