/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import org.jboss.reflect.spi.AbstractValue;
/*     */ import org.jboss.reflect.spi.EnumValue;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class EnumValueImpl extends AbstractValue
/*     */   implements EnumValue
/*     */ {
/*     */   private static final long serialVersionUID = 4120848858889662517L;
/*     */   protected TypeInfo type;
/*     */   protected String value;
/*  46 */   protected int hash = -1;
/*     */ 
/*     */   public EnumValueImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public EnumValueImpl(TypeInfo type, String value)
/*     */   {
/*  63 */     this.type = type;
/*  64 */     this.value = value;
/*  65 */     calculateHash();
/*     */   }
/*     */ 
/*     */   public boolean isEnum()
/*     */   {
/*  71 */     return true;
/*     */   }
/*     */ 
/*     */   public String getValue()
/*     */   {
/*  76 */     return this.value;
/*     */   }
/*     */ 
/*     */   public TypeInfo getType()
/*     */   {
/*  81 */     return this.type;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/*  86 */     if (this == o) return true;
/*  87 */     if (!(o instanceof EnumValueImpl)) return false;
/*     */ 
/*  89 */     EnumValueImpl enumValue = (EnumValueImpl)o;
/*     */ 
/*  91 */     if (this.type != null ? !this.type.equals(enumValue.type) : enumValue.type != null) return false;
/*  92 */     return this.value != null ? this.value.equals(enumValue.value) : enumValue.value == null;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  99 */     return this.hash;
/*     */   }
/*     */ 
/*     */   protected void calculateHash()
/*     */   {
/* 108 */     int result = this.type != null ? this.type.hashCode() : 0;
/* 109 */     result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
/* 110 */     this.hash = result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.EnumValueImpl
 * JD-Core Version:    0.6.0
 */