/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.lang.reflect.Modifier;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.FieldInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ 
/*     */ public class FieldInfoImpl extends AnnotationHolder
/*     */   implements FieldInfo
/*     */ {
/*     */   private static final long serialVersionUID = 3546084661584539959L;
/*     */   protected String name;
/*     */   protected TypeInfo type;
/*     */   protected int modifiers;
/*     */   protected ClassInfo declaringClass;
/*  57 */   protected int hash = -1;
/*     */ 
/*     */   public FieldInfoImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public FieldInfoImpl(AnnotationValue[] annotations, String name, TypeInfo type, int modifiers, ClassInfo declaring)
/*     */   {
/*  77 */     super(annotations);
/*  78 */     this.name = name;
/*  79 */     this.type = type;
/*  80 */     this.modifiers = modifiers;
/*  81 */     this.declaringClass = declaring;
/*  82 */     calculateHash();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  87 */     return this.name;
/*     */   }
/*     */ 
/*     */   public TypeInfo getType()
/*     */   {
/*  92 */     return this.type;
/*     */   }
/*     */ 
/*     */   public ClassInfo getDeclaringClass()
/*     */   {
/*  97 */     return this.declaringClass;
/*     */   }
/*     */ 
/*     */   public int getModifiers()
/*     */   {
/* 102 */     return this.modifiers;
/*     */   }
/*     */ 
/*     */   public boolean isStatic()
/*     */   {
/* 107 */     return Modifier.isStatic(this.modifiers);
/*     */   }
/*     */ 
/*     */   public boolean isPublic()
/*     */   {
/* 112 */     return Modifier.isPublic(this.modifiers);
/*     */   }
/*     */ 
/*     */   public boolean isVolatile()
/*     */   {
/* 117 */     return Modifier.isVolatile(this.modifiers);
/*     */   }
/*     */ 
/*     */   public Object get(Object target) throws Throwable
/*     */   {
/* 122 */     throw new NotImplementedException("get");
/*     */   }
/*     */ 
/*     */   public Object set(Object target, Object value) throws Throwable
/*     */   {
/* 127 */     throw new NotImplementedException("set");
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 132 */     buffer.append("name=").append(this.name);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 137 */     if (this == obj) return true;
/* 138 */     if ((obj == null) || (!(obj instanceof FieldInfo))) {
/* 139 */       return false;
/*     */     }
/* 141 */     FieldInfo other = (FieldInfo)obj;
/*     */ 
/* 143 */     if (!this.name.equals(other.getName()))
/* 144 */       return false;
/* 145 */     return this.declaringClass.equals(other.getDeclaringClass());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 150 */     return this.hash;
/*     */   }
/*     */ 
/*     */   protected void calculateHash()
/*     */   {
/* 158 */     this.hash = this.name.hashCode();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.FieldInfoImpl
 * JD-Core Version:    0.6.0
 */