/*    */ package org.jboss.reflect.plugins;
/*    */ 
/*    */ import org.jboss.reflect.spi.AbstractValue;
/*    */ import org.jboss.reflect.spi.StringValue;
/*    */ import org.jboss.reflect.spi.TypeInfo;
/*    */ 
/*    */ public class StringValueImpl extends AbstractValue
/*    */   implements StringValue
/*    */ {
/*    */   private static final long serialVersionUID = 3977862864859836468L;
/*    */   protected String value;
/*    */   protected TypeInfo type;
/*    */ 
/*    */   public StringValueImpl()
/*    */   {
/*    */   }
/*    */ 
/*    */   public StringValueImpl(String value, TypeInfo type)
/*    */   {
/* 60 */     this.value = value;
/* 61 */     this.type = type;
/*    */   }
/*    */ 
/*    */   public boolean isString()
/*    */   {
/* 67 */     return true;
/*    */   }
/*    */ 
/*    */   public String getValue()
/*    */   {
/* 72 */     return this.value;
/*    */   }
/*    */ 
/*    */   public TypeInfo getType()
/*    */   {
/* 77 */     return this.type;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object o)
/*    */   {
/* 82 */     if (this == o) return true;
/* 83 */     if (!(o instanceof StringValueImpl)) return false;
/*    */ 
/* 85 */     StringValueImpl primitiveValue = (StringValueImpl)o;
/*    */ 
/* 87 */     if (!this.type.equals(primitiveValue.type)) return false;
/* 88 */     return this.value.equals(primitiveValue.value);
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 96 */     int result = this.value != null ? this.value.hashCode() : 0;
/* 97 */     result = 29 * result + this.type.hashCode();
/* 98 */     return result;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.StringValueImpl
 * JD-Core Version:    0.6.0
 */