/*     */ package org.jboss.reflect.plugins.introspection;
/*     */ 
/*     */ import java.lang.reflect.ParameterizedType;
/*     */ import org.jboss.reflect.plugins.ClassInfoImpl;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.DelegateClassInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class ParameterizedClassInfo extends DelegateClassInfo
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   protected transient IntrospectionTypeInfoFactoryImpl factory;
/*     */   transient ParameterizedType parameterizedType;
/*  51 */   private TypeInfo ownerType = ClassInfoImpl.UNKNOWN_TYPE;
/*     */ 
/*  54 */   private TypeInfo[] typeArguments = ClassInfoImpl.UNKNOWN_TYPES;
/*     */ 
/*  57 */   private transient TypeInfo componentType = ClassInfoImpl.UNKNOWN_TYPE;
/*     */ 
/*  60 */   private transient TypeInfo keyType = ClassInfoImpl.UNKNOWN_TYPE;
/*     */ 
/*  63 */   private transient TypeInfo valueType = ClassInfoImpl.UNKNOWN_TYPE;
/*     */ 
/*     */   public ParameterizedClassInfo(IntrospectionTypeInfoFactoryImpl factory, ClassInfo delegate, ParameterizedType parameterizedType)
/*     */   {
/*  74 */     super(delegate);
/*  75 */     this.factory = factory;
/*  76 */     this.delegate = delegate;
/*  77 */     this.parameterizedType = parameterizedType;
/*     */   }
/*     */ 
/*     */   public TypeInfoFactory getTypeInfoFactory()
/*     */   {
/*  82 */     return this.factory;
/*     */   }
/*     */ 
/*     */   public TypeInfo[] getActualTypeArguments()
/*     */   {
/*  88 */     if (this.typeArguments == ClassInfoImpl.UNKNOWN_TYPES)
/*  89 */       this.typeArguments = this.factory.getActualTypeArguments(this);
/*  90 */     return this.typeArguments;
/*     */   }
/*     */ 
/*     */   public TypeInfo getOwnerType()
/*     */   {
/*  96 */     if (this.ownerType == ClassInfoImpl.UNKNOWN_TYPE)
/*  97 */       this.ownerType = this.factory.getOwnerType(this);
/*  98 */     return this.ownerType;
/*     */   }
/*     */ 
/*     */   public ClassInfo getRawType()
/*     */   {
/* 104 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public TypeInfo getComponentType()
/*     */   {
/* 110 */     if (this.componentType == ClassInfoImpl.UNKNOWN_TYPE)
/* 111 */       this.componentType = this.factory.getComponentType(this);
/* 112 */     return this.componentType;
/*     */   }
/*     */ 
/*     */   public TypeInfo getKeyType()
/*     */   {
/* 118 */     if (this.keyType == ClassInfoImpl.UNKNOWN_TYPE);
/* 119 */     this.keyType = this.factory.getKeyType(this);
/* 120 */     return this.keyType;
/*     */   }
/*     */ 
/*     */   public TypeInfo getValueType()
/*     */   {
/* 126 */     if (this.valueType == ClassInfoImpl.UNKNOWN_TYPE)
/* 127 */       this.valueType = this.factory.getValueType(this);
/* 128 */     return this.valueType;
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 134 */     buffer.append(this.parameterizedType);
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 140 */     buffer.append(this.parameterizedType);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.introspection.ParameterizedClassInfo
 * JD-Core Version:    0.6.0
 */